<?php

if (!defined( 'ABSPATH' )) {
	exit;
}
if (!class_exists( 'Ova_Tema_Customize' )){

	class Ova_Tema_Customize {

		public function __construct() {
			add_action( 'customize_register', array( $this, 'ova_team_customize_register' ) );
		}

		public function ova_team_customize_register($wp_customize) {

			$this->ova_team_init( $wp_customize );

			do_action( 'ova_team_customize_register', $wp_customize );
		}


		/* Team */
		public function ova_team_init( $wp_customize ){

			$wp_customize->add_panel( 'ova_team_section', array(
			    'title'      => esc_html__( 'Team', 'ova-team' ),
			    'priority' => 5,
			) );


			$wp_customize->add_section( 'ova_team_section_archive' , array(
				    'title'      => esc_html__( 'Archive', 'ova-team' ),
				    'priority'   => 30,
				    'panel' => 'ova_team_section',
				) );

				$wp_customize->add_setting( 'ova_team_total_record', array(
					  'type' => 'theme_mod', // or 'option'
					  'capability' => 'edit_theme_options',
					  'theme_supports' => '', // Rarely needed.
					  'default' => '9',
					  'transport' => 'refresh', // or postMessage
					  'sanitize_callback' => 'sanitize_text_field' // Get function name 
					  
				) );
				
				$wp_customize->add_control('ova_team_total_record', array(
					'label' => esc_html__('Number of posts per page','ova-team'),
					'section' => 'ova_team_section_archive',
					'settings' => 'ova_team_total_record',
					'type' =>'number'
				));


				$wp_customize->add_setting( 'ova_team_layout', array(
					  'type' => 'theme_mod', // or 'option'
					  'capability' => 'edit_theme_options',
					  'theme_supports' => '', // Rarely needed.
					  'default' => 'three_column',
					  'transport' => 'refresh', // or postMessage
					  'sanitize_callback' => 'sanitize_text_field' // Get function name 
					  
					) );
				$wp_customize->add_control('ova_team_layout', array(
					'label' => esc_html__('Layout','ova-team'),
					'section' => 'ova_team_section_archive',
					'settings' => 'ova_team_layout',
					'type' =>'select',
					'choices' => array(
						'two_column'      => __( '2 column', 'ova-team' ),
						'three_column' => __( '3 column', 'ova-team' ),
						'four_column'      => __( '4 column', 'ova-team' ),
					)
				));
				

				$wp_customize->add_setting( 'header_archive_team', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'default',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 
				  
				) );

				$wp_customize->add_control('header_archive_team', array(
					'label' => esc_html__('Header Archive','ova-team'),
					'section' => 'ova_team_section_archive',
					'settings' => 'header_archive_team',
					'type' =>'select',
					'choices' => apply_filters('yachbat_list_header', '')
				));

				$wp_customize->add_setting( 'archive_footer_team', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'default',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 
				  
				) );

				$wp_customize->add_control('archive_footer_team', array(
					'label' => esc_html__('Footer Archive','ova-team'),
					'section' => 'ova_team_section_archive',
					'settings' => 'archive_footer_team',
					'type' =>'select',
					'choices' => apply_filters('yachbat_list_footer', '')
				));


			$wp_customize->add_section( 'ova_team_section_single' , array(
			    'title'      => esc_html__( 'Single', 'ova-team' ),
			    'priority'   => 30,
			    'panel' => 'ova_team_section',
			) );


			    $wp_customize->add_setting( 'single_team_template', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'template2',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 
				) );

					$wp_customize->add_control('single_team_template', array(
						'label' => esc_html__('Template','ova-team'),
						'section' => 'ova_team_section_single',
						'settings' => 'single_team_template',
						'type' =>'select',
						'choices' => array(
							'template1' => esc_html__('Template 1', 'ova-team'),
							'template2' => esc_html__('Template 2', 'ova-team'),
						)
					));

				$wp_customize->add_setting( 'header_single_team', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'default',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 	  
				) );

				$wp_customize->add_control('header_single_team', array(
					'label' => esc_html__('Header Single','ova-team'),
					'section' => 'ova_team_section_single',
					'settings' => 'header_single_team',
					'type' =>'select',
					'choices' => apply_filters('yachbat_list_header', '')
				));

				$wp_customize->add_setting( 'single_footer_team', array(
				  'type' => 'theme_mod', // or 'option'
				  'capability' => 'edit_theme_options',
				  'theme_supports' => '', // Rarely needed.
				  'default' => 'default',
				  'transport' => 'refresh', // or postMessage
				  'sanitize_callback' => 'sanitize_text_field' // Get function name 
				  
				) );

				$wp_customize->add_control('single_footer_team', array(
					'label' => esc_html__('Footer Single','ova-team'),
					'section' => 'ova_team_section_single',
					'settings' => 'single_footer_team',
					'type' =>'select',
					'choices' => apply_filters('yachbat_list_footer', '')
				));

		}

	}

}

new Ova_Tema_Customize();






