<?php
/**
 * Setup yachbat Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 */



add_action('rest_api_init', function () {
    register_rest_route('getyourguide', '1/get-availabilities', array(
        'methods' => 'GET',
        'callback' => 'get_availabilities1'
    ));
    register_rest_route('getyourguide', '1/reserve', array(
        'methods' => 'POST',
        'callback' => 'reserve_booking1'
    ));
    register_rest_route('getyourguide', '1/book', array(
        'methods' => 'POST',
        'callback' => 'book_charter1'
    ));
    register_rest_route('getyourguide', '1/cancel-reservation', array(
        'methods' => 'POST',
        'callback' => 'cancel_reservation1'
    ));
    register_rest_route('getyourguide', '1/cancel-booking', array(
        'methods' => 'POST',
        'callback' => 'cancel_booking1'
    ));
    // register_rest_route('getyourguide', '1/products/(?P<id>\d+)', array(
    //     'methods' => 'GET',
    //     'callback' => 'products2'
    // ));
    register_rest_route('getyourguide', '1/cancel-reserve', array(
        'methods' => 'POST',
        'callback' => 'reservation1_cancel'
    ));
    
});

function set_rest_api_timezone() {
    $timezone_string = get_option('timezone_string');
    date_default_timezone_set($timezone_string);
}


function woocommerce_product_custom_fields_save($post_id)
{
    // Custom Product Text Field
    $getyourguide_id = $_POST['getyourguide_id'];
    if (!empty($getyourguide_id)){
        update_post_meta($post_id, 'getyourguide_id', esc_attr($getyourguide_id));
    }
        
}
 // Save Fields
add_action('woocommerce_process_product_meta', 'woocommerce_product_custom_fields_save');   


function woocommerce_product_custom_fields_display()
{
    global $woocommerce, $post;
    echo '<div class="product_custom_field">';
    // Custom Product Text Field
    woocommerce_wp_text_input(
        array(
            'id' => 'getyourguide_id',
            'placeholder' => 'Get your guide product id',
            'label' => __('Get your guide product id', 'woocommerce'),
            'desc_tip' => 'true'
        )
    );

    echo '</div>';
}
// Display Fields
add_action('woocommerce_product_options_general_product_data', 'woocommerce_product_custom_fields_display');

function fetch_charter_list(){
           $args_query = [
            'post_type'         => 'product',
            'post_status'       => 'publish',
            'posts_per_page'    => -1,
            'orderby'           => 'title',
            'order'             => 'DESC',
            'fields'            => 'ids',
            'tax_query'         => [],
        ];
        $products  =  wc_get_products( $args_query );    
       return $products;
}

 function get_availabilities1() {
    set_rest_api_timezone();
    $fromDateTime_iso = isset($_GET['fromDateTime']) ? $_GET['fromDateTime'] : '';
    $toDateTime_iso = isset($_GET['toDateTime']) ? $_GET['toDateTime'] : '';
    $input_prd_id = isset($_GET['productId']) ? $_GET['productId'] : '';
    
    $fromDateTime_iso = str_replace(' ', '+', $fromDateTime_iso);
    $FrmDateTime_obj = new DateTime($fromDateTime_iso);

    $toDateTime_iso = str_replace(' ', '+', $toDateTime_iso);
    $toDateTime_obj = new DateTime($toDateTime_iso);
    //$Fdate_part = substr($fromDateTime_iso, 0, 10);
 
    //$Fdatetime = new DateTime($Fdate_part);
    //$Fdatetime->setTimezone(new DateTimeZone('+02:00'));
    $FrmDateTime_format = $FrmDateTime_obj->format('Y-m-d');




    $downFrmDateTime = "2024-12-01";
    $downToDateTime  = "2025-02-28";


   // $tdate_parts = explode("T", $toDateTime_iso);
    $toDateTime_format = $toDateTime_obj->format('Y-m-d');

    $downtime_start = strtotime($downFrmDateTime);
    $downtime_end = strtotime($downToDateTime);

    $requested_start = strtotime($FrmDateTime_format);
    $requested_end = strtotime($toDateTime_format);

    if (($requested_start >= $downtime_start && $requested_start <= $downtime_end) || ($requested_end >= $downtime_start && $requested_end <= $downtime_end)) {
        $downSlots = array('availabilities' => array());
        $currentDate = $requested_start;
         while ($currentDate <= $requested_end) {
            $downSlots['availabilities'][] = array(
                'dateTime' => date('c', $currentDate),
                'openingTimes' => array(
                    array('fromTime' => "10:00 AM")
                ),
                'productId' => $input_prd_id,
                'cutoffSeconds' => 0,
                'vacancies' => 0
            );
        $currentDate = strtotime('+1 day', $currentDate);
    }
    return new WP_REST_Response(array('data' => $downSlots), 200);
    
    }

    
    if (empty($fromDateTime_iso) || empty($toDateTime_iso) || empty($input_prd_id)) {
        $response = array(
            "errorCode" => "VALIDATION_FAILURE",
            "errorMessage" => "Missing required parameters"
        );
        return new WP_REST_Response($response);
    }

    $products = fetch_charter_list();

    $ordered_list = array();
    $prdlist = array();

    $product_found = false;
    foreach ($products as $product) {
        if (get_post_meta($product->get_id(), 'getyourguide_id', true) == $input_prd_id) {
            $product_found = true;

            $args = array(
                'status' => array('wc-completed', 'wc-on-hold', 'wc-pending'),
                'limit' => -1
            );
            $orders = wc_get_orders($args);
            foreach ($orders as $order) {
                $items = $order->get_items();
                foreach ($items as $item) {
                    $prd_id_ordered = $item->get_product_id();
                    if ($prd_id_ordered == $product->get_id()) {
                        $ordered_list[] = array(
                            'prd_id' => $prd_id_ordered,
                            'order_datetime' => date('c', strtotime($item->get_meta('ovabrw_pickup_date')))
                        );
                    }
                }
            }

            $fromDate_arr = explode("T", $fromDateTime_iso);
            $toDate_arr = explode("T", $toDateTime_iso);
            $fromDate = $fromDate_arr[0];
            $toDate = $toDate_arr[0];
            $fromTime = get_post_meta($product->get_id(), 'ovabrw_pehour_start_time', true);
            $toTime = get_post_meta($product->get_id(), 'ovabrw_pehour_end_time', true);
           // $peak_low_value = get_post_meta($product->get_id(), 'ovabrw_petime_ispeak', true);
            while ($fromDate <= $toDate) {
                foreach ($fromTime as $index => $fromTime_each) {

                   // $peak_low_this = $peak_low_value[$index];
                    $date_time_listed = $fromDate . " " . $fromTime_each;


                    // if($start_date > strtotime($unavail_dec) || $start_date < strtotime($unavail_feb)){
                    //     $start_date_type = "unavailable";
                       
                    // }elseif( ( $start_date > strtotime($low_1) && $start_date < strtotime($low_2) ) || ($start_date > strtotime($low_3) && $start_date < strtotime($low_4) ) ){
                    //     $start_date_type = "low";
                    // }elseif($start_date > strtotime($peak_1) || $start_date < strtotime($peak_2)){
                    //     $start_date_type = "peak";
                    // }




                    $prdlist[] = array(
                        'dateTime' => date('c', strtotime($date_time_listed)),
                        'openingTimes' => array(
                            array('fromTime' => $fromTime_each)
                        ),
                        'productId' => $input_prd_id,
                        'cutoffSeconds' => 0,
                        'vacancies' => 10
                    );
                }
                $fromDate = date('Y-m-d', strtotime("+1 day", strtotime($fromDate)));
            }

            break; 
        }
    }

    if (!$product_found) {
        $response = array(
            "errorCode" => "INVALID_PRODUCT",
            "errorMessage" => "Invalid productId"
        );
        return new WP_REST_Response($response);
    }


    
    if(isset($prdlist)){
    $availableSlots = array();
    foreach ($prdlist as $slot) {
        $slotDateTime = $slot['dateTime'];
        $matchFound = false;
        foreach ($ordered_list as $unavailableSlot) {
            $unavailableDateTime = $unavailableSlot['order_datetime'];
            if ($unavailableDateTime === $slotDateTime) {
                $matchFound = true;
                $slot['vacancies'] = 0;
                break;
            }
        }
        if (!$matchFound) {
            $availableSlots[] = $slot;
        }
    }

    $availabilities = array(
        'availabilities' => $availableSlots
    );
    return new WP_REST_Response(array('data' => $availabilities), 200);
    }

}


function reserve_booking1($request) {
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);

    if (empty($request_data['data']['bookingItems']) || empty($request_data['data']['dateTime']) || empty($request_data['data']['productId']) || empty($request_data['data']['gygBookingReference'])) {
        return new WP_REST_Response(array('error' => 'Invalid request data'), 400);
    }
    $max_group_size = 10;

    $request_date_iso = $request_data['data']['dateTime'];
    $request_date_obj = new DateTime($request_date_iso);
    $request_date = $request_date_obj->format('Y-m-d h:i A');

    $category = $request_data['data']['bookingItems'][0]['category'];
    if ($category != 'GROUP') {
        $response = array(
            "errorCode" => "INVALID_TICKET_CATEGORY",
            "errorMessage" => "Invalid ticket category",
            "ticketCategory"=> "GROUP"
        );
        return new WP_REST_Response($response);
    }

    $groupSize = $request_data['data']['bookingItems'][0]['groupSize'];

    $input_prd_id = $request_data['data']['productId'];
    $products = fetch_charter_list();
    $product_valid = false;
    $response_data = array();
    if ($groupSize <= $max_group_size) {
        $reqDateTime = new DateTime($request_date_iso);
        $downtime_start = new DateTime("2024-12-01");
        $downtime_end = new DateTime("2025-02-28");

        if ($reqDateTime >= $downtime_start && $reqDateTime <= $downtime_end) {
            $response = array(
                "errorCode" => "NO_AVAILABILITY",
                "errorMessage" => "No availability for the requested date and time."
            );
            return new WP_REST_Response($response);
        }

        foreach ($products as $product) {
            $product_id = get_post_meta($product->get_id(), 'getyourguide_id', true);

            if ($product_id == $input_prd_id) {
                $product_valid = true;

                $fromTime = get_post_meta($product->get_id(), 'ovabrw_pehour_start_time', true);

                foreach ($fromTime as $index => $fromTime_each ) {
                    if ($fromTime_each == $request_date_obj->format('g:i A')) {
                        $ovabrw_petime_price = get_post_meta($product->get_id(), 'ovabrw_petime_price', true);
                        $price = $ovabrw_petime_price[$index];
                        break;
                    }
                }

                $order = wc_create_order();
                $args = array(
                    'subtotal'     => $price,
                    'total'        => $price,
                );
                $order->add_product(wc_get_product($product->get_id()), 1, $args);
                $order->calculate_totals();
                $order->update_meta_data('gygBookingReference', $request_data['data']['gygBookingReference']);
                $order->update_status('on-hold');
                $order->save();
                

                foreach ($order->get_items() as $item_id => $item) {
                    $item_product_id = $item->get_product_id();
                    if ($item_product_id == $product_id) {
                        wc_update_order_item_meta($item_id, 'ovabrw_pickup_date', $request_date_obj->format('d-m-Y h:i A'));
                        wc_update_order_item_meta($item_id, 'ovabrw_price_detail', '&euro;' . $price);
                    }
                }

                $response_data = array(
                    'data' => array(
                        'reservationReference' => $order->get_order_number(),
                        'reservationExpiration' => Date('c', strtotime("+1 hour"))
                    )
                );


                break;
            }
        }
    }

    if ($product_valid) {
        $response = new WP_REST_Response($response_data, 200);
        
        if ($response->status === 200) {
            send_push_notification_booking($order, $input_prd_id);
            // $formatted_notification_result = new WP_REST_Response($push_notification_result, 200);
            // print_r($formatted_notification_result);
            //return $formatted_notification_result;
        }
        return $response;
    }else {
            $response = array(
                "errorCode" => "INVALID_PRODUCT",
                "errorMessage" => "Invalid productId"
            );
            return new WP_REST_Response($response);
    }
}

// function products2($request){
// $productId = $request['id'];
// $product = wc_get_product( $productId );
//     $fromTime = get_post_meta( $product->get_id(), 'ovabrw_pehour_start_time', true );
//     $toTime     = get_post_meta( $product->get_id(), 'ovabrw_pehour_end_time', true );
    

//     $prdData=   array(
//         'supplierId' => '',
//         'productTitle' => $product->get_title(),
//         'productDescription' => $product->post->post_content,
//         'destinationLocation' => array(
//             'city' => 'Malta',
//              'country' => 'Malta'
//             ),
//         'configuration' => array(
//             'participantsConfiguration' => array(
//                 'min' => 1,
//                  'max' => 10
//                 )
//          )
//     );

  
//     return new WP_REST_Response(array('data' => $prdData), 200);
// }


function book_charter1($request) {
    set_rest_api_timezone();
    global $woocommerce;

    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);
    $max_group_size = 10;
    if (empty($request_data['data']['bookingItems']) || empty($request_data['data']['dateTime']) || empty($request_data['data']['currency']) || empty($request_data['data']['gygBookingReference']) || empty($request_data['data']['productId']) || empty($request_data['data']['reservationReference']) || empty($request_data['data']['travelers'])) {
        return new WP_REST_Response(array('error' => 'Invalid request data'), 400);
    }

    $category = $request_data['data']['bookingItems'][0]['category'];
    if ($category != 'GROUP') {
        $response = array(
            "errorCode" => "INVALID_TICKET_CATEGORY",
            "errorMessage" => "Invalid ticket category",
            "ticketCategory"=> "GROUP"
        );
        return new WP_REST_Response($response);
    }

    $groupSize = $request_data['data']['bookingItems'][0]['groupSize'];
    if ($groupSize > $max_group_size) {
        $response = array(
            "errorCode" => "NO_AVAILABILITY",
            "errorMessage" => "Group size is unable to accomodate. Maximum ".$max_group_size." pax supported",
        );
        return new WP_REST_Response($response);
    }



    $input_prd_id = $request_data['data']['productId'];
    $products = fetch_charter_list();
    $product_id = null;

    foreach ($products as $product) {
        if (get_post_meta($product->get_id(), 'getyourguide_id', true) == $input_prd_id) {
            $product_id = $product->get_id();
            break;
        }
    }

    if (!$product_id) {
        $response = array(
            "errorCode" => "INVALID_PRODUCT",
            "errorMessage" => "Invalid productId"
        );
        return new WP_REST_Response($response);
    }

    $order_id = $request_data['data']['reservationReference'];
    $order = new WC_Order($order_id);

    if (!$order || empty($order_id)) {
        $response = array(
            "errorCode" => "INVALID_RESERVATION",
            "errorMessage" => "Expired reservation; 60min hold time was exceeded."
        );
        return new WP_REST_Response($response);
    }

    $address = array(
        'first_name' => $request_data['data']['travelers'][0]['firstName'],
        'last_name'  => $request_data['data']['travelers'][0]['lastName'],
        'company'    => '',
        'email'      => $request_data['data']['travelers'][0]['email'],
        'phone'      => $request_data['data']['travelers'][0]['phoneNumber'],
        'address_1'  => '',
        'address_2'  => '',
        'city'       => '',
        'state'      => '',
        'postcode'   => '',
        'country'    => ''
    );

    $order->set_address($address, 'billing');

    $order->update_status('completed', 'order_note');
    $order->save();
    

    $currentMicrotime = microtime();
    $currentMicrotime = str_replace([' ', '.'], '', $currentMicrotime);
    $ticketCode = "TKT-" . $currentMicrotime;
    $tickets = array();

    $item_count = count($request_data['data']['bookingItems']);

    for ($i = 0; $i < $item_count; $i++) {
        $tickets[] = array(
            'category' => 'GROUP',
            'ticketCode' => $ticketCode . $i,
            'ticketCodeType' => 'QR_CODE'
        );
    }

    $response_data = array(
        'data' => array(
            'bookingReference' => $order->get_order_number(),
            'tickets' => $tickets
        )
    );


    $response = new WP_REST_Response($response_data, 200);
    if ($response->status === 200) {
        send_push_notification_booking($order, $input_prd_id);
    }
    return $response;
}



function cancel_reservation1($request) {
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);

    if (empty($request_data['data']['reservationReference']) || empty($request_data['data']['gygBookingReference'])) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
    }

    $order_id = $request_data['data']['reservationReference'];
    $order = new WC_Order($order_id);

    $order->update_status('cancelled', 'order_note');
    $order->save();


    $response_data = ['data' => []];


    $response = new WP_REST_Response($response_data, 200);
    if ($response->status === 200) {
        send_push_notification_cancel($order);
    }
    return $response;
}



function cancel_booking1($request) {
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);

    if (empty($request_data['data']['bookingReference']) || empty($request_data['data']['gygBookingReference']) || empty($request_data['data']['productId'])) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
    }

    $order_id = $request_data['data']['bookingReference'];
    $order = new WC_Order($order_id);

    $order->update_status('cancelled', 'order_note');
    $order->save();


    $response_data = ['data' => []];
 

    $response =  new WP_REST_Response($response_data, 200);
    if ($response->status === 200) {
        send_push_notification_cancel($order);
    }
    return $response;
}


function reservation1_cancel($request) {
    set_rest_api_timezone();
    $json = file_get_contents('php://input');
    $request_data = json_decode($json, true);

    if (empty($request_data['data']['reservationReference']) || empty($request_data['data']['gygBookingReference'])) {
        return new WP_REST_Response(['error' => 'Invalid request data'], 200);
    }

    $order_id = $request_data['data']['reservationReference'];
    $order = new WC_Order($order_id);

    $order->update_status('cancelled', 'order_note');
    $order->save();

    $response_data = ['data' => []];
 
    $response =  new WP_REST_Response($response_data, 200);
    if ($response->status === 200) {
        send_push_notification_cancel($order);
    }
    return $response;
}

function notify_availability_update($prd_id_gtg_item, $availabilities) {
    
    $url = 'https://supplier-api.test.com/1/notify-availability-update';
    $username = 'A1BoatChartersLtd';
    $password = '7f9efd61e934ac8f5b1bd3c6aa00945b';


    $args = array(
        'headers' => array(
            'Content-Type' => 'application/json',
            'Authorization' => 'Basic ' . base64_encode( $username . ':' . $password ),
        ),
        'body' => json_encode(array(
            'data' => array(
                'productId' => $prd_id_gtg_item,
                'availabilities' => $availabilities
            )
        )),
    );

    $response = wp_remote_post( $url, $args );

    if ( is_wp_error( $response ) ) {
        $error_message = $response->get_error_message();
        return new WP_REST_Response(array('error' => $error_message), 500);
    } else {
        $body = wp_remote_retrieve_body( $response );
        return new WP_REST_Response($body, 200);
    }
}

function send_push_notification_booking($order,$prd_id_gtg_input) {
    $items = $order->get_items();
    $push_notification_result = array();
    foreach ($items as $item) {
        $prd_id_ordered = $item->get_product_id();
        $prd_id_gtg_item = get_post_meta($prd_id_ordered, 'getyourguide_id', true);
        if ($prd_id_gtg_item == $prd_id_gtg_input) {

            $availabilities =  [
                        array(
                            "dateTime"=> date('c', strtotime($item->get_meta('ovabrw_pickup_date'))),
                            "vacancies"=> 0
                        )];
        
            $push_notification_result[]= notify_availability_update($prd_id_gtg_item, $availabilities); 
           

        }
    }
}

function send_push_notification_cancel($order) {
    $items = $order->get_items();
    $push_notification_result = array();
    foreach ($items as $item) {
        $prd_id_ordered = $item->get_product_id();
        $prd_id_gtg_item = get_post_meta($prd_id_ordered, 'getyourguide_id', true);

            $availabilities =  [
                        array(
                            "dateTime"=> date('c', strtotime($item->get_meta('ovabrw_pickup_date'))),
                            "vacancies"=> 1
                        )];
        
            $push_notification_result[]= notify_availability_update($prd_id_gtg_item, $availabilities);            

    }
}