<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Yachbat_Elementor_Blog_3 extends Widget_Base {

	
	public function get_name() {
		return 'yachbat_elementor_blog_3';
	}

	
	public function get_title() {
		return esc_html__( 'Blog 3', 'yachbat' );
	}

	
	public function get_icon() {
		return 'eicon-table-of-contents';
	}

	
	public function get_categories() {
		return [ 'yachbat' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$args = array(
            'orderby' 	=> 'name',
            'order' 	=> 'ASC'
        );

        $categories   = get_categories($args);
		$cate_array   = array();
		$arrayCateAll = array( 'all' => esc_html__( 'All categories', 'yachbat' ) );

		if ($categories) {
			foreach ( $categories as $cate ) {
				$cate_array[$cate->slug] = $cate->cat_name;
			}
		} else {
			$cate_array["No content Category found"] = esc_html__( 'No content Category found', 'yachbat' );
		}

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
			]
		);		
			// Add Class control
			$this->add_control(
                'category',
                [
                    'label' 	=> esc_html__( 'Category', 'yachbat' ),
                    'type' 		=> Controls_Manager::SELECT,
                    'default' 	=> 'all',
                    'options' 	=> array_merge($arrayCateAll,$cate_array),
                ]
                
            );

			$this->add_control(
				'total_count',
				[
					'label' 	=> esc_html__( 'Post Total', 'yachbat' ),
					'type' 		=> Controls_Manager::NUMBER,
					'default' 	=> 4,
				]
			);

            $this->add_control(
				'order_by_ad',
				[
					'label' 	=> esc_html__('Order', 'yachbat'),
					'type' 		=> Controls_Manager::SELECT,
					'default' 	=> 'desc',
					'options' 	=> [
						'asc' 		=> esc_html__('Ascending', 'yachbat'),
						'desc' 		=> esc_html__('Descending', 'yachbat'),
					]
				]
			);

            $this->add_control(
				'order_by',
				[
					'label' 	=> esc_html__('Order_by', 'yachbat'),
					'type' 		=> Controls_Manager::SELECT,
					'default' 	=> 'ID',
					'options' 	=> [
						'ID' 		=> esc_html__('ID', 'yachbat'),
						'title' 	=> esc_html__('Title', 'yachbat'),
						'date' 		=> esc_html__('Date', 'yachbat'),
					]
				]
			);

            $this->add_control(
				'show_date',
				[
					'label' 		=> esc_html__( 'Show Date', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=> esc_html__( 'Show', 'yachbat' ),
					'label_off' 	=> esc_html__( 'Hide', 'yachbat' ),
					'return_value' 	=> 'yes',
					'default' 		=> 'yes',
				]
			);

            $this->add_control(
				'show_meta',
				[
					'label' 		=> esc_html__( 'Show Meta', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=> esc_html__( 'Show', 'yachbat' ),
					'label_off' 	=> esc_html__( 'Hide', 'yachbat' ),
					'return_value' 	=> 'yes',
					'default' 		=> 'yes',
				]
			);

            $this->add_control(
				'text_readmore',
				[
					'label' 		=> esc_html__( 'Text Read More', 'yachbat' ),
					'type' 			=> Controls_Manager::TEXT,
					'default' 		=> esc_html__('Read more', 'yachbat'),
                    'condition' 	=> [
                        'show_read_more' => 'yes'
                    ]
				]
			);

            $this->add_control(
				'show_read_more',
				[
					'label' 		=> esc_html__( 'Show Read More', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=> esc_html__( 'Show', 'yachbat' ),
					'label_off' 	=> esc_html__( 'Hide', 'yachbat' ),
					'return_value' 	=> 'yes',
					'default' 		=> 'yes',
				]
			);

			$this->add_control(
			'icon',
			[
				'label' 	=> esc_html__( 'Icon', 'yachbat' ),
				'type' 		=> \Elementor\Controls_Manager::ICONS,
				'default' 	=> [
					'value' 	=> 'icomoon icomoon-long-arrow-right',
					'library' 	=> 'solid',
				],
				'condition' => [
                        'show_read_more' => 'yes'
                    ]
				]
			);

			$this->add_control(
				'show_view_all',
				[
					'label' 		=> esc_html__( 'View All', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=> esc_html__( 'Show', 'yachbat' ),
					'label_off' 	=> esc_html__( 'Hide', 'yachbat' ),
					'return_value' 	=> 'yes',
					'default' 		=> 'yes',
				]
			);
			
			$this->add_control(
				'text_viewall',
				[
					'label' 	=> esc_html__( 'Text View all', 'yachbat' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('View All Blog', 'yachbat'),
                    'condition' => [
                        'show_view_all' => 'yes'
                    ]
				]
			);

			$this->add_control(
				'icon_view_all',
				[
					'label' 	=> esc_html__( 'Icon', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::ICONS,
					'default' 	=> [
						'value' 	=> 'icomoon icomoon-long-arrow-right',
						'library' 	=> 'solid',
					],
					'condition' => [
							'show_view_all' => 'yes'
						]
					]
				);

		$this->end_controls_section();
		//end control section

		//----------------------- STYLE---------------------//

		//SECTION TAB STYLE DATE
        $this->start_controls_section(
            'section_date',
            [
                'label' => esc_html__( 'Date', 'yachbat' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );

			$this->add_group_control(
				\Elementor\Group_Control_Border::get_type(),
				[
					'name' 		=> 'border',
					'label' 	=> esc_html__( 'Border', 'yachbat' ),
					'selector'	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date',
				]
			);

			$this->add_control(
				'select_border_radius_date',
				array(
					'label'      => esc_html__( 'Border Radius', 'yachbat' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array( 'px', '%' ),
					'selectors'  => array(
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->add_control(
				'bg_color_date',
				[
					'label' 	=> esc_html__( 'Background Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' 		=> 'box_shadow',
					'label' 	=> esc_html__( 'Box Shadow', 'yachbat' ),
					'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date',
				]
			);

			$this->add_control(
				'hr',
				[
					'type' 		=> \Elementor\Controls_Manager::DIVIDER,
					'default' 	=> 'after',
				]
			);

			$this->start_controls_tabs('style_tabs_date');

				$this->start_controls_tab(
					'style_tab_date',
					[
						'label' => esc_html__( 'Date ', 'yachbat' ),
					]
				);

					$this->add_group_control(
						\Elementor\Group_Control_Typography::get_type(),
						[
							'name' 		=> 'content_typography_j',
							'label' 	=> esc_html__( 'Typography day', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date .right-j',
						]
					);

					$this->add_control(
						'color_day',
						[
							'label' 	=> esc_html__( 'Color Day', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date .right-j' => 'color : {{VALUE}};',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_tab_month',
					[
						'label' => esc_html__( 'Month', 'yachbat' ),
					]
				);

					$this->add_group_control(
						\Elementor\Group_Control_Typography::get_type(),
						[
							'name' 		=> 'content_typography_f',
							'label' 	=> esc_html__( 'Typography month', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date .right-f',
						]
					);

					$this->add_control(
						'color_date',
						[
							'label' 	=> esc_html__( 'Color Month', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date .right-f' => 'color : {{VALUE}};',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_tab_Year',
					[
						'label' => esc_html__( 'Year', 'yachbat' ),
					]
				);

					$this->add_group_control(
						\Elementor\Group_Control_Typography::get_type(),
							[
								'name' 		=> 'content_typography_y',
								'label' 	=> esc_html__( 'Typography Year', 'yachbat' ),
								'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date .right-y',
							]
						);

						$this->add_control(
							'color_year',
							[
								'label' 	=> esc_html__( 'Color Year', 'yachbat' ),
								'type' 		=> Controls_Manager::COLOR,
								'selectors' => [
									'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date .right-y' => 'color : {{VALUE}};',
								],
							]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->add_control(
				'hr_month_day',
				[
					'type' 		=> \Elementor\Controls_Manager::DIVIDER,
					'default' 	=> 'after',
				]
			);

			$this->add_responsive_control(
                'padding_date',
                [
                    'label' 		=> esc_html__( 'Padding', 'yachbat' ),
                    'type' 			=> \Elementor\Controls_Manager::DIMENSIONS,
                    'size_units'	=> [ 'px', '%', 'em' ],
                    'selectors' 	=> [
                        '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
             
		$this->end_controls_section();
		//END SECTION TAB STYLE DATE
		
		//SECTION TAB STYLE META
		$this->start_controls_section(
            'section_meta',
            [
                'label' => esc_html__( 'Meta', 'yachbat' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
            ]
        );
			// tab meta
			$this->start_controls_tabs(
				'style_tabs_meta'
			);

				$this->start_controls_tab(
					'style_normal_tab_categories',
					[
						'label' => esc_html__( 'Categories Normal', 'yachbat' ),
					]
				);
					$this->add_group_control(
						\Elementor\Group_Control_Typography::get_type(),
						[
							'name' 		=> 'content_typography_meta',
							'label' 	=> esc_html__( 'Typography', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid .post-meta .categories a',
						]
					);

					$this->add_control(
					'color_categories',
					[
						'label' 	=> esc_html__( 'Color', 'yachbat' ),
						'type' 		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-blog3.blog-grid .post-meta .categories ' => 'color : {{VALUE}};',
							'{{WRAPPER}} .ova-blog3.blog-grid .post-meta .categories a' => 'color : {{VALUE}};',	
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_normal_tab_categories_hover',
					[
						'label' => esc_html__( 'Categories Hover', 'yachbat' ),
					]
				);
					$this->add_control(
						'color_categories_hover',
						[
							'label' 	=> esc_html__( 'Color Hover', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid .post-meta .categories a:hover ' => 'color : {{VALUE}} ;',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();
			// end tab meta

			//tab comment
			$this->start_controls_tabs(
				'style_tabs_comment'
			);

				$this->start_controls_tab(
					'style_normal_tab_comment',
					[
						'label' => esc_html__( 'Comment Normal', 'yachbat' ),
					]
				);

					$this->add_group_control(
						\Elementor\Group_Control_Typography::get_type(),
						[
							'name' 		=> 'content_typography_comment',
							'label' 	=> esc_html__( 'Typography', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid .post-meta .comment a',
						]
					);

					$this->add_control(
						'color_comment',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid .post-meta .comment ' => 'color : {{VALUE}};',
								'{{WRAPPER}} .ova-blog3.blog-grid .post-meta .comment a' => 'color : {{VALUE}};',
								
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_hover_tab_comment',
					[
						'label' => esc_html__( 'Comment Hover', 'yachbat' ),
					]
				);

					$this->add_control(
					'color_comment_hover',
					[
						'label' 	=> esc_html__( 'Color Hover', 'yachbat' ),
						'type' 		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-blog3.blog-grid .post-meta .comment a:hover' => 'color : {{VALUE}};',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();
			// end tab comment

			$this->add_control(
				'hr_border_meta',
				[					
					'type' 		=> \Elementor\Controls_Manager::DIVIDER,
					'default' 	=> 'after',
				]
			);

			$this->add_responsive_control(
				'margin_meta',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'align_meta',
				[
					'label' 	=> esc_html__( 'Alignment', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::CHOOSE,
					'options' 	=> [
						'left' => [
							'title' => esc_html__( 'Left', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-right',
						],
					],
					'default' 	=> 'left',
					'toggle' 	=> true,
					'selectors' => [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .post-meta' => 'text-align: {{VALUE}}',
					],
				]
			);
		
		$this->end_controls_section();
		//END SECTION TAB STYLE META

		//SECTION TAB STYLE TITLE
		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Title', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->start_controls_tabs(
				'style_tabs_title'
			);

				$this->start_controls_tab(
					'style_normal_tab_title',
					[
						'label' => esc_html__( 'Normal', 'yachbat' ),
					]
				);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' 		=> 'content_typography_title_first-post',
							'label' 	=> esc_html__( 'Typography first post', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article:first-child .ova-content .post-title',
							
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' 		=> 'content_typography_title',
							'label' 	=> esc_html__( 'Typography', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article:not(:first-child) .ova-content .post-title',
							
						]
					);

					

					$this->add_control(	
						'color_title',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .post-title' => 'color : {{VALUE}};',
							],
						]
					);

				$this->end_controls_tab();


				$this->start_controls_tab(
					'style_hover_tab_title',
					[
						'label' => esc_html__( 'Hover', 'yachbat' ),
					]
				);

					$this->add_control(
						'color_title_hover',
						[
							'label' 	=> esc_html__( 'Color Hover', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .post-title:hover' => 'color : {{VALUE}};',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->add_control(
				'hr_title',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);
			
			$this->add_responsive_control(
				'margin_title',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
					],
				]
			);

			$this->add_responsive_control(
				'align_title',
				[
					'label' 	=> esc_html__( 'Alignment', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::CHOOSE,
					'options' 	=> [
						'left' => [
							'title' => esc_html__( 'Left', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-right',
						],
					],
					'default' 	=> 'left',
					'toggle' 	=> true,
					'selectors' => [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .post-title' => 'text-align: {{VALUE}} ',
					],
				]
			);

		$this->end_controls_section();
		//END SECTION TAB STYLE TITLE

		//SECTION TAB STYLE EXCERT
		$this->start_controls_section(
			'section_excerpt',
			[
				'label' => esc_html__( 'Excerpt', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'content_typography_excerpt',
					'label' 	=> esc_html__( 'Typography', 'yachbat' ),
					'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .excerpt p',
					
				]
			);

			$this->add_control(
				'color_excerpt',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .excerpt p' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
				'margin_excerpt',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .excerpt p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'align_excerpt',
				[
					'label' 	=> esc_html__( 'Alignment', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::CHOOSE,
					'options' 	=> [
						'left' => [
							'title' => esc_html__( 'Left', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-right',
						],
					],
					'default' 	=> 'left',
					'toggle' 	=> true,
					'selectors' => [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .excerpt' => 'text-align: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
		//END SECTION TAB STYLE EXCERPT

		//SECTION TAB STYLE BUTTON
		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Button', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->start_controls_tabs('style_tabs');

				$this->start_controls_tab(
					'style_normal_tab_button',
					[
						'label' => esc_html__( 'Normal', 'yachbat' ),
					]
				);
					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' 		=> 'readmore_typography',
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore',
						]
					);

					$this->add_control(
						'color_readmore',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_control(
						'color_readmore_background',
						[
							'label' 	=> esc_html__( 'Background', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore' => 'background-color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						\Elementor\Group_Control_Border::get_type(),
						[
							'name' 		=> 'Border',
							'label' 	=> esc_html__( 'Border', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore',
						]
					);

					$this->add_control(
						'select_border_radius_button',
						array(
							'label'      => esc_html__( 'Border Radius', 'yachbat' ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => array( 'px', '%' ),
							'selectors'  => array(
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							),
						)
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_hover_tab_button',
					[
						'label' => esc_html__( 'Hover', 'yachbat' ),
					]
				);

					$this->add_control(
						'color_readmore_hover',
						[
							'label' 	=> esc_html__( 'Color Hover', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore:hover ' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_control(
						'color_readmore_hover_background',
						[
							'label' 	=> esc_html__( 'Background Hover', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore:hover' => 'background-color : {{VALUE}};',
							],
						]
					);

					$this->add_control(
						'ova_button_border_color_hover',
						[
							'label'     => esc_html__( 'Border color', 'yachbat' ),
							'type'      => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore:hover' => 'border-color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->add_control(
				'hr_button',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);

			$this->add_responsive_control(
				'margin_readmore',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'padding_readmore',
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units'	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-blog3.blog-grid article.post-wrap .ova-content .readmore ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
		$this->end_controls_section();
		//END SECTION TAB STYLE BUTTON

		//SECTION TAB STYLE BUTTON VIEW ALL
		$this->start_controls_section(
			'section_button_view_all',
			[
				'label' => esc_html__( 'Button View All', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->start_controls_tabs('style_tabs_view_all');

				$this->start_controls_tab(
					'style_normal_tab_button_view_all',
					[
						'label' => esc_html__( 'Normal', 'yachbat' ),
					]
				);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' 		=> 'view_all_typography',
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore',
						]
					);

					$this->add_control(
						'color_view_all',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore ' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_control(
						'color_view_all_background',
						[
							'label'	 	=> esc_html__( 'Background', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore' => 'background-color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						\Elementor\Group_Control_Border::get_type(),
						[
							'name'	 	=> 'Border_view_all',
							'label' 	=> esc_html__( 'Border', 'yachbat' ),
							'selector' 	=> '{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore',
						]
					);

					$this->add_control(
						'select_border_radius_button_view_all',
						array(
							'label'      => esc_html__( 'Border Radius', 'yachbat' ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => array( 'px', '%' ),
							'selectors'  => array(
								'{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ;',
							),
						)
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_hover_tab_button_view_all',
					[
						'label' => esc_html__( 'Hover', 'yachbat' ),
					]
				);

					$this->add_control(
						'color_readmore_hover_view_all',
						[
							'label' 	=> esc_html__( 'Color Hover', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore:hover' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_control(
						'color_readmore_hover_background_view_all',
						[
							'label' 	=> esc_html__( 'Background Hover', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore:hover' => 'background-color : {{VALUE}} ',
							],
						]
					);

					$this->add_control(
						'BorderHover_view_all',
						[
							'label' 	=> esc_html__( 'Border hover', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore:hover' => 'border-color : {{VALUE}} ',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

			$this->add_control(
				'hr_button_view_all',
				[
					'type' => \Elementor\Controls_Manager::DIVIDER,
				]
			);

			$this->add_responsive_control(
				'padding_view_all',
				
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-blog3.blog-grid .btn-view-all .readmore ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();
		//END SECTION TAB STYLE BUTTON VIEW ALL		
	}

	protected function render() {
		$settings = $this->get_settings();

		$category    	= $settings['category'];
		$total_count    = $settings['total_count'];
        $order_ad       = $settings['order_by_ad'];
		$order_by       = $settings['order_by'];
       	$number_column  = 'grid_sidebar';

        $text_readmore  = $settings['text_readmore'];
        $show_date      = $settings['show_date'];
        $show_meta      = $settings['show_meta'];

		$text_viewall   = $settings['text_viewall'];
		$show_view_all  = $settings['show_view_all'];
		$icon_viewall   = $settings['icon_view_all']['value'];

		$show_read_more = $settings['show_read_more'];
		$icon 			= $settings['icon']['value'];
        
        $args = [];
		if ($category == 'all') {
			$args=[
				'post_type' 	 => 'post',
				'posts_per_page' => $total_count,
				'order' 		 => $order_ad,
				'orderby' 		 => $order_by
			];
		} else {
			$args=[
				'post_type' 		=> 'post', 
				'category_name'		=> $category,
				'posts_per_page' 	=> $total_count,
				'order' 			=> $order_ad,
				'orderby' 			=> $order_by
			];
		}	
        $blog = new \WP_Query($args);
		 ?>
		  <div class="ova-blog3 blog-grid">
                <?php
                if($blog->have_posts()) : while($blog->have_posts()) : $blog->the_post();					
                    $blog_img  		= wp_get_attachment_image_url( get_post_thumbnail_id(), 'yachbat_thumbnail' );
                    $medium_img  	= wp_get_attachment_image_url( get_post_thumbnail_id(), 'yachbat_thumbnail' );
					$categories 	= get_the_category();
					$image_alt 		= get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', TRUE);
                ?>
                <article class="post-wrap">
                        <div class="post-media">
                        	<?php if( $show_date == 'yes' ){ ?>
								<div class="post-date">
									<span class="right-y yf second_font"><?php the_time('Y' );?></span>
									<span class="right-j second_font"><?php the_time('j' );?></span>
									<span class="right-f yf second_font"><?php the_time('F' );?></span>
								</div>
							<?php } ?>
                            <?php if( $blog_img ){ ?>
                                <a href="<?php echo esc_attr( get_the_permalink() ); ?>">
                                    <img alt="<?php echo esc_attr( $image_alt ); ?>" src="<?php echo esc_url($blog_img); ?>">
                                </a>
                            <?php } ?>
                        </div>
                        <div class="ova-content">	
                            <?php if( $show_meta == 'yes' ){ ?>
							<div class="post-meta">
								<?php if($categories) : ?>
									<div class="categories">
										<?php echo get_the_category_list(', ', 'yachbat'); ?>	      
									</div>
								<?php endif ?>

								<div class="comment">
									<?php
									comments_popup_link(
										esc_html__(' 0 Comment', 'yachbat'), 
										esc_html__(' 1 Comment', 'yachbat'), 
										' % Comment',
										'',
										esc_html__( 'Comment off', 'yachbat' ) );
									?>               
								</div>
							</div>
                            <?php } ?>
							<?php if ( apply_filters( 'yachbat_blog_title_link', true ) ): ?>
								<a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
									<h5 class="post-title"><?php the_title(); ?></h5>
								</a>
							<?php else: ?>
								<h5 class="post-title"><?php the_title(); ?></h5>
							<?php endif; ?>
						                                                         
							<div class="excerpt">
								<?php the_excerpt(); ?>     
							</div>                                                      
							<?php if( $show_read_more == 'yes' ){ ?>
							<a class="btn readmore" href="<?php the_permalink(); ?>">
								 <?php echo esc_html( $text_readmore ); ?>
									<i class="<?php echo esc_attr( $icon ); ?>"></i>
							</a>
							<?php } ?>
						</div>
                </article>
                <?php
				endwhile; endif; wp_reset_postdata();
		    	?>
				<div class="btn-view-all">
					<?php if($show_view_all == 'yes') : ?>
						<a class="btn readmore" href="<?php echo get_permalink( get_option( 'page_for_posts' ) ); ?>">					
							<?php echo esc_html( $text_viewall ); ?> 
							<i class="<?php echo esc_attr( $icon_viewall ); ?>"></i>
						</a>
					<?php endif ?>
				</div>
        </div>	
		<?php
	}
}

$widgets_manager->register( new Yachbat_Elementor_Blog_3() );