<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Yachbat_Elementor_Button extends Widget_Base {

	
	public function get_name() {
		return 'yachbat_elementor_button';
	}

	
	public function get_title() {
		return esc_html__( 'Ova Button', 'yachbat' );
	}

	
	public function get_icon() {
		return 'eicon-button';
	}

	
	public function get_categories() {
		return [ 'yachbat' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Button', 'yachbat' ),
			]
		);	

			$this->add_control(
				'text_button',
				[
					'label' 	=> esc_html__( 'Text ', 'yachbat' ),
					'type' 		=> Controls_Manager::TEXT,
					'default' 	=> esc_html__('Book Now', 'yachbat'),
				]
			);

			$this->add_control(
				'button_link',
				[
					'label' 		=> esc_html__( 'Link', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::URL,
					'placeholder' 	=> esc_html__( 'https://your-link.com', 'yachbat' ),
					'default' 		=> [
						'url' 				=> '',
						'is_external' 		=> false,
						'nofollow' 			=> false,
						'custom_attributes' => '',
					],
					'label_block' 	=> true,
				]
			);

			$this->add_control(
				'icon',
				[
					'label' 	=> __( 'Icon', 'yachbat' ),
					'type' 		=> Controls_Manager::ICONS,
					'default' 	=> [
						'value' 	=> 'icomoon icomoon-long-arrow-right',
						'library' 	=> 'solid',
					],
				]
			);

			$this->add_responsive_control(
				'size_icon',
				[
					'label' 	 => esc_html__( 'Size', 'yachbat' ),
					'type' 		 => Controls_Manager::SLIDER,
					'size_units' => [ 'px'],
					'range' => [
						'px' => [
							'min' 	=> 0,
							'max' 	=> 100,
							'step' 	=> 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-button .ova-text i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'align_button_ova',
				[
					'label' 	=> esc_html__( 'Icon Position', 'yachbat' ),
					'type' 		=> Controls_Manager::CHOOSE,
					'options' 	=> [
						'-1' => [
							'title' => esc_html__( 'before', 'yachbat' ),
							'icon' 	=> 'eicon-h-align-left',
						],
						'2' 	=> [
							'title' => esc_html__( ' after', 'yachbat' ),
							'icon' 	=> 'eicon-h-align-right',
						],
					],
					
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .ova-button  i ' => 'order: {{VALUE}} ;',
					],
				]
			);

			$this->add_responsive_control(
				'align_button',
				[
					'label' 	=> esc_html__( 'Alignment', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::CHOOSE,
					'options'   => [
						'left' => [
							'title' => esc_html__( 'Left', 'yachbat' ),
							'icon' 	=> 'eicon-text-align-left',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'yachbat' ),
							'icon'  => 'eicon-text-align-center',
						],
						'right' => [
							'title' => esc_html__( 'Right', 'yachbat' ),
							'icon'  => 'eicon-text-align-right',
						],
					],
					'default' 	=> 'left',
					'toggle' 	=> true,
					'selectors' => [
						'{{WRAPPER}} .ova-button' => 'justify-content: {{VALUE}}',
					],
				]
			);
			
		$this->end_controls_section();

		//SECTION TAB STYLE TITLE
		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Button', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'style_tabs_button'
		);

			$this->start_controls_tab(
				'style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'yachbat' ),
				]
			);
			
				$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
						'name' 		=> 'content_typography_title',
						
						'label' 	=> esc_html__( 'Typography', 'yachbat' ),
						'selector' 	=> '{{WRAPPER}} .ova-button .readmore',
						
					]
				);

				$this->add_control(	
					'color_title',
					[
						'label' 	=> esc_html__( 'Color', 'yachbat' ),
						'type' 		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-button .readmore' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'color_button_background',
					[
						'label' 	=> esc_html__( 'Background ', 'yachbat' ),
						'type' 		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-button .readmore' => 'background-color : {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' 		=> 'Border',
						'label' 	=> esc_html__( 'Border', 'yachbat' ),
						'selector'  => '{{WRAPPER}} .ova-button .readmore',
					]
				);
				
				$this->add_control(
					'select_border_radius_button',
					array(
						'label'      => esc_html__( 'Border Radius', 'yachbat' ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => array( 'px', '%' ),
						'selectors'  => array(
							'{{WRAPPER}} .ova-button .readmore' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						),
					)
				);
			$this->end_controls_tab();

			$this->start_controls_tab(
				'style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'yachbat' ),
				]
			);
				$this->add_control(
					'color_title_hover',
					[
						'label' 	=> esc_html__( 'Color', 'yachbat' ),
						'type' 		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-button .readmore:hover ' => 'color : {{VALUE}} ;',
						],
					]
				);
				$this->add_control(
					'color_button_hover_background',
					[
						'label' 	=> esc_html__( 'Background', 'yachbat' ),
						'type' 		=> Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-button .readmore:hover' => 'background-color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'ova_button_border_color_hover',
					[
						'label'     => esc_html__( 'Border color', 'yachbat' ),
						'type'      => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-button .readmore:hover' => 'border-color: {{VALUE}}',
						],
					]
				);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'hr_title',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
				'default' =>'before'
			]
		);
		
		$this->add_responsive_control(
			'padding_title',
			[
				'label' 		=> esc_html__( 'Padding', 'yachbat' ),
				'type'			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', 'em', '%' ],
				'selectors' 	=> [
					'{{WRAPPER}} .ova-button .readmore' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		//END SECTION TAB STYLE TITLE
	}

	// Render Template Here
	protected function render() {

		$settings = $this->get_settings();

		$text   = $settings['text_button'];
		$icon   = $settings['icon']['value'];
		$url    = $settings['button_link']['url'];
        $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';

		?>

		<div class="ova-button">
			
			<?php if( $url) : ?>
				<a class="btn readmore" href="<?php echo esc_url( $url ); ?>"<?php printf( $target ); ?>>
					<span class="text">
						<?php echo esc_html( $text ); ?> 
					</span>
					<i class="<?php echo esc_attr( $icon ); ?>"></i>
				</a>
			<?php else : ?>	
				<a class="btn readmore" href="#">
					<span class="text"> 
						<?php echo esc_html( $text ); ?> 
				     </span>
					<?php if(!empty( $icon )) : ?>
						<i class="<?php echo esc_attr( $icon ); ?>"></i>
					<?php endif; ?>
				</a>
			<?php endif; ?>  
			
		</div>	

	<?php
	}	
}

$widgets_manager->register( new Yachbat_Elementor_Button() );