<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Yachbat_Elementor_Contact_Info_2 extends Widget_Base {

	
	public function get_name() {
		return 'yachbat_elementor_contact-info-2';
	}

	
	public function get_title() {
		return esc_html__( 'Contact Info 2', 'yachbat' );
	}

	
	public function get_icon() {
		return 'eicon-map-pin';
	}

	
	public function get_categories() {
		return [ 'yachbat' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {


		/**
		* Content Tab
		*/
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
				
			]
		);
			$this->add_control(
				'label',
				[
					'label'   => esc_html__( 'Label', 'yachbat' ),
					'type'    => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__('Label', 'yachbat'),
				]
			);

			$repeater = new \Elementor\Repeater();

				$repeater->add_control(
					'type',
					[
						'label' 	=> esc_html__( 'Type', 'yachbat' ),
						'type'   	=> Controls_Manager::SELECT,
						'default' 	=> 'email',
						'options' 	=> [
							'email' 	=> esc_html__('Email', 'yachbat'),
							'phone' 	=> esc_html__('Phone', 'yachbat'),
							'link' 		=> esc_html__('Link', 'yachbat'),
							'text' 		=> esc_html__('Text', 'yachbat'),
						]
					]
				);
				
				$repeater->add_control(
					'icon_email',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'icomoon icomoon-envelope',
							'library' 	=> 'icomoon',
						],
						'condition' => [
							'type' 	=> 'email',
						]
					]
				);
				
				$repeater->add_control(
					'email_title',
					[
						'label'   		=> esc_html__( 'Email title', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'ABC', 'yachbat' ),
						'condition' 	=> [
							'type' 	=> 'email',
						]

					]
				);

				$repeater->add_control(
					'email_label',
					[
						'label'   		=> esc_html__( 'Email Label', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'email@company.com', 'yachbat' ),
						'default' 		=> 'email@company.com',
						'condition' 	=> [
							'type'	=> 'email',
						]

					]
				);

				$repeater->add_control(
					'email_link',
					[
						'label'   		=> esc_html__( 'Email Link', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'email@company.com', 'yachbat' ),
						'condition' 	=> [
							'type' => 'email',
						]

					]
				);

				$repeater->add_control(
					'icon_phone',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'icomoon icomoon-phone-volume',
							'library' 	=> 'icomoon',
						],
						'condition' => [
							'type' => 'phone',
						]
					]
				);

				$repeater->add_control(
					'phone_title',
					[
						'label'   		=> esc_html__( 'Phone Title', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'Hotline: ', 'yachbat' ),
						'condition' 	=> [
							'type' => 'phone',
						]

					]
				);

				$repeater->add_control(
					'phone_label',
					[
						'label'   		=> esc_html__( 'Phone Label', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( '+012 (345) 678', 'yachbat' ),
						'default' 		=> '+012 (345) 678',
						'condition' 	=> [
							'type' => 'phone',
						]

					]
				);

				$repeater->add_control(
					'phone_link',
					[
						'label'   		=> esc_html__( 'Phone Link', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( '+012345678', 'yachbat' ),
						'condition' 	=> [
							'type' => 'phone',
						]

					]
				);

				$repeater->add_control(
					'icon_link',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'icomoon icomoon-link',
							'library' 	=> 'icomoon',
						],
						'condition' => [
							'type' => 'link',
						]
					]
				);

				$repeater->add_control(
					'link_title',
					[
						'label'   		=> esc_html__( 'Link Title', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description'   => esc_html__( 'Link Title', 'yachbat' ),
						'default' 		=> 'Title link ',
						'condition' 	=> [
							'type' => 'link',
						]

					]
				);
				$repeater->add_control(
					'link_label',
					[
						'label'   		=> esc_html__( 'Link Label', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'https://your-domain.com', 'yachbat' ),
						'default' 		=> 'https://your-domain.com',
						'condition' 	=> [
							'type' => 'link',
						]

					]
				);

				$repeater->add_control(
					'link_address',
					[
						'label'   		=> esc_html__( 'Link', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::URL,
						'description'	=> esc_html__( 'https://your-domain.com', 'yachbat' ),
						'show_external' => false,
						'default' 		=> [
							'url' 			=> '#',
							'is_external' 	=> false,
							'nofollow' 		=> false,
						],
						'condition' 	=> [
							'type' => 'link',
						],
					]
				);

				$repeater->add_control(
					'icon_text',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'icomoon icomoon-chat',
							'library' 	=> 'icomoon',
						],
						'condition' => [
							'type' => 'text',
						]
					]
				);

				$repeater->add_control(
					'text',
					[
						'label'   => esc_html__( 'Text', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( 'Your text', 'yachbat' ),
						'default' => 'Your text',
						'condition' => [
							'type' => 'text',
						]

					]
				);
				$repeater->add_control(
					'description',
					[
						'label'   => esc_html__( 'Description', 'yachbat' ),
						'type'    => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( 'Description', 'yachbat' ),
						'default' => 'Your text',
						'condition' => [
							'type' => 'text',
						]

					]
				);

				$this->add_control(
					'items_info',
					[
						'label'       => esc_html__( 'Items Info', 'yachbat' ),
						'type'        => Controls_Manager::REPEATER,
						'fields'      => $repeater->get_controls(),
						'default' => [
							[
								'type' => 'text',
								'text' => esc_html__('Chat with us', 'yachbat'),
								'description' => esc_html__('10am to 8pm EST', 'yachbat'),
							],
						],
						'title_field' => '{{{ type }}}',
					]
				);


		$this->end_controls_section();

		/**
		* Label Style Tab Content
		*/
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_responsive_control(
				'content_margin',
				[
					'label'	 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units'	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'content_padding',
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'item_margin',
				[
					'label' 		=> esc_html__( 'Item margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End  Style Tab Content


		/**
		* Label Style Tab
		*/
		$this->start_controls_section(
			'section_label_style',
			[
				'label' => esc_html__( 'Label', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);	
			$this->add_control(
				'label_color',
				[
					'label'	 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info-2 .contact .label' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'label_typography',
					'selector' 	=> '{{WRAPPER}} .ova-contact-info-2 .contact .label',
				]
			);

			$this->add_responsive_control(
				'label_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .contact .label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Label Style Tab


		/**
		* Info Style Tab Title
		*/
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'title_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .item .title' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_color_hover',
				[
					'label' 	=> esc_html__( 'Link Color hover', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .item .title:hover' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'info_typography',
					'selector' 	=> '{{WRAPPER}} .ova-contact-info-2 .contact .info .item .title',
				]
			);

			$this->add_responsive_control(
				'info_padding',
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .item .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Label Style Tab Title	
		
		/**
		* Icon Style Tab Icon
		*/
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'icon_fontsize',
				[
					'label' 		=> esc_html__( 'Font Size', 'yachbat' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 1,
							'max' 	=> 300,
							'step' 	=> 1,
						]
					],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .info .item i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info-2 .info .item i' => 'color : {{VALUE}} !important;',
					],
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .info .item i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Style tab Icon

		/**
		 * Info Style Tab descreption [link]
		 */
		$this->start_controls_section(
			'section_descreption_style',
			[
				'label' => esc_html__( 'Descreption', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'descreption_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .item a' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .content ' => 'color : {{VALUE}};',
						
					],
				]
			);

			$this->add_control(
				'descreption_color_hover',
				[
					'label' 	=> esc_html__( 'Link Color hover', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .item a:hover p' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'link_typography',
					'selector' 	=> '{{WRAPPER}} .ova-contact-info-2 .contact .info .content',
				]
			);
			$this->add_responsive_control(
				'description_padding',
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info-2 .contact .info .item .content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Label Style link label
	}

	// Render Template Here
	protected function render() {

		$settings = $this->get_settings();

		$icon 		= isset( $settings['icon']['value'] ) ? $settings['icon']['value'] : '';
		$label 		= $settings['label'] ? $settings['label'] : '';
		$items_info = $settings['items_info'];
		
		?>
			<div class="ova-contact-info-2 ">
				<?php if ( $icon ): ?>
					<div class="icon">
						<i class="<?php echo esc_attr( $icon ); ?>"></i>
					</div>	
				<?php endif; ?>
				<div class="contact">
					<fieldset>
					<?php if ( $label ): ?>

						<legend>
						<h6 class="label">
							<?php echo esc_html( $label ); ?>
						</h6>
						</legend>
						
					<?php endif; ?>
					<ul class="info">
						<?php foreach( $items_info as $item ):
							$type = $item['type'];
						?>
							<li class="item">

								<?php switch ( $type ) {

									case 'email':

										$email_title = $item['email_title'];
										$email_label = $item['email_label'];
										$email_icon  = $item['icon_email']['value'];
										$email_link  = $item['email_link'];
										
										if($email_icon){ ?>	
											<i class="<?php echo esc_attr( $email_icon ); ?>"></i>
										<?php
										}
										?>
											<div class="ova-email">
												<?php
												
												if($email_title){ ?>
													<p  class="title"> <?php echo esc_html( $email_title ); ?> </p>
													<?php
												}
												if($email_link){ ?>
													<a href="mailto:<?php echo esc_url( $email_link ); ?> ">
														<p class="content">	<?php echo esc_html( $email_label ); ?> </p>
													</a>
												<?php
												} else{ ?>
													<p class="content">	<?php	echo esc_html( $email_label ); ?> </p>
												<?php }
												?>
											</div>
											<?php
										break;

									case 'phone':

										$phone_title = $item['phone_title'];
										$phone_label = $item['phone_label'];
										$phone_icon  = $item['icon_phone']['value'];
										$phone_link  = $item['phone_link'];

										if($phone_icon){ ?>
																					
											<i class="<?php echo esc_attr( $phone_icon ); ?>"></i>		
										<?php } ?>

										<div class="ova-phone">
										<?php
											
											if( $phone_title ) { ?>
												<p  class="title"><?php echo esc_html( $phone_title );?></p>
											<?php }
											if($phone_link){ ?>
												<a href="phoneto:<?php echo esc_url( $phone_link ); ?> ">
													<p class="content"> <?php echo esc_html( $phone_label ); ?> </p>
												</a>
											<?php
											} else{ ?>
												<p class="content"> <?php echo esc_html( $phone_label ); ?> </p>
										<?php	}
										?>
										</div>
										<?php
										break;

									case 'link':

										$this->add_render_attribute( 'title' );
										$link_icon   = $item['icon_link']['value'];
										$link_title  = $item['link_title'];
										$link_label  = $item['link_label'];
										$link_link   = $item['link_address']['url'];
										$target_link = $item['link_address']['is_external'] ? ' target="_blank"' : '';

										if( $link_icon ) { ?>	
											<i class="<?php echo esc_attr( $link_icon ); ?>"></i>
										<?php } ?>

										<div class="ova-link">
										<?php
											
											if($link_title){
												?>
												<p class="title"><?php echo esc_html( $link_title );?></p>
												<?php
											}
											if($link_label){ ?>
												<a href="linkto:<?php echo esc_url( $link_link ); ?> " <?php printf( $target_link ); ?>>
													<p class="content"> <?php echo esc_html( $link_label ); ?> </p>
												</a>
											<?php
											} else{ ?>
											<p class="content">	<?php	echo esc_html( $link_label ); ?> </p>
										<?php	} ?>
										</div>
										<?php
										break;

									case 'text':
										
										$text_icon  = $item['icon_text']['value'];
										$text_title = $item['text'];
										$text_label = $item['description'];
										
										if( $text_icon ) { ?>	
											<i class="<?php echo esc_attr( $text_icon ); ?>"></i>
										<?php } ?>
										
										<div class="ova-text">
											<?php
												if($text_title){ ?>
												<p class="title"> 
													<?php echo esc_html( $text_title ); ?>
												</p>	
												<?php }
												if($text_label){ ?>
													<p class="descreption content"> 
														<?php echo esc_html( $text_label ); ?>
													</p>
												<?php }
											?>
										</div>
										<?php
										break;
									default:
										break;
								} ?>
							</li>
						<?php endforeach; ?>
					</ul>
					</fieldset>
				</div>
			</div>
		<?php
	}
}
$widgets_manager->register( new Yachbat_Elementor_Contact_Info_2() );