<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Yachbat_Elementor_Product_List extends Widget_Base {

	public function get_name() {
		return 'yachbat_elementor_product_list';
	}

	public function get_title() {
		return esc_html__( 'Product List', 'yachbat' );
	}

	public function get_icon() {
		return 'eicon-products';
	}

	public function get_categories() {
		return [ 'yachbat' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_product_list_content',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
			]
		);

			$this->add_control(
				'show_featured',
				[
					'label' 		=> __( 'Only Show Featured', 'yachbat' ),
					'type' 			=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 		=> __( 'Show', 'yachbat' ),
					'label_off' 	=> __( 'Hide', 'yachbat' ),
					'default' 		=> 'no',
				]
			);

			$this->add_control(
				'columns',
				[
					'label' 	=> esc_html__( 'Columns', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> 'column3',
					'options' 	=> [
						'column1' => esc_html__( 'Column 1', 'yachbat' ),
						'column2' => esc_html__( 'Column 2', 'yachbat' ),
						'column3' => esc_html__( 'Column 3', 'yachbat' ),
					],
				]
			);

			$args_query	= [
				'taxonomy' 	=> 'product_cat',
				'orderby' 	=> 'name',
	        	'order'   	=> 'ASC'
			];

			$categories 		= get_categories( $args_query );
			$defautl_category 	= array( 'all' => esc_html__( 'All', 'yachbat' ) );
			$args_category 		= array();
			$result 			= array();

			if ( $categories && is_array( $categories ) ) {
				foreach ( $categories as $category ) {
					$args_category[$category->slug] = $category->cat_name;
				}
			}

			$result = array_merge( $defautl_category, $args_category );

			$this->add_control(
				'categories',
				[
					'label' 	=> esc_html__( 'Select Category', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> 'all',
					'options' 	=> $result,
				]
			);

			$this->add_control(
				'posts_per_page',
				[
					'label' 	=> esc_html__( 'Posts Per Page', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::NUMBER,
					'default' 	=> 3,
				]
			);

			$this->add_control(
				'orderby',
				[
					'label' 	=> esc_html__( 'Order By', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> 'title',
					'options' 	=> [
						'title' 		=> esc_html__( 'Title', 'yachbat' ),
						'ID' 			=> esc_html__( 'ID', 'yachbat' ),
						'date' 			=> esc_html__( 'Date', 'yachbat' ),
						'menu_order' 	=> esc_html__( 'Menu order', 'yachbat' ),
					],
				]
			);

			$this->add_control(
				'order',
				[
					'label' 	=> esc_html__( 'Order', 'yachbat' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> 'ASC',
					'options' 	=> [
						'ASC' 	=> esc_html__( 'Ascending', 'yachbat' ),
						'DESC' 	=> esc_html__( 'Descending', 'yachbat' ),
					],
				]
			);

			$this->add_control(
				'category_in',
				[
					'label'   		=> esc_html__( 'Category In', 'yachbat' ),
					'type'    		=> Controls_Manager::TEXT,
					'description' 	=> esc_html__( 'Enter the product category IDs. IDs are separated by "|". Ex: 1|2|3.', 'yachbat' ),
				]
			);

			$this->add_control(
				'category_not_in',
				[
					'label'   		=> esc_html__( 'Category Not In', 'yachbat' ),
					'type'    		=> Controls_Manager::TEXT,
					'description' 	=> esc_html__( 'Enter the product category IDs. IDs are separated by "|". Ex: 1|2|3.', 'yachbat' ),
				]
			);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_product_list_style',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'content_grap',
				[
					'label' 		=> esc_html__( 'Grap', 'yachbat' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 10,
						],
					],
					'default' => [
						'size' => 30,
						'unit' => 'px',
					],
					'selectors' => [
						'{{WRAPPER}} .ova-product-list' => 'grid-gap: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'content_background',
				[
					'label' 	=> esc_html__( 'Background', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' 		=> 'content_box_shadow',
					'label' 	=> esc_html__( 'Box Shadow', 'yachbat' ),
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product',
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' 		=> 'content_border',
					'label' 	=> esc_html__( 'Border', 'yachbat' ),
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product',
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'content_border_radius',
				[
					'label' 		=> esc_html__( 'Border Radius', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'content_padding',
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_image',
			[
				'label' => esc_html__( 'Image', 'yachbat' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
				'image_height',
				[
					'label' 		=> esc_html__( 'Height', 'yachbat' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range' => [
						'px' => [
							'min' => 300,
							'max' => 500,
							'step' => 10,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-thumbnail img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'image_overlay_bgcolor',
				[
					'label' 	=> esc_html__( 'Overlay Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-thumbnail .mask' => 'background-color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		// Is Featured style
		$this->start_controls_section(
			'section_is_featured_style',
			[
				'label' => esc_html__( 'Is Featured', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		    $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'is_featured_typography',
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-is-featured',
				]
			);

			$this->add_control(
				'is_featured_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-is-featured' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'is_featured_bgcolor',
				[
					'label' 	=> esc_html__( 'Background Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-is-featured' => 'background-color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'is_featured_padding',
				[
					'label' 		=> esc_html__( 'Padding', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-is-featured' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		// Favorite style
		$this->start_controls_section(
			'section_favorite_style',
			[
				'label' => esc_html__( 'Favorite', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		    $this->add_responsive_control(
				'favourite_size',
				[
					'label' 		=> esc_html__( 'Size', 'yachbat' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 50,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-wishlist .yith-wcwl-add-to-wishlist .yith-wcwl-add-button .add_to_wishlist i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'favorite_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-wishlist .yith-wcwl-add-to-wishlist .yith-wcwl-add-button .add_to_wishlist i' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();
        
        // Features style
		$this->start_controls_section(
			'section_features_style',
			[
				'label' => esc_html__( 'Features', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'features_typography',
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-features li.yachbat-product-features-item',
				]
			);

			$this->add_control(
				'features_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-features li.yachbat-product-features-item' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'features_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-features li.yachbat-product-features-item:not(:last-child)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'flex_align_features',
				[
					'label' => esc_html__( 'Alignment', 'yachbat' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Flex Start', 'yachbat' ),
							'icon' => 'eicon-text-align-left',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'yachbat' ),
							'icon' => 'eicon-text-align-center',
						],
						'flex-end' => [
							'title' => esc_html__( 'Flex End', 'yachbat' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => 'space-between',
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_head_product .yachbat-product-features' => 'justify-content: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'title_typography',
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-title a',
				]
			);

			$this->start_controls_tabs( 'title_tabs' );
				$this->start_controls_tab(
					'title_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'yachbat' ),
					]
				);

					$this->add_control(
						'title_normal_color',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-title a' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'title_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'yachbat' ),
					]
				);

					$this->add_control(
						'title_hover_color',
						[
							'label' 	=> esc_html__( 'Color', 'yachbat' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ova-product-list .ova-product:hover .yachbat_foot_product .yachbat-product-title a' => 'color: {{VALUE}}',
							],
						]
					);

				$this->end_controls_tab();
			$this->end_controls_tabs();

			$this->add_responsive_control(
				'title_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_review_style',
			[
				'label' => esc_html__( 'Review', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'star_color',
				[
					'label' 	=> esc_html__( 'Star Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-review .star-rating' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'rating_color',
				[
					'label' 	=> esc_html__( 'Rating Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-review .parentheses-rating' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_price_style',
			[
				'label' => esc_html__( 'Price', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'price_typography',
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .yachbat-product-price .product-amount',
				]
			);

			$this->add_control(
				'price_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .yachbat-product-price .product-amount' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'day_options',
				[
					'label' => esc_html__( 'Day Options', 'yachbat' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'day_typography',
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .yachbat-product-price .define_1_day',
				]
			);

			$this->add_control(
				'day_color',
				[
					'label' 	=> esc_html__( 'Day Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .yachbat-product-price .define_1_day' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'from_options',
				[
					'label' => esc_html__( 'From Text Options', 'yachbat' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'from_typography',
					'selector' 	=> '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .yachbat-product-price .from-price',
				]
			);

			$this->add_control(
				'from_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .yachbat-product-price .from-price' => 'color: {{VALUE}}',
					],
				]
			);

		$this->end_controls_section();

		// Button style
		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Button', 'yachbat' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'style_tabs_button'
		);

			$this->start_controls_tab(
				'style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'yachbat' ),
				]
			);

				$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
						'name' => 'button_typography',		
						'label' => esc_html__( 'Typography', 'yachbat' ),
						'selector' => '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now',
						
					]
				);

				$this->add_control(	
					'color_button',
					[
						'label' => esc_html__( 'Color', 'yachbat' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(	
					'color_icon_button',
					[
						'label' => esc_html__( 'Color Icon', 'yachbat' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now i' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'color_button_background',
					[
						'label' => esc_html__( 'Background ', 'yachbat' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now' => 'background-color : {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'button_border',
						'label' => esc_html__( 'Border', 'yachbat' ),
						'selector' => '{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now',
					]
				);
				
				$this->add_control(
					'border_radius_button',
					array(
						'label'      => esc_html__( 'Border Radius', 'yachbat' ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => array( 'px', '%' ),
						'selectors'  => array(
							'{{WRAPPER}} .ova-product-list .ova-product .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						),
					)
				);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'yachbat' ),
				]
			);

				$this->add_control(	
					'color_button_hover',
					[
						'label' => esc_html__( 'Color', 'yachbat' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-product-list .ova-product:hover .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now' => 'color : {{VALUE}};',
						],
					]
				);

				$this->add_control(
					'color_button_background_hover',
					[
						'label' => esc_html__( 'Background ', 'yachbat' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .ova-product-list .ova-product:hover .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now' => 'background-color : {{VALUE}};',
						],
					]
				);

				$this->add_group_control(
					\Elementor\Group_Control_Border::get_type(),
					[
						'name' => 'button_border_hover',
						'label' => esc_html__( 'Border', 'yachbat' ),
						'selector' => '{{WRAPPER}} .ova-product-list .ova-product:hover .yachbat_foot_product .yachbat-product-wrapper-price .product-btn-book-now',
					]
				);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();


	}

	protected function yachbat_get_product_list( $args ) {

		$args_query = [
			'post_type' 		=> 'product',
		    'post_status' 		=> 'publish',
		    'posts_per_page' 	=> $args['posts_per_page'],
		    'orderby' 			=> $args['orderby'],
		    'order'				=> $args['order'],
		    'fields' 			=> 'ids',
		    'tax_query' 		=> [],
		];

		if ( 'yes' === $args['show_featured'] ) {
	        $featured = [
	        	'taxonomy' => 'product_visibility',
                'field'    => 'name',
                'terms'    => 'featured',
                'operator' => 'IN'
	        ];

	        array_push( $args_query['tax_query'], $featured );
	    }

		if ( 'all' != $args['category_slug'] ) {
			$category_args = [
				'taxonomy' 	=> 'product_cat',
            	'field' 	=> 'slug',
            	'terms'     => $args['category_slug'],
            	'operator'  => 'IN',
			];
			array_push( $args_query['tax_query'], $category_args );
		}

		if ( $args['category_in'] ) {
			$category_in = [
				[
					'taxonomy' 	=> 'product_cat',
					'field'    	=> 'term_id',
					'terms'    	=> explode( '|', $args['category_in'] ),
					'operator'  => 'IN',
				],
			];
			array_push( $args_query['tax_query'], $category_in );
		}

		if ( $args['category_not_in'] ) {
			$category_not_in = [
				[
					'taxonomy' 	=> 'product_cat',
					'field'    	=> 'term_id',
					'terms'    	=> explode( '|', $args['category_not_in'] ),
					'operator' 	=> 'NOT IN',
				],
			];
			array_push( $args_query['tax_query'], $category_not_in );
		}

		$result  = new \WP_Query( $args_query );

		return $result;
	}

	protected function render() {
		$settings 	= $this->get_settings();
		$column 	= $settings['columns'];

		$args = [
			'posts_per_page' 	=> $settings['posts_per_page'],
			'orderby' 			=> $settings['orderby'],
			'order' 			=> $settings['order'],
			'category_slug'		=> $settings['categories'],
			'category_in' 		=> $settings['category_in'],
			'category_not_in' 	=> $settings['category_not_in'],
			'show_featured'		=> $settings['show_featured']
		];
		
		$products = $this->yachbat_get_product_list( $args );

		?>

		<?php if ( $products->have_posts() ): ?>
			<ul class="ova-product-list <?php echo esc_attr( $column ); ?>">
				<?php while( $products->have_posts() ) : $products->the_post(); ?>
					<?php wc_get_template_part( 'content', 'product' ); ?>
				<?php endwhile; ?>
			</ul>

		<?php else: ?>
			<div class="ova-no-products-found">
				<?php echo esc_html__( 'No products found', 'yachbat' ); ?>
			</div>
		<?php endif; wp_reset_postdata(); ?>

		<?php

	}
}

$widgets_manager->register( new Yachbat_Elementor_Product_List() );