<?php

class Yachbat_Elementor {
	
	function __construct() {
            
		// Register Header Footer Category in Pane
	    add_action( 'elementor/elements/categories_registered', array( $this, 'yachbat_add_category' ) );

	    add_action( 'elementor/frontend/after_register_scripts', array( $this, 'yachbat_enqueue_scripts' ) );
		
		add_action( 'elementor/widgets/register', array( $this, 'yachbat_include_widgets' ) );
		
		add_filter( 'elementor/controls/animations/additional_animations', array( $this, 'yachbat_add_animations'), 10 , 0 );

		add_action( 'wp_print_footer_scripts', array( $this, 'yachbat_enqueue_footer_scripts' ) );

		// load icons
		add_filter( 'elementor/icons_manager/additional_tabs', array( $this, 'yachbat_icons_filters_new' ), 9999999, 1 );

		// Add style Image Box Widget
		add_action( 'elementor/element/image-box/section_style_content/before_section_end', array( $this, 'yachbat_image_box' ), 10, 2 );

        // Add style Social Icon 
		add_action( 'elementor/element/social-icons/section_social_hover/after_section_end', array( $this, 'yachbat_social_icons_custom' ), 10, 2 );

	}

	
	function yachbat_add_category(  ) {

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'hf',
	        [
	            'title' => __( 'Header Footer', 'yachbat' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	    \Elementor\Plugin::instance()->elements_manager->add_category(
	        'yachbat',
	        [
	            'title' => __( 'Yachbat', 'yachbat' ),
	            'icon' => 'fa fa-plug',
	        ]
	    );

	}

	function yachbat_enqueue_scripts(){
        
        $files = glob(get_theme_file_path('/assets/js/elementor/*.js'));
        
        foreach ($files as $file) {
            $file_name = wp_basename($file);
            $handle    = str_replace(".js", '', $file_name);
            $src       = get_theme_file_uri('/assets/js/elementor/' . $file_name);
            if (file_exists($file)) {
                wp_register_script( 'yachbat-elementor-' . $handle, $src, ['jquery'], false, true );
            }
        }


	}

	function yachbat_include_widgets( $widgets_manager ) {
        $files = glob(get_theme_file_path('elementor/widgets/*.php'));
        foreach ($files as $file) {
            $file = get_theme_file_path('elementor/widgets/' . wp_basename($file));
            if (file_exists($file)) {
                require_once $file;
            }
        }
    }

    function yachbat_add_animations(){
    	$animations = array(
            'Yachbat' => array(
                'ova-move-up' 		=> esc_html__('Move Up', 'yachbat'),
                'ova-move-down' 	=> esc_html__( 'Move Down', 'yachbat' ),
                'ova-move-left'     => esc_html__('Move Left', 'yachbat'),
                'ova-move-right'    => esc_html__('Move Right', 'yachbat'),
                'ova-scale-up'      => esc_html__('Scale Up', 'yachbat'),
                'ova-flip'          => esc_html__('Flip', 'yachbat'),
                'ova-helix'         => esc_html__('Helix', 'yachbat'),
                'ova-popup'			=> esc_html__( 'PopUp','yachbat' )
            ),
        );

        return $animations;
    }

   

	function yachbat_enqueue_footer_scripts(){
		// Font Icon
	    wp_enqueue_style('ovaicon', YACHBAT_URI.'/assets/libs/ovaicon/font/ovaicon.css', array(), null);

	    // Icomoon
	    wp_enqueue_style('ovaicomoon', YACHBAT_URI.'/assets/libs/icomoon/style.css', array(), null);
	}
	
	

	public function yachbat_icons_filters_new( $tabs = array() ) {

		$newicons = [];

		// Default
		$font_data['json_url'] = YACHBAT_URI.'/assets/libs/ovaicon/ovaicon.json';
		$font_data['name'] = 'ovaicon';

		$newicons[ $font_data['name'] ] = [
			'name'          => $font_data['name'],
			'label'         => esc_html__( 'Default', 'yachbat' ),
			'url'           => '',
			'enqueue'       => '',
			'prefix'        => 'ovaicon-',
			'displayPrefix' => '',
			'ver'           => '1.0',
			'fetchJson'     => $font_data['json_url'],
			
		];

		// Icomoon
		$icomoon_data['json_url'] = YACHBAT_URI.'/assets/libs/icomoon/icomoon.json';
		$icomoon_data['name'] = 'ovaicomoon';

		$newicons[ $icomoon_data['name'] ] = [
			'name'          => $icomoon_data['name'],
			'label'         => esc_html__( 'Icomoon', 'yachbat' ),
			'url'           => '',
			'enqueue'       => '',
			'prefix'        => 'icomoon-',
			'displayPrefix' => '',
			'ver'           => '1.0',
			'fetchJson'     => $icomoon_data['json_url'],
			
		];


		return array_merge( $tabs, $newicons );

	}

	function yachbat_image_box( $element, $args ) {
		$element->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Title Margin', 'yachbat' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$element->add_responsive_control(
			'description_margin',
			[
				'label' => esc_html__( 'Description Margin', 'yachbat' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
	}

	function yachbat_social_icons_custom ( $element, $args ) {
		/** @var \Elementor\Element_Base $element */
		$element->start_controls_section(
			'ova_social_icons',
			[
				'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
				'label' => esc_html__( 'Ova Social Icon', 'yachbat' ),
			]
		);

			$element->add_responsive_control(
	            'ova_social_icons_display',
	            [
	                'label' 	=> esc_html__( 'Display', 'yachbat' ),
	                'type' 		=> \Elementor\Controls_Manager::CHOOSE,
	                'options' 	=> [
	                    'inline-block' => [
	                        'title' => esc_html__( 'Block', 'yachbat' ),
	                        'icon' 	=> 'eicon-h-align-left',
	                    ],
	                    'inline-flex' => [
	                        'title' => esc_html__( 'Flex', 'yachbat' ),
	                        'icon' 	=> 'eicon-h-align-center',
	                    ],
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .elementor-icon.elementor-social-icon' => 'display: {{VALUE}}',
	                ],
	            ]
	        );

			$element->add_control(
	            'social_icons_bg_hover',
	            [
	                'label' 	=> esc_html__( 'Background Hover', 'yachbat' ),
	                'type' 		=> \Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .elementor-social-icons-wrapper .elementor-grid-item .elementor-social-icon:hover' => 'background-color: {{VALUE}};',
	                ],
	            ]
	        );

	        $element->add_control(
	            'social_icons_color_hover',
	            [
	                'label' 	=> esc_html__( 'Color Hover', 'yachbat' ),
	                'type' 		=> \Elementor\Controls_Manager::COLOR,
	                'selectors' => [
	                    '{{WRAPPER}} .elementor-social-icons-wrapper .elementor-grid-item .elementor-social-icon:hover i' => 'color: {{VALUE}};',
	                ],
	            ]
	        );

		$element->end_controls_section();
	}
    

}

return new Yachbat_Elementor();





