<?php
/**
 * Plugin Name: Innvoke VC-Elements
 * Plugin URI: http://themes.insigniats.in/
 * Description: This plugin adds several elements in your Visual Composer. Each of content element has been carefully created by web design professionals and offers multiple options. It extends and adds more power to your Visual Composer.
 * Version: 1.0  
 * Author: Insignia Technolabs
 * Author URI: http://insigniatechnolabs.com/
 * License:  GPL12
 */



/****** Start :: Visual Composer custom Element testimonial ***************/

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if( is_plugin_active( 'js_composer/js_composer.php' ) ) {

		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_counter.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_News-Blog.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_Pricing-box.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_icon-box.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_simple-icon-list.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_social-icons.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_image-box.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_section-heading.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_Button.php' ;
		require_once plugin_dir_path( __FILE__)  .'/innvoke-widgets/contact.php' ;
		require_once plugin_dir_path( __FILE__)  .'/innvoke-widgets/recent-post-widget.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_video_lightbox.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_google-map.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_clients-logos.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_number-box.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_Message-box.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_Custom-icon-with-text.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_process_step.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_table.php' ;
        require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_blockquotes.php' ;
		require_once plugin_dir_path( __FILE__)  .'/shortcodes/shortcodes-config.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_testimonial.php' ; 
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_team.php' ;
		require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_case-studies.php' ;
	    require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_custom-menu.php' ;
	    require_once plugin_dir_path( __FILE__)  .'/vc_template/VC_service-box.php' ;
}
		require_once plugin_dir_path( __FILE__)  .'social-sharing/socials-sharing.php' ;


    define('META_PLUGIN_PATH', plugin_dir_path( __FILE__ ));

    add_action( 'after_setup_theme', 'innvoke_meta_includes' );
    
    function innvoke_meta_includes() {
    	require_once (META_PLUGIN_PATH . 'cmb-functions.php');
    	require_once (META_PLUGIN_PATH . 'insignia-custom-post-type.php');
    	require_once (META_PLUGIN_PATH . 'insignia-iconpicker-iconsmind.php');
    }


	    // Menu item meta fields
	    
	    require_once plugin_dir_path( __FILE__) .'/plugins/nav-menu-custom-fields/nav-menu-custom-fields.php' ;

/****** End :: Visual Composer custom Element ***************/
/****** Start :: Custom Image Sizes  - Team Element ***************/

function insignia_element_script() {
require_once plugin_dir_path( __FILE__)  .'/script.php' ; 
}
add_action( 'wp_footer', 'insignia_element_script' );


	   	if ( !function_exists( 'ensign_build_link' ) ) {
   	  		function ensign_build_link( $label, $link, $classes ) {
   	  			
   	  			$link = vc_build_link( $link );
   	  			
   	  			if ( is_array( $link ) ) {
   	  				$url = $link['url'];
   	  			} else {
   	  				$url = $link;
   	  			}
   	  			
   	  			$anchor = '<a href="' . $url . '"';
   	  			
   	  			if ( is_array( $link ) ) {
   	  				if ( $link['target'] != '' ) $anchor .= ' target="' . $link['target'] . '"';
   	  				if ( $link['title'] != '' ) $anchor .= ' title="' . $link['title'] . '"';
   	  			}
   	  			
   	  			$anchor .= ' class="' . esc_attr( $classes ) . '">' . esc_html( $label ) . '</a>';
   	  			
   	  			return $anchor;
   	  			
   	  		}
   	  	}



function ensign_taxonomies_array( $taxonomy_name = null )
{

	if( $taxonomy_name != null ) {
	
		$taxonomies = get_categories( 'taxonomy=' . $taxonomy_name );
		
		if ( is_array( $taxonomies ) ) {
			
			$taxonomy_array = array();
			
			foreach ( $taxonomies as $taxonomy ) {
				if ( is_object( $taxonomy ) ) {
					$taxonomy_array[$taxonomy->name] = $taxonomy->slug;
				}
			}
			
			return $taxonomy_array;
			
		}
	
	}
	
	return null;
	
}


	/**
	 * Estimate time required to read the article
	 *
	 * @since   1.0
	 */
		function insignia_reading_time() {
			$content = get_post_field( 'post_content');
			$word_count = str_word_count( strip_tags( $content ) );
			$readingtime = ceil($word_count / 200);

			if ($readingtime == 1) {
			  $timer = " Min Read";
			} else {
			  $timer = " Min Read";
			}
			$totalreadingtime = $readingtime . $timer;

			return $totalreadingtime;
		}


/**
* Redux Framework Remove demo mode link
*
* @since       1.0
*/	

function insignia_remove_demo_mode_link() {
	if ( class_exists('ReduxFrameworkPlugin') ) {
		remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
	}
	if ( class_exists('ReduxFrameworkPlugin') ) {
		remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
	}
}
add_action('init', 'insignia_remove_demo_mode_link'); 


/**
* Remove WPB background image query string 
*
* @since       1.0
*/

add_filter('get_post_metadata', 'insignia_vc_fix_shortcodes_custom_css', 10, 4);
function insignia_vc_fix_shortcodes_custom_css($value, $object_id, $meta_key, $single) {
	if ($meta_key!='_wpb_shortcodes_custom_css' || is_admin()) {
		return $value;
	}
	// filter data for _wpb_shortcodes_custom_css only and not for admin

	remove_filter('get_post_metadata', 'insignia_vc_fix_shortcodes_custom_css', 10);
	$value = get_metadata('post', $object_id, $meta_key, $single);
	// we need to remove filter here because get_metadata function use "get_post_metadata" hook so we will have loop if not remove filter
	if ($value) {
		// you can use another regular expression, this is what I created quickly
		$value = preg_replace("/(background-image[:\s]+url\(\S+\.(jpg|jpeg|png|svg|gif))\?id=\d+(\))/", "$1$3", $value);
	}
	add_filter('get_post_metadata', 'insignia_vc_fix_shortcodes_custom_css', 10, 4);
	return $value;
}


add_filter( 'vc_iconpicker-type-themify', 'vc_addon_icon_themify' );

function vc_addon_icon_themify( $icons ) {
	$themify = array(
		array( "ti-wand" => __( "wand", "js_composer" ) ),
                array( "ti-volume" => __( "volume", "js_composer" ) ),
		array( "ti-user" => __( "user", "js_composer" ) ),
		array( "ti-unlock" => __( "unlock", "js_composer" ) ),
		array( "ti-unlink" => __( "unlink", "js_composer" ) ),
		array( "ti-trash" => __( "trash", "js_composer" ) ),
		array( "ti-thought" => __( "thought", "js_composer" ) ),
		array( "ti-target" => __( "target", "js_composer" ) ),
		array( "ti-tag" => __( "tag", "js_composer" ) ),
		array( "ti-tablet" => __( "tablet", "js_composer" ) ),
		array( "ti-star" => __( "star", "js_composer" ) ),
		array( "ti-spray" => __( "spray", "js_composer" ) ),
		array( "ti-signal" => __( "signal", "js_composer" ) ),
		array( "ti-shopping-cart" => __( "shopping-cart", "js_composer" ) ),
		array( "ti-shopping-cart-full" => __( "shopping-cart-full", "js_composer" ) ),
		array( "ti-settings" => __( "settings", "js_composer" ) ),
		array( "ti-search" => __( "search", "js_composer" ) ),
		array( "ti-zoom-in" => __( "zoom-in", "js_composer" ) ),
		array( "ti-zoom-out" => __( "zoom-out", "js_composer" ) ),
		array( "ti-cut" => __( "cut", "js_composer" ) ),
		array( "ti-ruler" => __( "ruler", "js_composer" ) ),
		array( "ti-ruler-pencil" => __( "ruler-pencil", "js_composer" ) ),
		array( "ti-ruler-alt" => __( "ruler-alt", "js_composer" ) ),
		array( "ti-bookmark" => __( "bookmark", "js_composer" ) ),
		array( "ti-bookmark-alt" => __( "bookmark-alt", "js_composer" ) ),
		array( "ti-reload" => __( "reload", "js_composer" ) ),
		array( "ti-plus" => __( "plus", "js_composer" ) ),
		array( "ti-pin" => __( "pin", "js_composer" ) ),
		array( "ti-pencil" => __( "pencil", "js_composer" ) ),
		array( "ti-pencil-alt" => __( "pencil-alt", "js_composer" ) ),
		array( "ti-paint-roller" => __( "paint-roller", "js_composer" ) ),
		array( "ti-paint-bucket" => __( "paint-bucket", "js_composer" ) ),
		array( "ti-na" => __( "na", "js_composer" ) ),
		array( "ti-mobile" => __( "mobile", "js_composer" ) ),
		array( "ti-minus" => __( "minus", "js_composer" ) ),
		array( "ti-medall" => __( "medall", "js_composer" ) ),
		array( "ti-medall-alt" => __( "medall-alt", "js_composer" ) ),
		array( "ti-marker" => __( "marker", "js_composer" ) ),
		array( "ti-marker-alt" => __( "marker-alt", "js_composer" ) ),
		array( "ti-arrow-up" => __( "arrow-up", "js_composer" ) ),
		array( "ti-arrow-right" => __( "arrow-right", "js_composer" ) ),
		array( "ti-arrow-left" => __( "arrow-left", "js_composer" ) ),
		array( "ti-arrow-down" => __( "arrow-down", "js_composer" ) ),
		array( "ti-lock" => __( "lock", "js_composer" ) ),
		array( "ti-location-arrow" => __( "location-arrow", "js_composer" ) ),
		array( "ti-link" => __( "link", "js_composer" ) ),
		array( "ti-layout" => __( "layout", "js_composer" ) ),
		array( "ti-layers" => __( "layers", "js_composer" ) ),
		array( "ti-layers-alt" => __( "layers-alt", "js_composer" ) ),
		array( "ti-key" => __( "key", "js_composer" ) ),
		array( "ti-import" => __( "import", "js_composer" ) ),
		array( "ti-image" => __( "image", "js_composer" ) ),
		array( "ti-heart" => __( "heart", "js_composer" ) ),
		array( "ti-heart-broken" => __( "heart-broken", "js_composer" ) ),
		array( "ti-hand-stop" => __( "hand-stop", "js_composer" ) ),
		array( "ti-hand-open" => __( "hand-open", "js_composer" ) ),
		array( "ti-hand-drag" => __( "hand-drag", "js_composer" ) ),
		array( "ti-folder" => __( "folder", "js_composer" ) ),
		array( "ti-flag" => __( "flag", "js_composer" ) ),
		array( "ti-flag-alt" => __( "flag-alt", "js_composer" ) ),
		array( "ti-flag-alt-2" => __( "flag-alt-2", "js_composer" ) ),
		array( "ti-eye" => __( "eye", "js_composer" ) ),
		array( "ti-export" => __( "export", "js_composer" ) ),
		array( "ti-exchange-vertical" => __( "exchange-vertical", "js_composer" ) ),
		array( "ti-desktop" => __( "desktop", "js_composer" ) ),
		array( "ti-cup" => __( "cup", "js_composer" ) ),
		array( "ti-crown" => __( "crown", "js_composer" ) ),
		array( "ti-comments" => __( "comments", "js_composer" ) ),
		array( "ti-comment" => __( "comment", "js_composer" ) ),
		array( "ti-comment-alt" => __( "comment-alt", "js_composer" ) ),
		array( "ti-close" => __( "close", "js_composer" ) ),
		array( "ti-clip" => __( "clip", "js_composer" ) ),
		array( "ti-angle-up" => __( "angle-up", "js_composer" ) ),
		array( "ti-angle-right" => __( "angle-right", "js_composer" ) ),
		array( "ti-angle-left" => __( "angle-left", "js_composer" ) ),
		array( "ti-angle-down" => __( "angle-down", "js_composer" ) ),
		array( "ti-check" => __( "check", "js_composer" ) ),
		array( "ti-check-box" => __( "check-box", "js_composer" ) ),
		array( "ti-camera" => __( "camera", "js_composer" ) ),
		array( "ti-announcement" => __( "announcement", "js_composer" ) ),
		array( "ti-brush" => __( "brush", "js_composer" ) ),
		array( "ti-briefcase" => __( "briefcase", "js_composer" ) ),
		array( "ti-bolt" => __( "bolt", "js_composer" ) ),
		array( "ti-bolt-alt" => __( "bolt-alt", "js_composer" ) ),
		array( "ti-blackboard" => __( "blackboard", "js_composer" ) ),
		array( "ti-bag" => __( "bag", "js_composer" ) ),
		array( "ti-move" => __( "move", "js_composer" ) ),
		array( "ti-arrows-vertical" => __( "arrows-vertical	", "js_composer" ) ),
		array( "ti-arrows-horizontal" => __( "arrows-horizontal", "js_composer" ) ),
		array( "ti-arrow-top-right" => __( "arrow-top-right", "js_composer" ) ),
	        array( "ti-arrow-top-left" => __( "arrow-top-left", "js_composer" ) ),
		array( "ti-arrow-circle-up" => __( "arrow-circle-up", "js_composer" ) ),
		array( "ti-arrow-circle-right" => __( "arrow-circle-right", "js_composer" ) ),
		array( "ti-arrow-circle-left" => __( "arrow-circle-left", "js_composer" ) ),
		array( "ti-arrow-circle-down" => __( "arrow-circle-down", "js_composer" ) ),
		array( "ti-angle-double-up" => __( "angle-double-up", "js_composer" ) ),
		array( "ti-angle-double-right" => __( "angle-double-right", "js_composer" ) ),
		array( "ti-angle-double-left" => __( "angle-double-left", "js_composer" ) ),
		array( "ti-angle-double-down" => __( "angle-double-down", "js_composer" ) ),
		array( "ti-zip" => __( "zip", "js_composer" ) ),
		array( "ti-world" => __( "world", "js_composer" ) ),
		array( "ti-wheelchair" => __( "wheelchair", "js_composer" ) ),
		array( "ti-view-list" => __( "view-list", "js_composer" ) ),
		array( "ti-view-list-alt" => __( "view-list-alt", "js_composer" ) ),
		array( "ti-view-grid" => __( "view-grid", "js_composer" ) ),
		array( "ti-uppercase" => __( "uppercase", "js_composer" ) ),
		array( "ti-upload" => __( "upload", "js_composer" ) ),
		array( "ti-underline" => __( "underline", "js_composer" ) ),
		array( "ti-truck" => __( "truck", "js_composer" ) ),
		array( "ti-timer" => __( "timer", "js_composer" ) ),
		array( "ti-ticket" => __( "ticket", "js_composer" ) ),
		array( "ti-thumb-up" => __( "thumb-up", "js_composer" ) ),
		array( "ti-thumb-down" => __( "thumb-down", "js_composer" ) ),
		array( "ti-text" => __( "text", "js_composer" ) ),
		array( "ti-stats-up" => __( "stats-up", "js_composer" ) ),
		array( "ti-stats-down" => __( "stats-down", "js_composer" ) ),
		array( "ti-split-v" => __( "split-v", "js_composer" ) ),
		array( "ti-split-h" => __( "split-h", "js_composer" ) ),
		array( "ti-smallcap" => __( "smallcap", "js_composer" ) ),
		array( "ti-shine" => __( "shine", "js_composer" ) ),
		array( "ti-shift-right" => __( "shift-right", "js_composer" ) ),
		array( "ti-shift-left" => __( "shift-left", "js_composer" ) ),
		array( "ti-shield" => __( "shield", "js_composer" ) ),
		array( "ti-notepad" => __( "notepad", "js_composer" ) ),
		array( "ti-server" => __( "server", "js_composer" ) ),
		array( "ti-quote-right" => __( "quote-right", "js_composer" ) ),
		array( "ti-quote-left" => __( "quote-left", "js_composer" ) ),
		array( "ti-pulse" => __( "pulse", "js_composer" ) ),
		array( "ti-printer" => __( "printer", "js_composer" ) ),
		array( "ti-power-off" => __( "power-off", "js_composer" ) ),
		array( "ti-plug" => __( "plug", "js_composer" ) ),
		array( "ti-pie-chart" => __( "pie-chart", "js_composer" ) ),
		array( "ti-paragraph" => __( "paragraph", "js_composer" ) ),
		array( "ti-panel" => __( "panel", "js_composer" ) ),
		array( "ti-package" => __( "package", "js_composer" ) ),
		array( "ti-music" => __( "music", "js_composer" ) ),
		array( "ti-mouse" => __( "mouse", "js_composer" ) ),
		array( "ti-mouse-alt" => __( "mouse-alt", "js_composer" ) ),
		array( "ti-money" => __( "money", "js_composer" ) ),
		array( "ti-microphone" => __( "microphone", "js_composer" ) ),
		array( "ti-menu" => __( "menu", "js_composer" ) ),
		array( "ti-menu-alt" => __( "menu-alt", "js_composer" ) ),
		array( "ti-map" => __( "map", "js_composer" ) ),
		array( "ti-map-alt" => __( "map-alt", "js_composer" ) ),
		array( "ti-loop" => __( "loop", "js_composer" ) ),
		array( "ti-location-pin" => __( "location-pin", "js_composer" ) ),
		array( "ti-list" => __( "list", "js_composer" ) ),
		array( "ti-light-bulb" => __( "light-bulb", "js_composer" ) ),
		array( "ti-Italic" => __( "Italic", "js_composer" ) ),
		array( "ti-info" => __( "info", "js_composer" ) ),
		array( "ti-infinite" => __( "infinite", "js_composer" ) ),
		array( "ti-id-badge" => __( "id-badge", "js_composer" ) ),
		array( "ti-hummer" => __( "hummer", "js_composer" ) ),
		array( "ti-home" => __( "home", "js_composer" ) ),
		array( "ti-help" => __( "help", "js_composer" ) ),
		array( "ti-headphone" => __( "headphone", "js_composer" ) ),
		array( "ti-harddrives" => __( "harddrives", "js_composer" ) ),
		array( "ti-harddrive" => __( "harddrive", "js_composer" ) ),
		array( "ti-gift" => __( "gift", "js_composer" ) ),
		array( "ti-game" => __( "game", "js_composer" ) ),
		array( "ti-filter" => __( "filter", "js_composer" ) ),
		array( "ti-files" => __( "files", "js_composer" ) ),
		array( "ti-file" => __( "file", "js_composer" ) ),
		array( "ti-eraser" => __( "eraser", "js_composer" ) ),
		array( "ti-envelope" => __( "envelope", "js_composer" ) ),
		array( "ti-download" => __( "download", "js_composer" ) ),
		array( "ti-direction" => __( "direction", "js_composer" ) ),
		array( "ti-direction-alt" => __( "direction-alt", "js_composer" ) ),
		array( "ti-dashboard" => __( "dashboard", "js_composer" ) ),
		array( "ti-control-stop" => __( "control-stop", "js_composer" ) ),
		array( "ti-control-shuffle" => __( "control-shuffle", "js_composer" ) ),
		array( "ti-control-play" => __( "control-play", "js_composer" ) ),
		array( "ti-control-pause" => __( "control-pause", "js_composer" ) ),
		array( "ti-control-forward" => __( "control-forward", "js_composer" ) ),
		array( "ti-control-backward" => __( "control-backward", "js_composer" ) ),
		array( "ti-cloud" => __( "cloud", "js_composer" ) ),
		array( "ti-cloud-up" => __( "cloud-up", "js_composer" ) ),
		array( "ti-cloud-down" => __( "cloud-down", "js_composer" ) ),
		array( "ti-clipboard" => __( "clipboard", "js_composer" ) ),
		array( "ti-car" => __( "car", "js_composer" ) ),
		array( "ti-calendar" => __( "calendar", "js_composer" ) ),
		array( "ti-bell" => __( "bell", "js_composer" ) ),
		array( "ti-basketball" => __( "basketball", "js_composer" ) ),
		array( "ti-bar-chart" => __( "bar-chart", "js_composer" ) ),
		array( "ti-bar-chart-alt" => __( "bar-chart-alt", "js_composer" ) ),
		array( "ti-back-right" => __( "back-right", "js_composer" ) ),
		array( "ti-back-left" => __( "back-left", "js_composer" ) ),
		array( "ti-arrows-corner" => __( "arrows-corner", "js_composer" ) ),
		array( "ti-archive" => __( "archive", "js_composer" ) ),
		array( "ti-anchor" => __( "anchor", "js_composer" ) ),
		array( "ti-align-right" => __( "align-right", "js_composer" ) ),
		array( "ti-align-left" => __( "align-left", "js_composer" ) ),
		array( "ti-align-justify" => __( "align-justify", "js_composer" ) ),
		array( "ti-align-center" => __( "align-center", "js_composer" ) ),
		array( "ti-alert" => __( "alert", "js_composer" ) ),
		array( "ti-alarm-clock" => __( "alarm-clock", "js_composer" ) ),
		array( "ti-agenda" => __( "agenda", "js_composer" ) ),
		array( "ti-write" => __( "write", "js_composer" ) ),
		array( "ti-window" => __( "window", "js_composer" ) ),
		array( "ti-widgetized" => __( "widgetized", "js_composer" ) ),
		array( "ti-widget" => __( "widget", "js_composer" ) ),
		array( "ti-widget-alt" => __( "widget-alt", "js_composer" ) ),
		array( "ti-wallet" => __( "wallet", "js_composer" ) ),
		array( "ti-video-clapper" => __( "video-clapper", "js_composer" ) ),
		array( "ti-video-camera" => __( "video-camera", "js_composer" ) ),
		array( "ti-vector" => __( "vector", "js_composer" ) ),
		array( "ti-themify-logo" => __( "themify-logo", "js_composer" ) ),
		array( "ti-themify-favicon" => __( "themify-favicon", "js_composer" ) ),
		array( "ti-themify-favicon-alt" => __( "themify-favicon-alt", "js_composer" ) ),
		array( "ti-support" => __( "support", "js_composer" ) ),
		array( "ti-stamp" => __( "stamp", "js_composer" ) ),
		array( "ti-split-v-alt" => __( "split-v-alt", "js_composer" ) ),
		array( "ti-slice" => __( "slice", "js_composer" ) ),
		array( "ti-shortcode" => __( "shortcode", "js_composer" ) ),
		array( "ti-shift-right-alt" => __( "shift-right-alt", "js_composer" ) ),
		array( "ti-shift-left-alt" => __( "shift-left-alt", "js_composer" ) ),
		array( "ti-ruler-alt-2" => __( "ruler-alt-2", "js_composer" ) ),
		array( "ti-receipt" => __( "receipt", "js_composer" ) ),
		array( "ti-pin2" => __( "pin2", "js_composer" ) ),
		array( "ti-pin-alt" => __( "pin-alt", "js_composer" ) ),
		array( "ti-pencil-alt2" => __( "pencil-alt2", "js_composer" ) ),
		array( "ti-palette" => __( "palette", "js_composer" ) ),
		array( "ti-more" => __( "more", "js_composer" ) ),
		array( "ti-more-alt" => __( "more-alt", "js_composer" ) ),
		array( "ti-microphone-alt" => __( "microphone-alt", "js_composer" ) ),
		array( "ti-magnet" => __( "magnet", "js_composer" ) ),
		array( "ti-line-double" => __( "line-double", "js_composer" ) ),
		array( "ti-line-dotted" => __( "line-dotted", "js_composer" ) ),
		array( "ti-line-dashed" => __( "line-dashed", "js_composer" ) ),
		array( "ti-layout-width-full" => __( "layout-width-full", "js_composer" ) ),
		array( "ti-layout-width-default" => __( "layout-width-default", "js_composer" ) ),
		array( "ti-layout-width-default-alt" => __( "layout-width-default-alt", "js_composer" ) ),
		array( "ti-layout-tab" => __( "layout-tab", "js_composer" ) ),
		array( "ti-layout-tab-window" => __( "layout-tab-window", "js_composer" ) ),
		array( "ti-layout-tab-v" => __( "layout-tab-v", "js_composer" ) ),
		array( "ti-layout-tab-min" => __( "layout-tab-min", "js_composer" ) ),
		array( "ti-layout-slider" => __( "layout-slider", "js_composer" ) ),
		array( "ti-layout-slider-alt" => __( "layout-slider-alt", "js_composer" ) ),
		array( "ti-layout-sidebar-right" => __( "layout-sidebar-right", "js_composer" ) ),
		array( "ti-layout-sidebar-none" => __( "layout-sidebar-none", "js_composer" ) ),
		array( "ti-layout-sidebar-left" => __( "layout-sidebar-left", "js_composer" ) ),
		array( "ti-layout-placeholder" => __( "layout-placeholder", "js_composer" ) ),
		array( "ti-layout-menu" => __( "layout-menu", "js_composer" ) ),
		array( "ti-layout-menu-v" => __( "layout-menu-v", "js_composer" ) ),
		array( "ti-layout-menu-separated" => __( "layout-menu-separated", "js_composer" ) ),
		array( "ti-layout-menu-full" => __( "layout-menu-full", "js_composer" ) ),
		array( "ti-layout-media-right-alt" => __( "layout-media-right-alt", "js_composer" ) ),
		array( "ti-layout-media-right" => __( "layout-media-right", "js_composer" ) ),
		array( "ti-layout-media-overlay" => __( "layout-media-overlay", "js_composer" ) ),
		array( "ti-layout-media-overlay-alt" => __( "layout-media-overlay-alt", "js_composer" ) ),
		array( "ti-layout-media-overlay-alt-2" => __( "layout-media-overlay-alt-2", "js_composer" ) ),
		array( "ti-layout-media-left-alt" => __( "layout-media-left-alt", "js_composer" ) ),
		array( "ti-layout-media-left" => __( "layout-media-left", "js_composer" ) ),
		array( "ti-layout-media-center-alt" => __( "layout-media-center-alt", "js_composer" ) ),
		array( "ti-layout-media-center" => __( "layout-media-center", "js_composer" ) ),
		array( "ti-layout-list-thumb" => __( "layout-list-thumb", "js_composer" ) ),
		array( "ti-layout-list-thumb-alt" => __( "layout-list-thumb-alt", "js_composer" ) ),
		array( "ti-layout-list-post" => __( "layout-list-post", "js_composer" ) ),
		array( "ti-layout-list-large-image" => __( "layout-list-large-image", "js_composer" ) ),
		array( "ti-layout-line-solid" => __( "layout-line-solid", "js_composer" ) ),
		array( "ti-layout-grid4" => __( "layout-grid4", "js_composer" ) ),
		array( "ti-layout-grid3" => __( "layout-grid3", "js_composer" ) ),
		array( "ti-layout-grid2" => __( "layout-grid2", "js_composer" ) ),
		array( "ti-layout-grid2-thumb" => __( "layout-grid2-thumb", "js_composer" ) ),
		array( "ti-layout-cta-right" => __( "layout-cta-right", "js_composer" ) ),
		array( "ti-layout-cta-left" => __( "layout-cta-left", "js_composer" ) ),
		array( "ti-layout-cta-center" => __( "layout-cta-center", "js_composer" ) ),
		array( "ti-layout-cta-btn-right" => __( "layout-cta-btn-right", "js_composer" ) ),
		array( "ti-layout-cta-btn-left" => __( "layout-cta-btn-left", "js_composer" ) ),
		array( "ti-layout-column4" => __( "layout-column4", "js_composer" ) ),
		array( "ti-layout-column3" => __( "layout-column3", "js_composer" ) ),
		array( "ti-layout-column2" => __( "layout-column2", "js_composer" ) ),
		array( "ti-layout-accordion-separated" => __( "layout-accordion-separated	", "js_composer" ) ),
		array( "ti-layout-accordion-merged" => __( "layout-accordion-merged", "js_composer" ) ),
		array( "ti-layout-accordion-list" => __( "layout-accordion-list", "js_composer" ) ),
		array( "ti-ink-pen" => __( "ink-pen", "js_composer" ) ),
		array( "ti-info-alt" => __( "info-alt", "js_composer" ) ),
		array( "ti-help-alt" => __( "help-alt", "js_composer" ) ),
		array( "ti-headphone-alt" => __( "headphone-alt", "js_composer" ) ),
		array( "ti-hand-point-up" => __( "hand-point-up", "js_composer" ) ),
		array( "ti-hand-point-right" => __( "hand-point-right", "js_composer" ) ),
		array( "ti-hand-point-left" => __( "hand-point-left", "js_composer" ) ),
		array( "ti-hand-point-down" => __( "hand-point-down", "js_composer" ) ),
		array( "ti-gallery" => __( "gallery", "js_composer" ) ),
		array( "ti-face-smile" => __( "face-smile", "js_composer" ) ),
		array( "ti-face-sad" => __( "face-sad", "js_composer" ) ),
		array( "ti-credit-card" => __( "credit-card", "js_composer" ) ),
		array( "ti-control-skip-forward" => __( "control-skip-forward", "js_composer" ) ),
		array( "ti-control-skip-backward" => __( "control-skip-backward", "js_composer" ) ),
		array( "ti-control-record" => __( "control-record", "js_composer" ) ),
		array( "ti-control-eject" => __( "control-eject", "js_composer" ) ),
		array( "ti-comments-smiley" => __( "comments-smiley", "js_composer" ) ),
		array( "ti-brush-alt" => __( "brush-alt", "js_composer" ) ),
		array( "ti-youtube" => __( "youtube", "js_composer" ) ),
		array( "ti-vimeo" => __( "vimeo", "js_composer" ) ),
		array( "ti-twitter" => __( "twitter", "js_composer" ) ),
		array( "ti-time" => __( "time", "js_composer" ) ),
		array( "ti-tumblr" => __( "tumblr", "js_composer" ) ),
		array( "ti-skype" => __( "skype", "js_composer" ) ),
		array( "ti-share-alt" => __( "share-alt", "js_composer" ) ),
		array( "ti-rocket" => __( "rocket", "js_composer" ) ),
		array( "ti-pinterest" => __( "pinterest", "js_composer" ) ),
		array( "ti-new-window" => __( "new-window", "js_composer" ) ),
		array( "ti-microsoft" => __( "microsoft", "js_composer" ) ),
		array( "ti-list-ol" => __( "list-ol", "js_composer" ) ),
		array( "ti-linkedin" => __( "linkedin", "js_composer" ) ),
		array( "ti-layout-sidebar-2" => __( "layout-sidebar-2", "js_composer" ) ),
		array( "ti-layout-grid4-alt" => __( "layout-grid4-alt", "js_composer" ) ),
		array( "ti-layout-grid3-alt" => __( "layout-grid3-alt", "js_composer" ) ),
		array( "ti-layout-grid2-alt" => __( "layout-grid2-alt", "js_composer" ) ),
		array( "ti-layout-column4-alt" => __( "layout-column4-alt", "js_composer" ) ),
		array( "ti-layout-column3-alt" => __( "layout-column3-alt", "js_composer" ) ),
		array( "ti-layout-column2-alt" => __( "layout-column2-alt", "js_composer" ) ),
		array( "ti-instagram" => __( "instagram", "js_composer" ) ),
		array( "ti-google" => __( "google", "js_composer" ) ),
		array( "ti-github" => __( "github", "js_composer" ) ),
		array( "ti-flickr" => __( "flickr", "js_composer" ) ),
		array( "ti-facebook" => __( "facebook", "js_composer" ) ),
		array( "ti-dropbox" => __( "dropbox", "js_composer" ) ),
		array( "ti-dribbble" => __( "dribbble", "js_composer" ) ),
		array( "ti-apple" => __( "apple", "js_composer" ) ),
		array( "ti-android" => __( "android", "js_composer" ) ),
		array( "ti-save" => __( "save", "js_composer" ) ),
		array( "ti-yahoo" => __( "yahoo", "js_composer" ) ),
		array( "ti-wordpress" => __( "wordpress", "js_composer" ) ),
		array( "ti-vimeo-alt" => __( "vimeo-alt", "js_composer" ) ),
		array( "ti-twitter-alt" => __( "twitter-alt", "js_composer" ) ),
		array( "ti-tumblr-alt" => __( "tumblr-alt", "js_composer" ) ),
		array( "ti-trello" => __( "trello", "js_composer" ) ),
		array( "ti-stack-overflow" => __( "stack-overflow", "js_composer" ) ),
		array( "ti-soundcloud" => __( "soundcloud", "js_composer" ) ),
		array( "ti-sharethis" => __( "sharethis", "js_composer" ) ),
		array( "ti-sharethis-alt" => __( "sharethis-alt", "js_composer" ) ),
		array( "ti-reddit" => __( "reddit", "js_composer" ) ),
		array( "ti-pinterest-alt" => __( "pinterest-alt", "js_composer" ) ),
		array( "ti-microsoft-alt" => __( "microsoft-alt", "js_composer" ) ),
		array( "ti-linux" => __( "linux", "js_composer" ) ),
		array( "ti-jsfiddle" => __( "jsfiddle", "js_composer" ) ),
		array( "ti-joomla" => __( "joomla", "js_composer" ) ),
		array( "ti-html5" => __( "html5", "js_composer" ) ),
		array( "ti-flickr-alt" => __( "flickr-alt", "js_composer" ) ),
		array( "ti-email" => __( "email", "js_composer" ) ),
		array( "ti-drupal" => __( "drupal", "js_composer" ) ),
		array( "ti-dropbox-alt" => __( "dropbox-alt", "js_composer" ) ),
		array( "ti-css3" => __( "css3", "js_composer" ) ),
		array( "ti-rss" => __( "rss", "js_composer" ) ),
		array( "ti-rss-alt" => __( "rss-alt", "js_composer" ) ),
		
	);
	return array_merge( $icons, $themify );
}
