<?php
function testimonial_post_type() {

	$labels = array(
		'name'                  => _x( 'Testimonials', 'Post Type General Name', 'emerson' ),
		'singular_name'         => _x( 'Testimonial', 'Post Type Singular Name', 'emerson' ),
		'menu_name'             => __( 'Testimonial', 'emerson' ),
		'name_admin_bar'        => __( 'Testimonial', 'emerson' ),
		'archives'              => __( 'Testimonial Archives', 'emerson' ),
		'attributes'            => __( 'Item Attributes', 'emerson' ),
		'parent_item_colon'     => __( 'Parent Item:', 'emerson' ),
		'all_items'             => __( 'All Testimonials', 'emerson' ),
		'add_new_item'          => __( 'Add New Testimonial', 'emerson' ),
		'add_new'               => __( 'Add New Testimonial', 'emerson' ),
		'new_item'              => __( 'New Item', 'emerson' ),
		'edit_item'             => __( 'Edit Testimonial', 'emerson' ),
		'update_item'           => __( 'Update Testimonial', 'emerson' ),
		'view_item'             => __( 'View Testimonial', 'emerson' ),
		'view_items'            => __( 'View Testimonials', 'emerson' ),
		'search_items'          => __( 'Search Testimonial', 'emerson' ),
		'not_found'             => __( 'Not found', 'emerson' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'emerson' ),
		'featured_image'        => __( 'Featured Image', 'emerson' ),
		'set_featured_image'    => __( 'Set featured image', 'emerson' ),
		'remove_featured_image' => __( 'Remove featured image', 'emerson' ),
		'use_featured_image'    => __( 'Use as featured image', 'emerson' ),
		'insert_into_item'      => __( 'Insert into Testimonial', 'emerson' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'emerson' ),
		'items_list'            => __( 'Testimonials list', 'emerson' ),
		'items_list_navigation' => __( 'Testimonials list navigation', 'emerson' ),
		'filter_items_list'     => __( 'Filter Testimonials list', 'emerson' ),
	);
	$args = array(
		'label'                 => __( 'Testimonial', 'emerson' ),
		'labels'                => $labels,
        'menu_icon'             => 'dashicons-format-quote',
		'supports'              => array( 'title', 'editor', 'thumbnail' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
				
		'exclude_from_search'   => true,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'testimonial_post', $args );

}
add_action( 'init', 'testimonial_post_type', 1);

add_action( 'init', 'create_testimonial_tax',0 );

function create_testimonial_tax() {
	register_taxonomy(
		'testimonial_category',
		'testimonial_post',
		array(
			'label' => __( 'Testimonial Category' ),
			'rewrite' => array( 'slug' => 'testimonial_category' ),
			'hierarchical' => true,
		)
	);
}

/*
End Testimonial custom post field
*/

// Register Case Studies Custom Post Type


function wp_case_studies() {
	register_post_type( 'case_studies',
		array(
			'labels' => array(
				'name' => ( 'Case Studies' ),
				'singular_name' => ( 'Case Studies' ),
				'add_new' => ( 'Add New ' ),
				'add_new_item' => ( 'Add New Case Study' ),
				'edit_item' => ( 'Edit Case Study' ),
				'new_item' => ( 'Add New Case Study' ),
				'view_item' => ( 'View Case Study' ),
				'search_items' => ( 'Search Case Studies' ),
				'not_found' => ( 'No Case Studies found' ),
				'not_found_in_trash' => ( 'No Case Studies found in trash' )
			),
			'public' => true,
			'supports' => array( 'title', 'editor', 'thumbnail', 'comments' ),
			'taxonomies' => array('case_studies_category'),
			'capability_type' => 'post',
			'rewrite' => array("slug" => "case_studies"), // Permalinks format
			'menu_position' => 5,
                        'has_archive'           => true,	
                        'menu_icon' => 'dashicons-screenoptions'
		)
	);
}

add_action( 'init', 'wp_case_studies' );


add_action( 'init', 'create_case_studies_tax',0 );

function create_case_studies_tax() {
	register_taxonomy(
		'case_studies_category',
		'case_studies',
		array(
			'label' => __( 'Case Studies Category' ),
			'rewrite' => array( 'slug' => 'case_studies_category' ),
			'hierarchical' => true,
		)
	);
}
