<?php
/**
 *
 * Case Studies VC element by INSIGNIA
 *
 */



/*Case Studies*/

add_action( 'vc_before_init', 'insignia_case_studies' );

function insignia_case_studies() {
 $terms = get_terms([
    'taxonomy' => 'case_studies_category',
    'hide_empty' => false,
]);
    $port_categories = array();
    foreach ($terms as $term) {
        $port_categories[$term->slug] = $term->slug;
    }


  vc_map (

 array(
      "name" => __( "Case Studies", "emerson" ),
      "base" => "case_studies",
      "class" => "",
      "category" => __( "Insignia", "emerson"),
	"class" => "font-awesome",
	"icon" => "fa fa-th",
       
      
      "params" => array(
          array(
            "type" => "dropdown",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "group" => "General",
            "heading" => __( "Case Studies Layout", "emerson" ),
            "param_name" => "port_layout",
            "admin_label" => true,
            "value"       => array(
	'Select Layout'   => 'Grid',       
	'2 Columns'   => 'port_grid2',
	'3 Columns'   => 'port_grid3',
	'4 Columns' => 'port_grid4',
    'Case Studies Carousel' => 'port_carousel'
      ),
      ),


        
          array(
            "type" => "checkbox",
            "class" => "",
            "edit_field_class" => "vc_col-xs-12 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Select Category", "emerson" ),
            "param_name" => "port_cat",
            "group" => "General",
        	'save_always' => true,
            "value"       => $port_categories,
            "description" => __( "Select Categories. You can choose multiple categories", "emerson" )

      ),


          


          
  array(
            "type" => "textfield",
            "class" => "",
             "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Number of Posts to display.", "emerson" ),
            "param_name" => "port_no_posts",
            "group" => "General",
            "value" => __( "", "emerson" ),
              "description" => __( "You can choose limited number of posts to display on page.", "emerson" )
            
         ),


       array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "group" => "General",
                            "param_name" => "css_animation",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
'dependency' => array(
						'element' => 'port_layout',
						'value' => array('Grid','port_grid2','port_grid3','port_grid4')
						
                ),
                        ),

                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "group" => "General",
                            "param_name" => "ib_animation_delay",
                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign"),

                        ),



      array(
            "type" => "textfield",
            "class" => "",
            "edit_field_class" => "vc_col-xs-12 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Extra Class Name", "emerson" ),
            "param_name" => "extra_class",
            "group" => "General",
            "value" => __( "", "emerson" ),
              "description" => __( "Style particular content element differently - add a class name and refer to it in custom CSS.", "emerson" )
            
         ),
         
		array(
		"type" => "dropdown",
		"description" => esc_html__( "Sort/order your posts by a certain value.", 'citta' ),
		"class" => "hidden-label",
		"heading" => esc_html__( "Order posts by", "emerson" ),
		"param_name" => "orderby",
		"value" => array(
			esc_html__( "Date", 'citta' ) => "date",
			esc_html__( "None - no order", 'citta' ) => "none",
			esc_html__( "Post ID", 'citta' ) => "ID",
			esc_html__( "Author", 'citta' ) => "author",
			esc_html__( "Title", 'citta' ) => "title",
			esc_html__( "Name (slug)", 'citta' ) => "name",
			esc_html__( "Menu Order", 'citta' ) => "menu_order" 
		),
		"group" => esc_html__( "Order Settings", "emerson" ) 
		),
		
		array(
			"type" => "dropdown",
			"description" => esc_html__( "Posts order.", 'citta' ),
			"class" => "hidden-label",
			"heading" => esc_html__( "Posts order", "emerson" ),
			"param_name" => "order",
			"value" => array(
				esc_html__( "Descending (DESC)", 'citta' ) => "DESC",
				esc_html__( "Ascending (ASC)", 'citta' ) => "ASC" 
			),
			"group" => esc_html__( "Order Settings", "emerson" ) 
		),         


		array(
		"type" => "dropdown",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Autoplay", "emerson" ),
		"param_name" => "portfolio_autoplay",
		"group" => "Carousel setting",
		"value"       => array(
		'True'   => 'true',
		'False'   => 'false'
		),
		"std"         => 'True',
		"description" => __( "Enable/Disable Autoplay.", "emerson" ),
		"dependency" => array(
			'element' => 'port_layout',
			'value' => array('port_carousel')	
		),

		),
		array(
		"type" => "textfield",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Speed", "emerson" ),
		"param_name" => "portfolio_speed",
		"group" => "Carousel setting",
		"value" => __( "3000", "emerson" ),
		"description" => __( "Choose speed for carousel transition in milliseconds (Example:300).", "emerson" ),
		"dependency" => array(
			'element' => 'port_layout',
			'value' => array('port_carousel')	
		),

		),
		array(
		"type" => "dropdown",
		"heading" => esc_html__( "Columns", 'citta' ),
		"param_name" => "portfolio_slidetoshow",
		"value" => array("Select Number of Columns", "4", "3", "2", "1" ),
		"group" => "Carousel setting",
		"description" => esc_html__( "Number of columns", 'citta' ),
		"dependency" => array(
			'element' => 'port_layout',
			'value' => array('port_carousel')	
		),
		),

		
		array(
		"type" => "dropdown",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Dots", "emerson" ),
		"param_name" => "portfolio_navigation_dots",
		"group" => "Carousel setting",
		"value"       => array(
		'True'   => 'true',
		'False'   => 'false'

		),
		"std"         => '',
		"description" => __( "Dots for navigation.", "emerson" ),
		"dependency" => array(
			'element' => 'port_layout',
			'value' => array('port_carousel')	
		),
		),
		
      array(
            'type' => 'css_editor',
            'heading' => __( 'Css', 'citta' ),
            'param_name' => 'css',
            'group' => __( 'Design options', 'citta' ),
        )


    )));
}



add_shortcode( 'case_studies', 'case_studies_shortcode' );


function case_studies_shortcode( $atts ) {
$css = '';
 extract( shortcode_atts( array(
 'port_layout' => 'port_grid3',
 'appear_effects' => '',
 'port_no_posts' => '',
 'port_cat' => '',
 'portfolio_autoplay' => '',
 'portfolio_speed' => '1000',
 'portfolio_slidetoshow' => '4',
 'portfolio_navigation_dots' => 'true',
 'css' => '',
 'orderby' => '',
 'order' => '',
 'extra_class' => '',
 'css_animation'  => '',
 'ib_animation_delay'=> ''
   ), $atts ) );

global $post, $insignia_port_no_posts1, $insignia_port_out, $insignia_appear_effects1, $insignia_port_cat1, $insignia_css1, $portfolio_extra_class1, $insignia_orderby1, $insignia_order1, $insignia_portfolio_extra_class1, $insignia_portfolio_autoplay, $insignia_portfolio_speed, $insignia_portfolio_slidetoshow, $insignia_portfolio_dots, $css_animation1, $animation_delay;

        $insignia_port_out = ${'port_layout'};
        $insignia_appear_effects1 = ${'appear_effects'};
        $insignia_port_no_posts1 = ${'port_no_posts'}; 
        $insignia_port_cat1 = ${'port_cat'};
        $insignia_portfolio_autoplay = ${'portfolio_autoplay'};
        $insignia_portfolio_speed = ${'portfolio_speed'};
        $insignia_portfolio_slidetoshow = ${'portfolio_slidetoshow'};
        $insignia_portfolio_dots = ${'portfolio_navigation_dots'};
        $insignia_css1=apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts );
        $insignia_portfolio_extra_class1=${'extra_class'};
        $insignia_orderby1= ${'order'};
        $insignia_order1= ${'orderby'};
        $css_animation1=${'css_animation'};
       $ib_animation_delay1=${'ib_animation_delay'};


      //CSS Animation
            if ($css_animation1 == "no_animation") {
                $css_animation1 = "";
            }

          $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay1) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay1;
            }

      
       if(!isset($insignia_portfolio_extra_class1))
        $insignia_portfolio_extra_class1='';

       if(empty($insignia_port_no_posts1)){
        $insignia_port_no_posts1='-1'; }


$selected_cat = explode(',', $insignia_port_cat1);
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	if(empty($insignia_port_cat1)){

	$args = array(
	'post_type' => 'case_studies',
	'orderby' => $orderby,
	'order' => $order, 
	'posts_per_page' => $insignia_port_no_posts1,
	'paged'=>$paged
);
} else{

	$args = array(
	'post_type' => 'case_studies',
	'orderby' => $orderby,
	'order' => $order, 
	'posts_per_page' => $insignia_port_no_posts1,
	'tax_query' => array(
		array(
			'taxonomy' => 'case_studies_category',
			'field'    => 'slug',
		 'terms' => $selected_cat
		),
	),
       'paged'=>$paged
	
);
}
	
	
		$posts = new WP_Query($args);
if ( $posts->have_posts() ) {
if($port_layout == "port_grid2" || $port_layout == "port_grid3" || $port_layout == "port_grid4")
{
	ob_start();
	include(locate_template('inc/templates/case-studies/archive/case-studies-grid-main.php'));
	$return_html = trim(preg_replace('/\s\s+/', ' ', ob_get_clean()));
	return $return_html;
}

elseif($port_layout == "port_carousel")  {
	ob_start();
	include(locate_template('inc/templates/case-studies/archive/case-studies-carousel-main.php'));
	$return_html = trim(preg_replace('/\s\s+/', ' ', ob_get_clean()));
	return $return_html;
}

else{
	ob_start();
	include(locate_template('inc/templates/case-studies/archive/case-studies-grid-main.php'));
	$return_html = trim(preg_replace('/\s\s+/', ' ', ob_get_clean()));
	return $return_html;
}
}else{
	echo "<p class='alert alert-danger border-all '>No Case Studies found.</p>";
}
}


