<?php
/**
 *
 * Custom Menu field
 *
 */




	function rt_get_menu() {
		$custom_menus = array();
		if ( 'vc_edit_form' === vc_post_param( 'action' ) && vc_verify_admin_nonce() ) {
			$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
			if ( is_array( $menus ) && ! empty( $menus ) ) {
				foreach ( $menus as $single_menu ) {
					if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
						$custom_menus[ $single_menu->name ] = $single_menu->term_id;
					}
				}
			}
		}
		return $custom_menus;
	}



add_action( 'vc_before_init', 'VC_custom_menu' );
function VC_custom_menu() {
   vc_map( array(
      "name" => __( "Custom-menu", "emerson" ),
      "base" => "custom_menu",
      "class" => "",
      "category" => __( "Insignia", "emerson"),
     	"class" => "font-awesome",
	"icon" => "fa fa-sort-numeric-asc",
'controls'    => 'full',
      "params" => array(
          


		
		array(
			'type'        => 'dropdown',
			'heading'     => esc_html__( 'Menu', 'emerson' ),
			'param_name'  => 'nav_menu',
			'value'       => array_flip( rt_get_menu() ),
			"description" => esc_html__( "select menu", "emerson" ),
			'save_always' => true,
			"group" => "General",

			),

               array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "group" => "General",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        ),

                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "param_name" => "ib_animation_delay",
                            "group" => "General",

                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                        ),



			
		 array(

            "type" => "textfield",
            "class" => "",
             
            "heading" => __( "Extra Class Name", "emerson" ),
            "param_name" => "extra_class",
            "group" => "General",
            "value" => __( "", "emerson" ),
             "description" => __( "Style particular content element differently - add a class name and refer to it in custom CSS.", "emerson" ),
            
         ),
	

  array(
            'type' => 'css_editor',
            'heading' => __( 'Css', 'citta' ),
            'param_name' => 'css',
            'group' => __( 'Design options', 'citta' ),
        )
       
       )
   ) );
}

add_shortcode( 'custom_menu', 'custom_menu_shortcode' );
function custom_menu_shortcode( $atts ) {


 extract( shortcode_atts( array(

       'extra_class'=>'',
       'css'=> '',

		'nav_menu' => '',
		'css_animation'  => '',
        'ib_animation_delay'=> ''

       
             
 ), $atts ) );

$extra_class1=${'extra_class'};
$css1=apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts );

//CSS Animation
            if ($css_animation == "no_animation") {
                $css_animation = "";
            }

 $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay;
            }

$args    = array(
	'theme_location'  => '',
	'menu'            => ${'nav_menu'},
	'container'       => '',
	'container_class' => '',
	'container_id'    => '',
	'menu_class'      => 'menu',
	'menu_id'         => '',
	'echo'            => false,
	'fallback_cb'     => 'wp_page_menu',
	'before'          => '',
	'after'           => '',
	'link_before'     => '',
	'link_after'      => '',
	'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
	'depth'           => 0,
	'walker'          => '',
);


			$output = '<div class="ins-custom-menu-wrapper '.$extra_class1.' '.$css1.' '.$css_animation.'" ".$animation_delay.">';
			   $output .= wp_nav_menu( $args );
			$output .= '</div>' . "\r";
			return $output;



}