<?php
/**
 *
 * google map VC element by INSIGNIA
 *
 */


add_action( 'vc_before_init', 'VC_ins_google_map' );

function VC_ins_google_map() {
 

	
	vc_map( array(
	"name" => __( "Google Map", "emerson" ),
    "base" => "insignia_google_map",
    "class" => "",
    "category" => __( "Insignia", "emerson"),
	"class" => "font-awesome",
	"icon" => "fa fa-map-o",    
	"params" => array(
	    
		array(
			"type" => "textfield",
			"class" => "hidden-label",
			"heading" => esc_html__( "Map Address", "emerson" ),
			"param_name" => "address",
			"value" => '',
			"description" => esc_html__( 'Enter the map address i.e. "Canal St, New York, NY 10013, USA". Or in lat,long format: 40.719175,-74.0015925', "emerson" ) 
		),
		array(
			"type" => "textfield",
			"class" => "hidden-label",
			"heading" => esc_html__( "Map Height", "emerson" ),
			"param_name" => "height",
			"value" => '550',
			"description" => esc_html__( "Height of the map element in pixels.", "emerson" ) 
		),
		array(
			"type" => "textfield",
			"class" => "hidden-label",
			"heading" => esc_html__( "Map Zoom", "emerson" ),
			"param_name" => "zoom",
			"value" => '14',
			"description" => esc_html__( "Choose the map zoom. Default value: 15", "emerson" ) 
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Map Style', "emerson" ),
			'admin_label' => true,
			'value' => array(
				esc_html__( 'Regular Colors', "emerson" ) => 'regular',
				esc_html__( 'Dark', "emerson" ) => 'dark',
				esc_html__( 'Light', "emerson" ) => 'light',
				esc_html__( 'Blue Essence', "emerson" ) => 'blue_essence',
				esc_html__( 'Water Blue', "emerson" ) => 'water_blue',
				esc_html__( 'Monochrome', "emerson" ) => 'monochrome'
			),
			'param_name' => 'map_style',
			'description' => esc_html__( 'Choose a style for your map.', "emerson" ) 
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Mouse scroll for zoom', "emerson" ),
			'value' => array(
				esc_html__( 'No', "emerson" ) => 'false',
				esc_html__( 'Yes', "emerson" ) => 'true' 
			),
			'param_name' => 'map_scroll',
			'description' => esc_html__( 'Choose a style for your map.', "emerson" ) 
		),
		
		
			 array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        ),

            array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "param_name" => "ib_animation_delay",
                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                        ),
	 

	array(
            "type" => "textfield",
            "class" => "",
             
            "heading" => __( "Extra Class Name", "emerson" ),
            "param_name" => "extra_class",
            "value" => __( "", "emerson" ),
             "description" => __( "Style particular content element differently - add a class name and refer to it in custom CSS.", "emerson" ),
            
         ),

		
		                        array(
            								"type"			=>	"dropdown",
            								"class"			=>	"",
            								"heading"		=>	esc_html__("Map info panel settings", "emerson"),
            								"param_name"	=>	"map_business_panel_settings",
                            "group"         => esc_html__("Business info", "emerson"),
            								"value"			=>	array(
                                esc_html__( "Hide business info panel", "emerson" ) => "hidden_info_panel",
            										esc_html__( "Left aligned", "emerson" )	=> "left_info_panel",
                                esc_html__( "Right aligned", "emerson" ) => "right_info_panel",
            									),
            								"save_always"	=>	true,
          							),

                        array(
                            "type"          => "textfield",
                            "class"         => "",
                            "heading"       => esc_html__("Panel title", "emerson"),
                            "param_name"    => "map_business_name",
                            "value"         => "",
                            "group"         => esc_html__("Business info", "emerson"),
                            "description"   => esc_html__("Enter panel title.", "emerson"),
                            "dependency" =>	array(
                                "element" => "map_business_panel_settings",
                                "value" => array("left_info_panel", "right_info_panel")
                            ),
                        ),

                        array(
                            "type"          => "textfield",
                            "class"         => "",
                            "heading"       => esc_html__("Address", "emerson"),
                            "param_name"    => "map_business_address",
                            "value"         => "",
                            "group"         => esc_html__("Business info", "emerson"),
                            "description"   => esc_html__("Enter business address.", "emerson"),
                            "dependency" =>	array(
                                "element" => "map_business_panel_settings",
                                "value" => array("left_info_panel", "right_info_panel")
                            ),
                        ),

                        array(
                            "type"          => "textfield",
                            "class"         => "",
                            "heading"       => esc_html__("Email", "emerson"),
                            "param_name"    => "map_business_email",
                            "value"         => "",
                            "group"         => esc_html__("Business info", "emerson"),
                            "description"   => esc_html__("Enter business email.", "emerson"),
                            "dependency" =>	array(
                                "element" => "map_business_panel_settings",
                                "value" => array("left_info_panel", "right_info_panel")
                            ),
                        ),

                        array(
                            "type"          => "textfield",
                            "class"         => "",
                            "heading"       => esc_html__("Phone", "emerson"),
                            "param_name"    => "map_business_phone",
                            "value"         => "",
                            "group"         => esc_html__("Business info", "emerson"),
                            "description"   => esc_html__("Enter business phone.", "emerson"),
                            "dependency" =>	array(
                                "element" => "map_business_panel_settings",
                                "value" => array("left_info_panel", "right_info_panel")
                            ),
                        ),

                        array(
                            "type"          => "textfield",
                            "class"         => "",
                            "heading"       => esc_html__("Opening hours title", "emerson"),
                            "param_name"    => "map_business_opening_hours",
                            "value"         => "",
                            "group"         => esc_html__("Business info", "emerson"),
                            "description"   => esc_html__("Enter opening hours title text.", "emerson"),
                            "dependency" =>	array(
                                "element" => "map_business_panel_settings",
                                "value" => array("left_info_panel", "right_info_panel")
                            ),
                        ),

                        array(
                            "type"          => "param_group",
                            "class"         => "",
                            "heading"       => esc_html__("Opening hours schedule", "emerson"),
                            "value" => urlencode( json_encode ( array(
																		array(
																			"map_schedule_day"       => "",
																			"map_schedule_day_info"  => "",
																		)
                            )	)	),
                            "param_name"    => "map_business_schedule",
                            "group"         => esc_html__("Business info", "emerson"),
                            "dependency" =>	array(
                                "element" => "map_business_panel_settings",
                                "value" => array("left_info_panel", "right_info_panel")
                            ),
                            "params" => array(
        												array(
          													"type" => "textfield",
          													"heading" => __("Day name","emerson"),
          													"param_name" => "map_schedule_day_name",
          													"description" => "",
          													"admin_label" => true,
        												),
        												array(
          													"type" => "textarea",
          													"heading" => __("Day opening/closing hours","emerson"),
          													"param_name" => "map_schedule_day_hours",
          													"value" => "",
          													"description" => "",
        												),
          								),

                        ),
		
		
	)  
	) );
	
}


 
 // Google Map Shortcode

function insignia_gmap( $atts, $content = null )
{
	extract( shortcode_atts( array(
		"height" => '550',
		"zoom" => '14',
		"label" => '',
		"fullscreen" => 'no',
		"lat" => '40.7179907',
		"long" => '-74.0001119',
		"map_style" => 'regular',
		"map_scroll" => 'false',
		"address" => 'Canal St, New York, NY 10013, USA',
		'map_business_panel_settings' => '',
        'map_business_name' => '',
        'map_business_address' => '',
        'map_business_email' => '',
        'map_business_phone' => '',
		'map_business_opening_hours' => '',
        'map_business_schedule' => '',
		'extra_class' => '',
		'css_animation'  => '',
        'ib_animation_delay'=> ''
	), $atts ) );
	
	$style_class = '';
	
	//CSS Animation
            if ($css_animation == "no_animation") {
                $css_animation = "";
            }

 $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay;
            }
	
	
	$rand_id = rand( 1, 9999 );
	
	wp_enqueue_script( 'google-map-sensor', '', '', '', true );
	
 if ( $lat != '' || $lon != '' ) {
	
		$result = explode( ",", $address );  // Split the string by commas
		$lat = trim( $result[0] );         // Clean whitespace
		$lon = trim( $result[1] );
        
		
		if ( (is_numeric( $lat ) ) && ( is_numeric( $lon ) ) ) {
			// Proper coordinates
		} else { // Regular text address
		
			$address_new = $address;
            $address_safe = esc_attr( str_replace( ' ', '', $address_new ) );
            
				$url = "https://maps.google.com/maps/api/geocode/json?address={$address_new}";
				$request = wp_remote_get( $url );
				$response = wp_remote_retrieve_body( $request );
				$response = json_decode( $response, true );
				
				if ( $response['status'] == 'OK' ) {
					$lati = $response['results'][0]['geometry']['location']['lat'];
					$longi = $response['results'][0]['geometry']['location']['lng'];
					$address = $lati . ',' . $longi;
                    
				} else {
					return '<div class="alert alert-warning">' . esc_html__( 'There was an error geocoding your address location. Please insert address in a lat,lng format.', 'emerson' ) . '</div>';
				}
	
			
			
		}
        		
		$map_center = $address;
		
	} else {
		if ( !$lat || !$long ) {
			return esc_html__( 'Error: no location lat and/or long data found', 'emerson' );
		}
	
		$map_center = $lat . ',' . $long;
	}


	ob_start();
	
	?>
	
	 <?php if (!empty(insignia_option('ins-opt-google-api'))) { ?>
	 
	<script type="text/javascript">
	
	jQuery(document).ready(function() {
	
		'use strict';
		
		<?php
		
		$style_class = '';
		
		if ( $map_style == "blue_essence" ) {
			$style_class = 'styles: [
    {
        "featureType": "landscape.natural",
        "elementType": "geometry.fill",
        "stylers": [
            {
                "visibility": "on"
            },
            {
                "color": "#e0efef"
            }
        ]
    },
    {
        "featureType": "poi",
        "elementType": "geometry.fill",
        "stylers": [
            {
                "visibility": "on"
            },
            {
                "hue": "#1900ff"
            },
            {
                "color": "#c0e8e8"
            }
        ]
    },
    {
        "featureType": "road",
        "elementType": "geometry",
        "stylers": [
            {
                "lightness": 100
            },
            {
                "visibility": "simplified"
            }
        ]
    },
    {
        "featureType": "road",
        "elementType": "labels",
        "stylers": [
            {
                "visibility": "off"
            }
        ]
    },
    {
        "featureType": "transit.line",
        "elementType": "geometry",
        "stylers": [
            {
                "visibility": "on"
            },
            {
                "lightness": 700
            }
        ]
    },
    {
        "featureType": "water",
        "elementType": "all",
        "stylers": [
            {
                "color": "#7dcdcd"
            }
        ]
    }
]';
		} elseif( $map_style == 'dark' ) { 
			$style_class = 'styles: [{"featureType":"all","elementType":"labels.text.fill","stylers":[{"saturation":36},{"color":"#000000"},{"lightness":40}]},{"featureType":"all","elementType":"labels.text.stroke","stylers":[{"visibility":"on"},{"color":"#000000"},{"lightness":16}]},{"featureType":"all","elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"administrative","elementType":"geometry.fill","stylers":[{"color":"#000000"},{"lightness":20}]},{"featureType":"administrative","elementType":"geometry.stroke","stylers":[{"color":"#000000"},{"lightness":17},{"weight":1.2}]},{"featureType":"landscape","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":20}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":21}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#000000"},{"lightness":17}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#000000"},{"lightness":29},{"weight":0.2}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":18}]},{"featureType":"road.local","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":16}]},{"featureType":"transit","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":19}]},{"featureType":"water","elementType":"geometry","stylers":[{"color":"#000000"},{"lightness":17}]}]';
		} elseif( $map_style == 'light' ) {
			$style_class = 'styles: [{"featureType":"water","elementType":"geometry","stylers":[{"color":"#e9e9e9"},{"lightness":17}]},{"featureType":"landscape","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":20}]},{"featureType":"road.highway","elementType":"geometry.fill","stylers":[{"color":"#ffffff"},{"lightness":17}]},{"featureType":"road.highway","elementType":"geometry.stroke","stylers":[{"color":"#ffffff"},{"lightness":29},{"weight":0.2}]},{"featureType":"road.arterial","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":18}]},{"featureType":"road.local","elementType":"geometry","stylers":[{"color":"#ffffff"},{"lightness":16}]},{"featureType":"poi","elementType":"geometry","stylers":[{"color":"#f5f5f5"},{"lightness":21}]},{"featureType":"poi.park","elementType":"geometry","stylers":[{"color":"#dedede"},{"lightness":21}]},{"elementType":"labels.text.stroke","stylers":[{"visibility":"on"},{"color":"#ffffff"},{"lightness":16}]},{"elementType":"labels.text.fill","stylers":[{"saturation":36},{"color":"#333333"},{"lightness":40}]},{"elementType":"labels.icon","stylers":[{"visibility":"off"}]},{"featureType":"transit","elementType":"geometry","stylers":[{"color":"#f2f2f2"},{"lightness":19}]},{"featureType":"administrative","elementType":"geometry.fill","stylers":[{"color":"#fefefe"},{"lightness":20}]},{"featureType":"administrative","elementType":"geometry.stroke","stylers":[{"color":"#fefefe"},{"lightness":17},{"weight":1.2}]}]';
		} elseif( $map_style == 'water_blue' ) {
			$style_class = 'styles: [
    {
        "featureType": "administrative",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "color": "#444444"
            }
        ]
    },
    {
        "featureType": "landscape",
        "elementType": "all",
        "stylers": [
            {
                "color": "#f2f2f2"
            }
        ]
    },
    {
        "featureType": "poi",
        "elementType": "all",
        "stylers": [
            {
                "visibility": "off"
            }
        ]
    },
    {
        "featureType": "road",
        "elementType": "all",
        "stylers": [
            {
                "saturation": -100
            },
            {
                "lightness": 45
            }
        ]
    },
    {
        "featureType": "road.highway",
        "elementType": "all",
        "stylers": [
            {
                "visibility": "simplified"
            }
        ]
    },
    {
        "featureType": "road.arterial",
        "elementType": "labels.icon",
        "stylers": [
            {
                "visibility": "off"
            }
        ]
    },
    {
        "featureType": "transit",
        "elementType": "all",
        "stylers": [
            {
                "visibility": "off"
            }
        ]
    },
    {
        "featureType": "water",
        "elementType": "all",
        "stylers": [
            {
                "color": "#46bcec"
            },
            {
                "visibility": "on"
            }
        ]
    }
]';
		} elseif( $map_style == 'monochrome' ) {
			$style_class = 'styles: [
    {
        "featureType": "administrative.locality",
        "elementType": "all",
        "stylers": [
            {
                "hue": "#2c2e33"
            },
            {
                "saturation": 7
            },
            {
                "lightness": 19
            },
            {
                "visibility": "on"
            }
        ]
    },
    {
        "featureType": "landscape",
        "elementType": "all",
        "stylers": [
            {
                "hue": "#ffffff"
            },
            {
                "saturation": -100
            },
            {
                "lightness": 100
            },
            {
                "visibility": "simplified"
            }
        ]
    },
    {
        "featureType": "poi",
        "elementType": "all",
        "stylers": [
            {
                "hue": "#ffffff"
            },
            {
                "saturation": -100
            },
            {
                "lightness": 100
            },
            {
                "visibility": "off"
            }
        ]
    },
    {
        "featureType": "road",
        "elementType": "geometry",
        "stylers": [
            {
                "hue": "#bbc0c4"
            },
            {
                "saturation": -93
            },
            {
                "lightness": 31
            },
            {
                "visibility": "simplified"
            }
        ]
    },
    {
        "featureType": "road",
        "elementType": "labels",
        "stylers": [
            {
                "hue": "#bbc0c4"
            },
            {
                "saturation": -93
            },
            {
                "lightness": 31
            },
            {
                "visibility": "on"
            }
        ]
    },
    {
        "featureType": "road.arterial",
        "elementType": "labels",
        "stylers": [
            {
                "hue": "#bbc0c4"
            },
            {
                "saturation": -93
            },
            {
                "lightness": -2
            },
            {
                "visibility": "simplified"
            }
        ]
    },
    {
        "featureType": "road.local",
        "elementType": "geometry",
        "stylers": [
            {
                "hue": "#e9ebed"
            },
            {
                "saturation": -90
            },
            {
                "lightness": -8
            },
            {
                "visibility": "simplified"
            }
        ]
    },
    {
        "featureType": "transit",
        "elementType": "all",
        "stylers": [
            {
                "hue": "#e9ebed"
            },
            {
                "saturation": 10
            },
            {
                "lightness": 69
            },
            {
                "visibility": "on"
            }
        ]
    },
    {
        "featureType": "water",
        "elementType": "all",
        "stylers": [
            {
                "hue": "#e9ebed"
            },
            {
                "saturation": -78
            },
            {
                "lightness": 67
            },
            {
                "visibility": "simplified"
            }
        ]
    }
]';
		}
	
		?>
		
		// Map Coordination
		
		var latlng = new google.maps.LatLng(<?php echo esc_attr( $map_center ); ?>);
		
		// Map Options

		var myOptions = {
			zoom: <?php echo esc_attr( $zoom ); ?>,
			center: latlng,
			mapTypeId: google.maps.MapTypeId.ROADMAP,
			disableDefaultUI: false,
			mapTypeControl: false,
			scrollwheel: <?php echo esc_attr( $map_scroll ); ?>,
			<?php if ( $style_class ) echo $style_class; ?>
		};

		var map = new google.maps.Map( document.getElementById('google-map-<?php echo $rand_id; ?>' ), myOptions);
        var marker = new google.maps.Marker({
          position: latlng,
          map: map
        });

	});
	
	</script>
	
	<div class="insignia-gmap map-skin-<?php echo esc_attr( $map_style ); ?> <?php echo $map_business_panel_settings;?> <?php echo $extra_class; ?> <?php echo $css_animation; ?>" <?php echo $animation_delay; ?>>	
	<?php
	
	$height = str_replace( 'px', '', $height );
	
	if ( is_null( $height ) ) $height = 550;
	
	
	
	if ($map_business_panel_settings != "hidden_info_panel") { ?>
<div class="business-info-wrapper">
                        <div class="business-info-header">
                         <?php   if ($map_business_name != '') { ?>
                               <h4><?php echo $map_business_name; ?></h4>
                          <?php  } ?>
                           <address>
                          <?php    if ($map_business_address != '') { ?>
                                <span class="business-address-row">Address: <span class="address-overflow"><?php echo $map_business_address; ?></span></span>
                              <?php }
                              if ($map_business_phone != '') { ?>
								<span class="business-phone-row">Phone: <a href="tel:<?php echo $map_business_phone; ?>"><?php echo $map_business_phone; ?></a></span>
                             <?php } 
                              if ($map_business_email != '') { ?>
                                 <span class="business-email-row">Email: <a href="mailto:<?php echo $map_business_email; ?>"><?php echo $map_business_email; ?></a></span>
                             <?php } ?>
                           </address>
                        </div>
                        <div class="business-info-schedule">
                            <h4><?php echo $map_business_opening_hours; ?> </h4>
                            <?php $map_business_schedule = json_decode( urldecode( $map_business_schedule ), true );

                            if( isset( $map_business_schedule ) ) {
                      				foreach ( $map_business_schedule as $business_data ){ ?>
                      					<div class="business-info-day">
                                  <?php if ( isset( $business_data["map_schedule_day_name"] ) ){ ?>
                                    <span class="business-info-day-name"> <?php echo $business_data["map_schedule_day_name"]; ?>: </span>
                                <?php  } 
                                  if ( isset( $business_data["map_schedule_day_hours"] ) ){ ?>
                                  <span class="business-info-day-hours"> <?php echo $business_data["map_schedule_day_hours"]; ?></span>
                                <?php  } ?>
                      			
								</div>
								
								
                      			 <?php	}
                      			} ?>

                       </div>
                    </div>
           <?php  } ?>

	<div id="google-map-<?php echo $rand_id; ?>" style="height:<?php echo esc_attr( $height ); ?>px;"></div>
	    
	</div>

	<?php
	
	
	
	$content = ob_get_contents();
	ob_end_clean();
	
	return $content;
	 }else{
	 echo "<div class='alert alert-warning'>Create your Google Map <a href='https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key' target='_blank'>API KEY</a> and Paste it <a href=' ".admin_url('admin.php?page=Emerson&tab=1')."' target='_blank'>here</a> . This is necessary for the Google Map to work on your website.</div>";
 }	
}
remove_shortcode( 'insignia_google_map' );
add_shortcode( 'insignia_google_map', 'insignia_gmap' );