<?php
/*Testimonial Element*/

add_action( 'vc_before_init', 'your_name_integrateWithVC' );
function your_name_integrateWithVC() {

  
	vc_map( array(
	"name" => __( "Testimonials", "emerson" ),
	"base" => "testimonial",
	"class" => "",
	'icon' => 'my_bartag',
	"category" => __( "Insignia", "emerson"),
	"class" => "font-awesome",
	"icon" => "fa fa-quote-right",
     
	"params" => array(
        array(
		"type" => "dropdown",
		"class" => "",
		"heading" => __( "Select Testimonial Layout", "ensign" ),
		"param_name" => "testimonial_layout",
		"value"       => array(
		'Layout 1'   => 'style-1',
		'Layout 2'   => 'style-2',
		),
		"std"         => 'Layout 1',
		),

		array(
		"type" => "checkbox",
		"class" => "",
		"value" => ensign_taxonomies_array( 'testimonial_category' ),
		"heading" => esc_html__( "Testimonial Categories", "emerson" ),
		"param_name" => "cats",
		"admin_label" => true,
		"description" => esc_html__( "Select testimonial categories to be displayed. Leave blank for all.", "emerson" ) 
		),
		array(	      
		"type" => "textfield",
		"class" => "hidden-label",
		"heading" => esc_html__( "Number of posts to show", 'citta' ),
		"param_name" => "posts_nr",
		"value" => "8"
		),

                array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        ),

                 array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "param_name" => "ib_animation_delay",
                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                        ),


		array(
		"type" => "textfield",
		"class" => "",

		"heading" => __( "Extra Class Name", "emerson" ),
		"param_name" => "extra_class",
		"value" => __( "", "emerson" ),
		  "description" => __( "Style particular content element differently - add a class name and refer to it in custom CSS.", "emerson" )

		),

		array(
		"type" => "dropdown",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Autoplay", "emerson" ),
		"param_name" => "autoplay",
		"group" => "Carousel setting",
		"value"       => array(

		'True'   => 'true',
		'False'   => 'false'

		),
		"std"         => 'True',

		"description" => __( "Enable/Disable Autoplay.", "emerson" )

		),
		array(
		"type" => "textfield",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Speed", "emerson" ),
		"param_name" => "speed",
		"group" => "Carousel setting",
		"value" => __( "3000", "emerson" ),

		"description" => __( "Choose speed for carousel transition in milliseconds (Example:300).", "emerson" )

		),
		array(
		"type" => "dropdown",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => esc_html__( "Columns", 'citta' ),
		"param_name" => "slidetoshow",
		"value" => array("Select Number of Columns", "4", "3", "2", "1" ),
		"group" => "Carousel setting",
		"description" => esc_html__( "Number of columns", 'citta' ),
		),

		array(
		"type" => "dropdown",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Dots", "emerson" ),
		"param_name" => "testimonial_navigation_dots",
		"group" => "Carousel setting",
		"value"       => array(

		'True'   => 'true',
		'False'   => 'false'

		),
		"std"         => '',
		"description" => __( "Dots for navigation.", "emerson" )

		),
		

		array(
		"type" => "dropdown",
		"description" => esc_html__( "Sort/order your posts by a certain value.", 'citta' ),
		"class" => "hidden-label",
		"heading" => esc_html__( "Order posts by", "emerson" ),
		"param_name" => "orderby",
		"value" => array(
			esc_html__( "Date", 'citta' ) => "date",
			esc_html__( "None - no order", 'citta' ) => "none",
			esc_html__( "Post ID", 'citta' ) => "ID",
			esc_html__( "Author", 'citta' ) => "author",
			esc_html__( "Title", 'citta' ) => "title",
			esc_html__( "Name (slug)", 'citta' ) => "name",
			esc_html__( "Menu Order", 'citta' ) => "menu_order" 
		),
		"group" => esc_html__( "Order Settings", "emerson" ) 
		),
		array(
			"type" => "dropdown",
			"description" => esc_html__( "Posts order.", 'citta' ),
			"class" => "hidden-label",
			"heading" => esc_html__( "Posts order", "emerson" ),
			"param_name" => "order",
			"value" => array(
				esc_html__( "Descending (DESC)", 'citta' ) => "DESC",
				esc_html__( "Ascending (ASC)", 'citta' ) => "ASC" 
			),
			"group" => esc_html__( "Order Settings", "emerson" ) 
		),

		array(
		"type" => "colorpicker",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Testimonial Font Color", "emerson" ),
		"param_name" => "font_color",
		"group" => "Style",
		"value" => __( "", "emerson" ),
		  "description" => __( " Choose Testimonial Font Color.If you leave it empty, It will set theme color", "emerson" )
			

		 ),
		 
		array(
		"type" => "colorpicker",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Heading Font Color", "emerson" ),
		"param_name" => "heading_font_color",
		"group" => "Style",
		"value" => __( "", "emerson" ),
		"description" => __( " Choose Heading Font Color.If you leave it empty, It will set theme color", "emerson" )
		
		 ),

		 
		array(
		"type" => "colorpicker",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Title Font Color", "emerson" ),
		"param_name" => "title_font_color",
		"group" => "Style",
		"value" => __( "", "emerson" ),
		  "description" => __( " Choose Title Font Color.If you leave it empty, It will set theme color", "emerson" )
			

		 ),


		array(
		"type" => "colorpicker",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Designation Font Color", "emerson" ),
		"param_name" => "position_font_color",
		"group" => "Style",
		"value" => __( "", "emerson" ),
		  "description" => __( " Choose Designation Font Color.If you leave it empty, It will set theme color", "emerson" )
		 ),
		array(
		"type" => "colorpicker",
		"class" => "",
		"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
		"heading" => __( "Content Background Color", "emerson" ),
		"param_name" => "test_bg_color",
		"group" => "Style",
		"value" => __( "", "emerson" ),
		"description" => __( " Choose Background Color.If you leave it empty, It will set default color", "emerson" ),
		 ),
		 
		array(
			"type" => "textfield",
			"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
			"heading" => esc_html__( "Heading Font-size", "emerson" ),
			"param_name" => "heading_size",
			"group" => "Style",
			"description" => esc_html__( "Enter Heading font-size. Example:20", "emerson" ),
			"value" => "",
		),
		
		array(
			"type" => "textfield",
			"edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
			"heading" => esc_html__( "Heading Line-height", "emerson" ),
			"param_name" => "heading_line_height",
			"group" => "Style",
			"description" => esc_html__( "Enter Heading line-height. Example:20", "emerson" ),
			"value" => "",
		),
		 
		    array(
            "type" => "dropdown",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
             "heading" => __( "Testimonial Text Font Size", "emerson" ),
            "param_name" => "text_font",
            "group" => "Style",
              "description" => __( "Select text font size.", "emerson" ),
             "value"       => array(
       
       'Select' => '',
        'Extra Small'   => 'text-extra-small',
        'Small'   => 'text-small',
        'Medium'   => 'text-medium',        
        'Large'   => 'text-large',
        'Extra Large'   => 'text-extra-large'

         
         ),
               "std"         => '',

         ),

		array(
			'type' => 'css_editor',
			'heading' => __( 'Css', 'citta' ),
			'param_name' => 'css',
			'group' => __( 'Design options', 'citta' ),
		),



		)
	) );
}

add_shortcode( 'testimonial', 'bartag_func' );
function bartag_func( $atts ) {
		extract( shortcode_atts( array(
		'testimonial_layout' => '',
		'testimonial_navigation_dots' => 'true',
		'slidetoshow' => '4',
		'speed' => '1000',
		'autoplay' => '',
		'extra_class' =>'',
		'font_color'=>'#6f6f6f',
		'title_font_color'=>'#232323',
		'cats' =>'',
		'posts_nr' => '',
		'orderby' => '',
		'order' => '',
		'position_font_color'=>'#6f6f6f',
		 'css' => '',
		'test_bg_color'=>'',
		 'text_font' => '',
        'css_animation'  => '',
        'ib_animation_delay'=> '',
        'heading_font_color' => '#232323',
        'heading_size' => '',
        'heading_line_height' => ''
   ), $atts ) );
global $post;   



$css=apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts );    


//CSS Animation
            if ($css_animation == "no_animation") {
                $css_animation = "";
            }

 $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay;
		}

if(!isset($extra_class1))
    $extra_class1='';
$uniqid = uniqid('ins-testimonial-');
$custom_css = '';

if($test_bg_color != '')
$custom_css .= '#' . $uniqid . ' .insignia-testimonial-style-3-content:after {border-top-color: '.$test_bg_color.';}';
	// Output
	
	ob_start();		
	
	echo '<div id="'.$uniqid.'" class="insignia-testimonial-wrapper insignia-testimonial-style-1 clearfix '.$css.'">';
			
	echo '<div class="insignia-testimonial-inner insignia-testimonial-carousel">';
	
	wp_reset_postdata();
	
	// The query
	
	$args = array(
		'posts_per_page' => $posts_nr,
		'testimonial_category' => $cats,
		'post_type' => 'testimonial_post',
		'orderby' => $orderby,
		'order' => $order 
	);
	
	$the_query = new WP_Query( $args );
	
	// The Loop
	
	if ( $the_query->have_posts() ) : while ( $the_query->have_posts() ): $the_query->the_post(); 
	$test_author = get_post_meta($post->ID, "_ins_author", true);
	$test_position = get_post_meta($post->ID, "_ins_position", true);
	$test_heading = get_post_meta($post->ID, "_ins_heading", true);
	$testimonial_img_src = get_the_post_thumbnail( $post->ID, array( 300, 300), array( 'class' => 'border-radius-50') );
	$post_id = get_the_ID();
	
	?>
<?php if($testimonial_layout == 'style-1'){ ?>
		<div class="insignia-testimonial-content-wrapper <?php echo $css_animation; ?>" <?php echo $animation_delay; ?>>
		 <div class="insignia-testimonial-bg-inner" style= "background-color:<?php echo $test_bg_color; ?>">
		     <div class="insignia-testimonial-meta-wrapper testimonial-left-section clearfix"> 
			<?php if(!empty($testimonial_img_src)){ ?>
				<div class="insignia-testimonial-image"><?php echo $testimonial_img_src; ?></div> <?php } ?>
				<div class="insignia-testimonial-meta"> 
				<?php if(!empty($test_author)){ ?>
				<div class="insignia-testimonial-title margin-0px-bottom title-font font-weight-500 text-medium text-extra-dark-gray line-height-16" style= 'color: <?php echo $title_font_color; ?>'><?php echo $test_author; ?></div> <?php } ?>
				<?php if(!empty($test_position)){ ?>
				<span class="insignia-testimonial-position text-uppercase text-small" style= 'color: <?php echo $position_font_color; ?>'><?php echo $test_position; ?></span><?php } ?></div>
			</div>
			<div class="testimonial-right-section">
			    <?php if(!empty($test_heading)){ ?>
				<h5 class="insignia-testimonial-heading" style= ' <?php if(!empty($heading_font_color)){ ?>color: <?php echo $heading_font_color; ?>;<?php } ?><?php if(!empty($heading_size)){ ?> font-size: <?php echo $heading_size;?>px;<?php } ?><?php if(!empty($heading_line_height)){ ?>line-height: <?php echo $heading_line_height;?>px;<?php } ?>'><?php echo $test_heading; ?></h5> <?php } ?>
            <div style= 'color: <?php echo $font_color; ?>' class="insignia-testimonial-text <?php echo $text_font; ?>"><?php echo get_the_content(); ?></div>
			</div>
		</div>
	</div>	
<?php }elseif($testimonial_layout == 'style-2') { ?>
	
		<div class="insignia-testimonial-content-wrapper insignia-testimonial-layout-2-wrapper <?php echo $css_animation; ?>" <?php echo $animation_delay; ?>>
		 <div class="insignia-testimonial-bg-inner insignia-testimonial-layout-2-inner" style= "background-color:<?php echo $test_bg_color; ?>">
		    <div class="testimonial-2-upper-section">
			    <?php if(!empty($test_heading)){ ?>
				<h5 class="insignia-testimonial-2-heading margin-20px-bottom line-height-28" style= ' <?php if(!empty($heading_font_color)){ ?>color: <?php echo $heading_font_color; ?>;<?php } ?><?php if(!empty($heading_size)){ ?> font-size: <?php echo $heading_size;?>px;<?php } ?><?php if(!empty($heading_line_height)){ ?>line-height: <?php echo $heading_line_height;?>px;<?php } ?>'><?php echo $test_heading; ?></h5> <?php } ?>
            <div style= 'color: <?php echo $font_color; ?>' class="insignia-testimonial-2-text <?php echo $text_font; ?>"><?php echo get_the_content(); ?></div>
			</div>
		     <div class="insignia-testimonial-2-meta-wrapper clearfix"> 
			<?php if(!empty($testimonial_img_src)){ ?>
				<div class="insignia-testimonial-2-image float-left"><?php echo $testimonial_img_src; ?></div> <?php } ?>
				<div class="insignia-testimonial-2-meta"> 
				<?php if(!empty($test_author)){ ?>
				<div class="insignia-testimonial-2-title margin-0px-bottom title-font font-weight-500 text-medium text-extra-dark-gray line-height-16" style= 'color: <?php echo $title_font_color; ?>'><?php echo $test_author; ?></div> <?php } ?>
				<?php if(!empty($test_position)){ ?>
				<span class="insignia-testimonial-2-position text-uppercase text-small" style= 'color: <?php echo $position_font_color; ?>'><?php echo $test_position; ?></span><?php } ?></div>
			    <div class="testimonial-quote-icon">
				    <span class="fa fa-quote-right pc"></span>
				</div>
			</div>

		</div>
	</div>	
	

<?php } ?>	
<?php
	endwhile; 
	
	else :
	
		echo '<div class="insignia-no-posts alert alert-warning"><p>Looks like you don\'t have any testimonial posts created. You may add new <a href="' . admin_url( 'edit.php?post_type=testimonial_post' ) . '" target="_blank">here</a>.</p></div>';
	
	endif; // End The Loop

			
	echo '</div></div>'; ?>
	
			 <script type="text/javascript">
                      

jQuery('#<?php echo $uniqid;?> .insignia-testimonial-carousel').slick({
    
    dots: <?php echo esc_html($testimonial_navigation_dots); ?>,
    arrows: false,
    slidesToShow: <?php echo esc_html($slidetoshow); ?>,
	swipeToSlide: true,
    responsive: [
    {
      breakpoint: 1024,
      settings: {
        slidesToShow: 2
      }
    },
    {
      breakpoint: 600,
      settings: {
        slidesToShow: 1
      }
    },
    {
      breakpoint: 480,
      settings: {
        slidesToShow: 1
      }
    }
   
  ]

  });
						</script>
						
						
<script type="text/javascript">
		(function(jQuery) {

	<?php 	if($custom_css != '') { ?>
				 jQuery("head").append("<style><?php echo $custom_css ?></style>");
					<?php } ?>
 
					})(jQuery);
						</script>
	
<?php	
	$content = ob_get_contents();
	ob_end_clean();
	
	return $content;

}
