<?php 
/**
 * The main template file.
 *
 * @package Insignia Agency
 * @author insignia Technolabs
 * @link http://insigniatechnolabs.com/
 */

/**
*
* Load Theme Options
*
**/



//wp_schedule_event(time(), 'daily', 'my_hourly_event');
//add_action('init','my_hourly_event');
function my_hourly_event() {
//$args = array('numberposts' => -1,'post_status'  => 'any');
//      $the_query = get_posts($args);



$qthe_query = get_posts();//print_r($qthe_query);exit;
        foreach($qthe_query as $single_post) {
                $id=$single_post->ID;
                $ad_close_date=get_post_meta($id, 'expiration', true );
                if($ad_close_date!=''){
$ad_close_date = strtotime($ad_close_date);//echo $ad_close_date;
                        $today = strtotime(date("d-m-Y"));//echo  $today;
                        $post_status = get_post_status( $id );
                        if($ad_close_date<$today){
                                $update_post = array(
                                'ID'                    => $id,
                                'post_status'   =>      'pending',
                                //'post_type'   =>      'job' 
                                );
                                wp_update_post($update_post);
                        } else if($post_status == 'pending'){
                                $update_post = array(
                 'ID'                    => $id,
                 'post_status'   =>      'publish',
                 //'post_type'   =>      'job' 
                 );
                wp_update_post($update_post);
                        }
                }
        }
}









if ( !isset( $ins_opt ) && file_exists( get_template_directory() . '/insigniathemeoptions/insigniacustomoptions/insignia-config.php' ) ) {
	require_once( get_template_directory() . '/insigniathemeoptions/insigniacustomoptions/insignia-config.php' );
}

if( class_exists('ReduxFrameworkPlugin')){
	Redux::init( 'ins_opt' );
}

	/***
	*Insignia Theme Support
	*
	* @since       1.0
	***/

	add_action( 'after_setup_theme', 'insignia_theme_support' );
	function insignia_theme_support() {
		
		load_theme_textdomain( 'innvoke', get_template_directory() . '/languages' );
		add_theme_support( 'post-formats', array( 'gallery', 'video', 'audio', 'quote' ) );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );

		// WooCommerce

		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );

		global $wp_version;

		if ( version_compare( $wp_version, '3.4', '>=' ) ) {
			add_theme_support( "custom-header");
			add_theme_support( "custom-background");
		}
	}
		
		
	/**
	* For Contant Width
	*
	* @since       1.0
	**/
	if ( ! isset( $content_width ) ) {
		global $content_width;
		$content_width = 1170;
	}


	/**
	*
	* Load css & Script
	*
	**/ 



	add_action( 'admin_enqueue_scripts', 'insignia_load_custom_wp_admin_style' );
	function insignia_load_custom_wp_admin_style() {
		wp_register_style( 'innvoke-admin-style', get_template_directory_uri() . '/assets/css/admin-style.css', false, '1.0.0' );
		wp_enqueue_style( 'innvoke-admin-style' );
		wp_enqueue_style( 'innvoke-insignia-icons' );
		wp_enqueue_style( 'iconsmind' );
		wp_localize_script( 'ajax-load-post-script', 'ajax_posts', array(
			'ajax_url' => esc_url(admin_url('admin-ajax.php')),
			'noposts' => esc_html__('No older posts found', 'innvoke'),
		));
	}


	/***
	*Comment's Replay Script 
	*
	*@since       1.0
	***/

	function insignia_enqueue_comments_reply() {
		wp_enqueue_script( 'comment-reply' );
	}
	add_action( 'comment_form_before', 'insignia_enqueue_comments_reply' );


	function insignia_get_meta($value,$post) {
		$field = get_post_meta( $post, $value, 1);
		if ( ! empty( $field ) ) {
			return is_array( $field ) ? stripslashes_deep( $field ) : stripslashes( wp_kses_decode_entities( $field ) );
		} else {
			return false;
		}
	}
	
	
	function insignia_basic_enqueue_scripts(){
		/** CSS **/
		wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), '3.3.6');
		wp_enqueue_style('innvoke-element', get_template_directory_uri() . '/assets/css/element.css'); 
		wp_enqueue_style('font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css','4.5.0');
		wp_enqueue_style( 'innvoke-insignia-icons' );
		wp_enqueue_style( 'iconsmind' );
		wp_enqueue_style('innvoke-style', get_template_directory_uri() . '/style.css');
		wp_enqueue_style('innvoke-navigation', get_template_directory_uri() . '/assets/css/navigation.css');
		wp_enqueue_style('animate-css', get_template_directory_uri() . '/assets/css/animate.min.css');
		wp_enqueue_style('innvoke-innvoke-css', get_template_directory_uri() . '/assets/css/innvoke-css.css');


		/** JS **/
		wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.js', array(), true,true);
		wp_enqueue_script('slick', get_template_directory_uri() . '/assets/js/slick.js', array('jquery'), false,false);

		$api_key = '';

		if (insignia_option('ins-opt-google-api') ) {
			$api_key = esc_attr( insignia_option('ins-opt-google-api') );
			wp_register_script( 'google-map-sensor', '//maps.google.com/maps/api/js?key=' . $api_key , array( 'jquery' ) );
			wp_register_script( 'google-map-label', get_template_directory_uri() . '/js/plugins/map/markerwithlabel.js', array( 'google-map-sensor' ) );
		}
	}
              
	function insignia_add_footer_styles() {
		wp_enqueue_style('slick', get_template_directory_uri() . '/assets/css/slick.css');
		wp_enqueue_style('swipebox', get_template_directory_uri() . '/assets/css/swipebox.min.css');  
		wp_enqueue_script('waypoints', get_template_directory_uri() . '/assets/js/waypoints.min.js', array('jquery'), false,false);
		wp_enqueue_script('isotope-pkgd', get_template_directory_uri() . '/assets/js/isotope.pkgd.js', array('jquery'));
		wp_enqueue_script('masonry-horizontal', get_template_directory_uri() . '/assets/js/masonry-horizontal.js', array('jquery'), false,true);
		wp_enqueue_script( 'imagesloaded' );
		wp_enqueue_script('counterup', get_template_directory_uri() . '/assets/js/jquery.counterup.min.js', array('jquery'), false,false);
		wp_enqueue_script('innvoke-innvoke-js', get_template_directory_uri() . '/assets/js/innvoke-js.js', array('jquery'), false,true); 

		if ( insignia_option( 'page_type' ) == 'one_pager'  ) {
			wp_enqueue_script('PageScroll2id', get_template_directory_uri() . '/assets/js/jquery.malihu.PageScroll2id.js', array('jquery'), false,true);
		}

		wp_enqueue_script('swipebox', get_template_directory_uri() . '/assets/js/jquery.swipebox.js', array('jquery'), false, false); 
		wp_enqueue_script( 'superfish', get_template_directory_uri() . '/assets/js/superfish.min.js', array( 'jquery' ), null,true);
		wp_enqueue_script( 'innvoke-insignia-navigation', get_template_directory_uri() . '/assets/js/insignia-navigation.js', array( 'jquery', 'superfish' ), true);
	}


	function insignia_custom_enqueue_scripts(){
		if ( class_exists('ReduxFrameworkPlugin') ) {
			ob_start();
			get_template_part( '/assets/css/default-dynamic-css' );
			$output = ob_get_contents();
			ob_end_clean();
			wp_add_inline_style( 'innvoke-style', $output); 
		} 
	}

	add_action('wp_enqueue_scripts', 'insignia_basic_enqueue_scripts');
	add_action( 'get_footer', 'insignia_add_footer_styles' );
	add_action('wp_enqueue_scripts', 'insignia_custom_enqueue_scripts');

	/**
	*
	* Insignia Theme plugin Activator
	*
	**/

	require_once( get_template_directory() .'/functions/plugins/insignia_plugin.php' );


	/* ------------------------------------------------------------------------ */
	/* Pagination
	/* ------------------------------------------------------------------------ */
	function insignia_pagination($pages = '') {
		
		 global $paged;	
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
		 if($pages == ''){
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if(!$pages){
				$pages = 1;
			}
		} 
		 
		if(1 != $pages){
			/**	Add current page to the array */
			if ( $paged >= 1 )
				$links[] = $paged;

			/**	Add the pages around the current page to the array */
			if ( $paged >= 3 ){
				$links[] = $paged - 1;
				$links[] = $paged - 2;
			}

			if ( ( $paged + 2 ) <= $pages ){
				$links[] = $paged + 2;
				$links[] = $paged + 1;
			}

			echo '<div id="pagination" class="clearfix"><ul>' . "\n";

			/**	Previous Post Link */
			if ( get_previous_posts_link() )
				printf( '<li class="pagination-prev">%s</li>' . "\n", get_previous_posts_link('<i class="fa fa-chevron-left"></i>') );

			/**	Link to first page, plus ellipses if necessary */
			if ( ! in_array( 1, $links ) ) {
				$class = 1 == $paged ? ' class="current"' : '';

				printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( 1 ) ), '1' );

				if ( ! in_array( 2, $links ) )
					echo '<li><span>...</span></li>';
			}

			/**	Link to current page, plus 2 pages in either direction if necessary */
			sort( $links );
			foreach ( (array) $links as $link ) {
				$class = $paged == $link ? ' class="current"' : '';
				printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $link ) ), $link );
			}

			/**	Link to last page, plus ellipses if necessary */
			if ( ! in_array( $pages, $links ) ) {
				if ( ! in_array( $pages - 1, $links ) )
					echo '<li><span>...</span></li>' . "\n";

				$class = $paged == $pages ? ' class="current"' : '';
				printf( '<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url( get_pagenum_link( $pages ) ), $pages );
			}

			/**	Next Post Link */
			if ( get_next_posts_link() )
				printf( '<li class="pagination-next">%s</li>' . "\n", get_next_posts_link('<i class="fa fa-chevron-right"></i>') );
			echo '</ul></div>' . "\n";
		}
	}
	
	function insignia_get_post_page_url() {
		if( 'page' == get_option( 'show_on_front' ) ) {
			return get_permalink( get_option('page_for_posts' ) );
		} else {
			return home_url();
		} 
	}

	/**
	 * register_sidebars - Register sidebars.
	 *
	 * @since       1.0
	 */
	function insignia_widgets_init() {

		register_sidebar( array(
			'name' => esc_html__( 'Default Sidebar', 'innvoke' ),
			'id' => 'default_sidebar',
			'description' => esc_html__( 'Default Theme sidebar', 'innvoke' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );

		register_sidebar( array(
			'name' => esc_html__( 'Page Sidebar', 'innvoke' ),
			'id' => 'page_sidebar',
			'description' => esc_html__( 'The page sidebar appears on each page', 'innvoke' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );

		register_sidebar( array(
			'name' =>esc_html__( 'Shop sidebar', 'innvoke'),
			'id' => 'shop_sidebar',
			'description' => esc_html__( 'Appears on the woocommerce pages.', 'innvoke' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );

		register_sidebar( array(
			'name' =>esc_html__( 'Portfolio sidebar', 'innvoke'),
			'id' => 'portfolio_sidebar',
			'description' => esc_html__( 'Appears on the Portfolio pages.', 'innvoke' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );
			
		register_sidebar( array(
			'name' =>esc_html__( 'Side Menu', 'innvoke'),
			'id' => 'sidebar-5',
			'description' => esc_html__( 'Appears in the header menu', 'innvoke' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );
			
		register_sidebar( array(
			'name' =>esc_html__( 'Footer column 1', 'innvoke'),
			'id' => 'sidebar-footer-col1',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );
			
		register_sidebar( array(
			'name' =>esc_html__( 'Footer column 2', 'innvoke'),
			'id' => 'sidebar-footer-col2',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );
			
		register_sidebar( array(
			'name' =>esc_html__( 'Footer column 3', 'innvoke'),
			'id' => 'sidebar-footer-col3',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );
			
		register_sidebar( array(
			'name' =>esc_html__( 'Footer column 4', 'innvoke'),
			'id' => 'sidebar-footer-col4',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<h5 class="widget-title">',
			'after_title' => '</h5>',
			) );
	}

	add_action( 'widgets_init', 'insignia_widgets_init' );

	function insignia_my_search_form( $form ) {
		$form = '<form role="search" method="get" id="searchform" class="searchform" action="' .  esc_url(home_url())  . '" >
		<div>
		<input type="text" placeholder="'. esc_attr__( 'Search', 'innvoke' ) .'" value="' . get_search_query() . '" name="s" id="s" class="ins_search_input" />
		<button type="submit" class="ins_submit_btn" id="searchsubmit" value="'. esc_attr__( 'Search','innvoke' ) .'" ><i class="fa fa-search" aria-hidden="true"></i></button>
		</div>
		</form>';
		return $form;
	}
	add_filter( 'get_search_form', 'insignia_my_search_form', 100 );


	// ensure is_plugin_active() exists (not on frontend)
	if( !function_exists('is_plugin_active') ) {
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	}

	require_once( get_template_directory() .'/functions/general-functions.php' );
	require_once( get_template_directory() .'/functions/header-functions.php' );
	require_once( get_template_directory() .'/functions/woocommerce_configuration.php' );
	require_once( get_template_directory() .'/functions/ins-comments.php' );
	require_once( get_template_directory() .'/demo-importer.php' );
	require_once( get_template_directory() .'/functions/breadcrumbs.php' );
	

	// 
	// Custom Menus
	//

	class insignia_Custom_Menu_Class extends Walker_Nav_Menu {

	function start_lvl(&$output, $depth = 0, $args = array()) {
			$indent = str_repeat("\t", $depth);
			$output .= "\n$indent<ul class=\"sub-menu\">\n";
	}
		
	function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
		global $wp_query;
		
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		$class_names = $value = '';
		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
		$mega_menu_class = '';
		if( $depth == 0 && get_post_meta( $item->ID, '_menu_item_insignia_mega_menu', true ) == 'checked' && strpos( $class_names, 'mega_menu' ) === false ) {
			$mega_menu_class = 'mega-menu ';
		}

		$class_names = ' class="' . $mega_menu_class . esc_attr( $class_names ) . '"'; 
		$output .= $indent . '<li ' . $value . $class_names .'>';
		$attributes = ! empty( $item->attr_title ) ? ' title="' . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) .'"' : '';
		$attributes .= ! empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) .'"' : '';
		$attributes .= ! empty( $item->url ) ? ' href="' . esc_attr( $item->url ) .'"' : '';
		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'><span>';
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		
		if( $item->description && insignia_header_style() == 'classic-subtitles' ) {
			$item_output .= '<span class="sub">' . $item->description . '</span>';
		}
		
		$item_output .= '</span></a>';
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
		}
	}

	function insignia_reduxdemo() {
		if ( class_exists('ReduxFrameworkPlugin') ) {
			remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
		}
		wp_register_style('innvoke-insignia-icons', get_template_directory_uri() . '/assets/css/insignia-icons.css');
		wp_register_style('iconsmind', get_template_directory_uri() . '/assets/css/iconsmind.min.css');
	}
	add_action('init', 'insignia_reduxdemo');

	/**
	* init_nav - Register nav menus.
	*
	* @since       1.0
	*/
	add_action( 'init', 'init_nav' );
	function init_nav() {
		register_nav_menu( 'primary', esc_html__( 'Primary Navigation', 'innvoke' ) );
		if( class_exists('ReduxFrameworkPlugin')){
			register_nav_menu( 'topbar', esc_html__( 'Top Bar Navigation', 'innvoke' ) );
			register_nav_menu( 'footer', esc_html__( 'Footer Navigation', 'innvoke' ) );
		}
	}

	/**
	* After VC Init
	*
	* @since       1.0
	*/

	add_action( 'vc_after_init', 'insignia_vc_after_init_actions' );
	function insignia_vc_after_init_actions() {
		if( function_exists('vc_set_default_editor_post_types') ){
			$list = array(
				'page',
				'post',
				'case_studies',
			);
			vc_set_default_editor_post_types( $list );
		}
	}

	/**
	* limit words in post content
	*
	* @since       1.0
	*/

	function insignia_custom_excerpt_length( $length ) {
		return 20;
	}
	add_filter( 'excerpt_length', 'insignia_custom_excerpt_length', 999 );



add_action('edit_form_after_title','wpse_228208');

function wpse_228208($post_id)
{

    global $post;
    $resumesShow = 0;
    $postId = $post_id->ID;
    $uploads = wp_upload_dir();
    $attachments = get_post_meta($postId,'attachment_file_name');
    $countOfAttachments = count($attachments);
    $contactFormId  = get_post_meta($postId,'contact_form_id');
    $countOfContactForms = count($contactFormId);
    for($index =0;$index < $countOfContactForms;$index++)
    {
        $post_exist = get_post_meta($contactFormId[$index],'wpcf7s_posted-your-name');
        if($post_exist) {
            $resumesShow = $resumesShow + 1;
        }
    }
    if($resumesShow > 0) {
        printf('<h3>RESUMES SUBMITTED</h3>');
		printf('<table class="widefat fixed" cellspacing="0"><tbody><tr><td>SLNO</td><td>NAME</td><td>EMAIL</td><td>CONTACT NO</td><td>RESUME</td></tr>');
$slno=0;
        for ($index = 0; $index < $countOfAttachments; $index++) {
            $post_exist = get_post_meta($contactFormId[$index], 'wpcf7s_posted-your-name');
            if ($post_exist) {
                $file_url = $uploads[baseurl] . '/wpcf7-submissions/' . $contactFormId[$index] . '/' . $attachments[$index];
				$name = get_post_meta($contactFormId[$index], 'wpcf7s_posted-your-name');
				$email = get_post_meta($contactFormId[$index], 'wpcf7s_posted-your-email');
				$phone = get_post_meta($contactFormId[$index], 'wpcf7s_posted-tel-515');
				$slno = $slno +1;
				printf('<tr><td>'.$slno.'</td>');
				printf('<td>'.$name[0].'</td>');
				printf('<td>'.$email[0].'</td>');
				printf('<td>'.$phone[0].'</td>');
                printf('<td><a href="%1$s" target="_blank">' . $attachments[$index] . '</a><td></tr>', $file_url);
            }
        }
		printf('</tbody></table>');
    }
}

add_filter( 'pre_get_posts', 'exclude_category' );

function exclude_category($query)
{global $wpdb;
 $today ='Ymd';
	$page_id = get_queried_object_id();
	//print_r($page_id);
	if($page_id == 3778){
// 	$excludeposts = $wpdb->get_col( "SELECT post_id FROM $wpdb->postmeta WHERE meta_key = 'expiration' AND meta_value < $today  ORDER BY post_id DESC LIMIT 0, 5" );	
// 		print_r($today);
// 		$query->set('post__not_in',$excludeposts);
	
	}
}

// add_action('edit_form_after_title','wpse_228208');

// function wpse_228208($post_id)
// {

//     global $post;
//     $postId = $post_id->ID;
//     $uploads = wp_upload_dir();
//     $attachments = get_post_meta($postId,'attachment_file_name');
//     $countOfAttachments = count($attachments);
//     $contactFormId  = get_post_meta($postId,'contact_form_id');
//     printf('<h3>Resumes</h3>');

//     for($index =0;$index < $countOfAttachments;$index++)
//     {
//         $post_exist = get_post_meta($contactFormId[$index],'wpcf7s_posted-your-name');
//         if($post_exist) {
//             $file_url = $uploads[baseurl] . '/wpcf7-submissions/' . $contactFormId[$index] . '/' . $attachments[$index];
//             printf('<a href="%1$s" target="_blank">Open File ' . $attachments[$index] . '</a><br>', $file_url);
//         }
//     }
// }