<?php
/**
 * The Header for our theme.
 *
 * @package chefry
 * @author insignia Technolabs
 * @link http://insigniatechnolabs.com/
 */

header("X-Robots-Tag: noindex",true);
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <link rel="preload" href="https://saasvaap.com/wp-content/themes/innvoke/assets/fonts/themify.woff" as="font" crossorigin="anonymous" />
  <link rel="preload" href="https://saasvaap.com/wp-content/plugins/js_composer/assets/css/lib/vc-material/fonts/vc_material.ttf" as="font" crossorigin="anonymous" />
  <link rel="preload" href="https://saasvaap.com/wp-content/plugins/revslider/public/assets/fonts/font-awesome/fonts/fontawesome-webfont.woff" as="font" crossorigin="anonymous"/>
  <link rel="preload" href="https://saasvaap.com/wp-content/themes/innvoke/assets/fonts/iconsmind.woff" as="font" crossorigin="anonymous" />

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

	<?php
	if(isset(insignia_option('insignia-favicon')['url'])){

		$name = insignia_option('insignia-favicon')['url'];

		if ( ! ( function_exists( 'has_site_icon' ) && has_site_icon() ) ) { ?>
			<link rel="shortcut icon" href="<?php echo esc_url($name); ?>">
	<?php } } ?>

	<?php wp_head(); ?>
	
	<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-149143129-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-149143129-1');
</script>


</head>

<body <?php body_class(); ?>>

	<?php 
	if ( insignia_option( 'page_loader' ) == true ) {
		insignia_page_loader();
	}
	?>

<?php if(insignia_option('header_sidearea') != false){ ?>
	<?php if ( is_active_sidebar( 'sidebar-5' ) ) : ?>
	<div class="insignia-sidearea insignia-sidearea-vertical insignia-sidearea-right" id="insignia-sidearea">
		<button class="close-button-menu sidearea-menu-close" id="close-sidearea-menu"></button>
		<div class="display-table padding-twelve-all height-100 width-100">
			<div class="display-table-cell vertical-align-top padding-70px-top position-relative">
				<div class="insignia-sidearea-content"><?php dynamic_sidebar( 'sidebar-5' ); ?></div>
			</div>
		</div>
	</div>
	<?php endif; ?>
<?php } ?>

	<!-- Contact Modal Window -->
	<?php
		if (!empty(insignia_option('ins-header-button'))) {
			if (insignia_option('ins-header-button') && (insignia_option('ins-header-button-action') == '1')) {
				insignia_model_window();
			}
		}
	?>
	<!-- END Contact Modal Window -->


<div id="wrapper" class="<?php insignia_wrapper_classes(); ?>">
<?php
$template = get_page_template_slug( $post );
if($template !== "no-header-footer.php"){
 
$header_position = insignia_header_position();
	
	if ( $header_position == 'top' ) {
	
		$header_style = insignia_header_style();

        // Scroll after style
        
        $data_sticky_amount = '';
        
        if ( insignia_option( 'header_sticky' ) == 'sticky-appear' ) {
            $data_sticky_amount = '500';
            if ( insignia_option( 'header_sticky_scroll' ) != '' ) {
                $data_sticky_amount = insignia_option( 'header_sticky_scroll' );
            }
        }

	?>

	<!-- start of Header !-->
	<div class="header-sidearea-body-style"></div>
	<header id="header" class="<?php insignia_header_classes(); ?>" data-scroll-height="<?php insignia_header_scroll_height(); ?>" data-scroll-animation="<?php insignia_header_scroll_animation(); ?>" data-skin="<?php echo esc_attr( insignia_header_skin() ); ?>" data-scroll-skin="<?php echo esc_attr( insignia_header_scroll_skin() ); ?>"<?php if ( $data_sticky_amount != '' ) echo ' data-scroll-amount="' . esc_attr( $data_sticky_amount ) . '"'; ?>>

	<?php
	
	$container_classes = '';
	
	if ( insignia_header_container() == 'fullwidth' ) {
		$container_classes .= '-fluid';
	}
	
	// Top Bar
	
	if ( insignia_option('topbar') && $header_position != 'left' && $header_position != 'right' ) {
		insignia_print_topbar( $container_classes );
	} 
	
	// Header itself
	
		// Classic Header
		$nav_position = 'right';

		?>
	
		<div id="main-navigation" class="main-nav">
		
			<div class="main-nav-wrapper">
			
				<div class="container<?php echo esc_attr( $container_classes ); ?>">
				
					<?php 
					
					echo '<div class="nav-left">'; 
					 ?>
					
						<div id="logo">
						
							<?php insignia_site_logo(); ?>
							
						</div>
						
					<?php echo '</div>'; ?>
					
					<div class="nav-<?php echo esc_attr( $nav_position ); ?>">
					
							<nav id="main-menu" class="main-menu">
								<?php insignia_nav_menu(); ?>
							</nav>
						
						<?php 
                            if ( has_nav_menu( 'primary' ) ) {
                                insignia_nav_tools(); 
                            	insignia_header_button();
                            }
							
						?>
						
					</div>
				</div>
			</div>
		</div>
	
	
	<nav id="mobile-nav" class="mobile-nav">
		<div class="container">
			<?php insignia_mobile_nav_menu(); ?>
		</div>
	</nav>
 
</header>
<!-- 	<div class="saas-posi" >
		<img src="https://saasvaap.com/wp-content/uploads/christmas-saasvaap.png" width="60" alt="Happy Christmas & New Year" />
	</div> -->
	<?php } ?>
<!-- end of Header demo five html !-->

	<?php 
	
	$page_title = "page-with-no-title";
	
	if ( insignia_option( 'header_title' ) != 0 && get_post_meta( insignia_get_id(), "_ins_custom_pagetitle", TRUE ) != 'disable' || insignia_option( 'header_title' ) == null ) {
		get_template_part( 'page-title' );
		$page_title = "page-with-title";
	}
	
       $inline_css = '';

	if ( get_post_meta( insignia_get_id(), '_ins_page_content_padding-top', true ) != '' ) {
		$padding_top = get_post_meta( insignia_get_id(), '_ins_page_content_padding-top', true );
		$inline_css .= 'padding-top: ' . esc_attr( $padding_top ) . 'px;';
	}
	
	if ( get_post_meta( insignia_get_id(), '_ins_page_content_padding-bottom', true ) != '' ) {
		$padding_bottom = get_post_meta( insignia_get_id(), '_ins_page_content_padding-bottom', true );
		$inline_css .= 'padding-bottom: ' . esc_attr( $padding_bottom ) . 'px;';
	}

	$page_padding_css = 'style=" ' . esc_attr($inline_css ) . '"';
	?>
	<section id="main-content-wrapper" class="<?php echo esc_attr($page_title);?>"  style="<?php echo esc_attr($inline_css); ?>">
<?php } ?> 
