<?php
/**
 * The template used for displaying post content in single.php
 *
 * @package Insignia Themes
 * @subpackage Insignia
 * @since Insignia 0.1
 */
?>

<?php 

$post = $wp_query->post;
get_header(); 
$post_id = get_the_ID();
$layout = insignia_page_layout( $post_id );

if( $layout != "full_width" && is_active_sidebar("default_sidebar") ) { ?>
    <div id="content" class="page-layout-<?php echo esc_attr( $layout ); ?>">
<?php }	else{ ?>
    <div id="content" class="page-layout-full_width">
<?php } ?>
    	<div class="container">
    	
    		<div class="row">
    		
    			<div id="page-content" class="page-content-wrapper">
    		
    			<?php
    			
    			// Post Content Loop
    			
    			if (have_posts()) : while (have_posts()) : the_post(); 
    				//$expirationtime = get_post_meta($post->ID, "expiration", false);print_r($expirationtime[0]);
    				$today = date("d/m/Y");//print_r($today);
    				$extra_classes = array();
    				$extra_classes[] = 'post-holder margin-35px-bottom clearfix';
    				
    				?>
    				
    				<div <?php post_class( $extra_classes ); ?>>
    
    					<?php
    					
    					// Post Media
    					
    					$post_format = get_post_format( get_the_ID() );
    					
    					if ( insignia_option( 'blog_single_media' ) != false && get_post_meta( get_the_ID(), '_ins_post_media', true) != 'hide' ) {
    						if( $post_format != '' || $post_format == '' && has_post_thumbnail() ) {
//     							echo '<div class="ins-single-post-media margin-30px-bottom display-block">';
//     							$img_size = 'full';
//     							insignia_post_media( get_the_ID(), $post_format, $img_size );
//     							echo '</div>';
    						}
    					}
    					?>
    					<?php //insignia_blog_post_title_meta(); ?>
    					<?php the_content(); ?>
    				
    				</div>
    				
    				<div class="after-blog-post">
    				
    				<?php
    				
    					// Trackbacks
    					
    					if( $post->ping_status == 'open' && insignia_option('blog_trackback') != false ) {
    						echo '<div class="post-trackbacks"><p class="post-trackback"><i class="fa fa-chain"></i> ' . esc_html__( 'Trackback URL', 'innvoke' ) . ': <a href="' . get_trackback_url() . '">' . get_trackback_url() . '</a></p></div>';
    					}
    					
    					wp_link_pages();
    					
    					// Post Author
    
    					$authordesc = get_the_author_meta( 'description' );
    
    					if ( insignia_option( 'blog_post_author' ) != false && !empty ( $authordesc ) ) {
    						insignia_blog_post_author();
    					}
                        
    					// Post tags & social sharing
                        ?>
                       <?php
    					// Post Navigation
    
    					    if( insignia_option('blog_post_nav') != false ) {
    						    insignia_blog_post_nav();
    					    }
    
    					// Comments
    					
    					if ( ( comments_open() || get_comments_number() ) && ! post_password_required() ) {
    						echo '<div class="post-comments">';
    						comments_template();
    						echo '</div>';
    					}
    					
    					?>
    				
    				</div>
    				
    				<?php
    				
    				// End The Loop          
    				endwhile; endif; 
    				?>
    			
    			</div>
    			
    			<?php
    			
    			// Page Sidebar
    			if( $layout != "full_width" && is_active_sidebar("default_sidebar") ) {
    				get_sidebar();    
    			}
    			
    			?>
    		
    		</div>
    	
    	</div>
<?php get_footer(); ?>