<?php



global $post;
function get_met($value) {
	$message = $post->ID;
echo $message;
	$field = get_post_meta($post->ID, $value, 1);
	if ( ! empty( $field ) ) {
		return is_array( $field ) ? stripslashes_deep( $field ) : stripslashes( wp_kses_decode_entities( $field ) );
	} else {
		return false;
	}
}
if ( file_exists( plugin_dir_path( __FILE__ ) . '/cmb2/init.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . '/cmb2/init.php';
} elseif ( file_exists( plugin_dir_path( __FILE__ ) . '/CMB2/init.php' ) ) {
	require_once plugin_dir_path( __FILE__ ) . '/CMB2/init.php';
}


add_action( 'cmb2_init', 'insignia_post_metabox' );
function insignia_post_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'post_setting',
		'title'        => __( 'Blog Post', 'emerson' ),
		'object_types' => array( 'post' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );


	$cmb->add_field( array(
		'name' => __( 'Post Media', 'emerson' ),
		'id' => $prefix . 'post_media',
		'type' => 'radio_inline',
		'options' => array(
			'default' => __( 'Default', 'emerson' ),
			'hide' => __( 'Hide', 'emerson' )
		),
		'desc' => __( 'Display post media on single post page according to post format i.e. video player for "video" format etc.', 'cmb2' ),
	) );
}


add_action( 'cmb2_init', 'ins_add_general_metabox' );
function ins_add_general_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'layout',
		'title'        => __( 'General', 'emerson' ),
		'object_types' => array( 'page', 'post' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Layout', 'emerson' ),
		'id' => $prefix . 'select_layout',
		'type' => 'select',
		'default' => 'select_layout',
		'options' => array(
			'select_layout' => __( 'Select Layout', 'emerson' ),
			'full_width' => __( 'Full width', 'emerson' ),
			'left_sidebar' => __( 'Left sidebar', 'emerson' ),
			'right_sidebar' => __( 'Right sidebar', 'emerson' ),
		),
		'desc' => __( 'Choose a layout for this page.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Top Padding', 'emerson' ),
		'id' => $prefix . 'page_content_padding-top',
		'type' => 'text_small',
		'desc' => __( 'Set a top (between Title Area and Content) padding. In pixels. Add Numeric value only, Do not add "px".', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Bottom Padding', 'emerson' ),
		'id' => $prefix . 'page_content_padding-bottom',
		'type' => 'text_small',
		'desc' => __( 'Set a bottom (between Content and Footer) padding. In pixels. Add Numeric value only, Do not add "px".', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( '#Wrapper Classes', 'emerson' ),
		'id' => $prefix . 'wrapper_classes',
		'type' => 'text',
		'desc' => __( 'Type CSS classes that will be added to the website\'s main container #wrapper. You may add as many classes as you want, just separate them with a space. You may later easily select them in your CSS code, like .myclass', 'cmb2' ),
	) );

}



add_action( 'cmb2_init', 'ins_add_general_case_studies_metabox' );
function ins_add_general_case_studies_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'port_layout',
		'title'        => __( 'General', 'emerson' ),
		'object_types' => array( 'case_studies' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Top Padding', 'emerson' ),
		'id' => $prefix . 'page_content_padding-top',
		'type' => 'text_small',
		'desc' => __( 'Set a top (between Title Area and Content) padding. In pixels. Add Numeric value only, Do not add "px".', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Bottom Padding', 'emerson' ),
		'id' => $prefix . 'page_content_padding-bottom',
		'type' => 'text_small',
		'desc' => __( 'Set a bottom (between Content and Footer) padding. In pixels. Add Numeric value only, Do not add "px".', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( '#Wrapper Classes', 'emerson' ),
		'id' => $prefix . 'wrapper_classes',
		'type' => 'text',
		'desc' => __( 'Type CSS classes that will be added to the website\'s main container #wrapper. You may add as many classes as you want, just separate them with a space. You may later easily select them in your CSS code, like .myclass', 'cmb2' ),
	) );

}


add_action( 'cmb2_init', 'page_title_add_metabox' );
function page_title_add_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'page_header',
		'title'        => __( 'Page Title Area', 'emerson' ),
		'object_types' => array( 'page', 'post', 'case_studies' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Title', 'emerson' ),
		'id' => $prefix . 'custom_pagetitle',
		'type' => 'radio_inline',
		'options' => array(
			'enable' => __( 'Enable', 'emerson' ),
			'disable' => __( 'Disable', 'emerson' ),
		),
	) );

	$cmb->add_field( array(
		'name' => __( 'Custom Title Text', 'emerson' ),
		'id' => $prefix . 'custom_title',
		'type' => 'text',
		'desc' => __( 'Type a different page title. Leave blank for default.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Subtitle', 'emerson' ),
		'id' => $prefix . 'page_subtitle',
		'type' => 'text',
		'desc' => __( 'Optional page subtitle.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Text Align', 'emerson' ),
		'id' => $prefix . 'pagetitle_align',
		'type' => 'radio_inline',
		'options' => array(
			'default' => __( 'Default', 'emerson' ),
			'center' => __( 'Center', 'emerson' ),
			'left' => __( 'Left', 'emerson' ),
			'right' => __( 'Right', 'emerson' )
		),
	) );

	$cmb->add_field( array(
		'name' => __( 'Title Color', 'emerson' ),
		'id' => $prefix . 'pagetitle_color',
		'type' => 'colorpicker',
		'desc' => __( 'Custom color of the page title heading. Leave blank for default.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Subtitle Color', 'emerson' ),
		'id' => $prefix . 'pagetitle_subtitle_color',
		'type' => 'colorpicker',
		'desc' => __( 'Custom color of the page subtitle. Leave blank for default.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Page Title Height', 'emerson' ),
		'id' => $prefix . 'pagetitle_height',
		'type' => 'text_small',
		'desc' => __( 'Enter height of page header. Enter Number without unit for example "300".', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Background Image', 'emerson' ),
		'id' => $prefix . 'pagetitle_bg_image',
		'type' => 'file',
	) );

	$cmb->add_field( array(
		'name' => __( 'Background Color', 'emerson' ),
		'id' => $prefix . 'pagetitle_bg_color',
		'type' => 'colorpicker',
	) );

	$cmb->add_field( array(
		'name' => __( 'Background Image Overlay', 'emerson' ),
		'id' => $prefix . 'pagetitle_bg_image_overlay',
		'type' => 'select',
		'options' => array(
				"" => __("", "emerson" ),
				"none" => __("None", "emerson" ),
				"dark30" => __("Dark 30%","emerson" ),
				"dark50" => __("Dark 50%","emerson" ),
				"dark70" => __("Dark 70%","emerson" ),
				"dark80" => __("Dark 80%","emerson" ),
				"dark90" => __("Dark 90%","emerson" ),
				"light30" => __("Light 30%","emerson" ),
				"light50" => __("Light 50%","emerson" ),
				"light70" => __("Light 70%","emerson" ),
				"light80" => __("Light 80%","emerson" ),
				"light90" => __("Light 90%","emerson" )
		),
		'desc' => __( 'Choose an overlay for your background image.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Background size', 'emerson' ),
		'id' => $prefix . 'pagetitle_bg_size',
		'type' => 'select',
		'options' => array(
			'' => __( '', 'emerson' ),
			'initial' => __( 'initial', 'emerson' ),
			'inherit' => __( 'inherit', 'emerson' ),
			'contain' => __( 'contain', 'emerson' ),
			'cover' => __( 'cover', 'emerson' ),
		),
	) );

	$cmb->add_field( array(
		'name' => __( 'Background Position', 'emerson' ),
		'id' => $prefix . 'pagetitle_bg_position',
		'type' => 'select',
		'options' => array(
			'' => __( '', 'emerson' ),
			'left top' => __( 'left top', 'emerson' ),
			'left center' => __( 'left center', 'emerson' ),
			'left bottom' => __( 'left bottom', 'emerson' ),
			'right top' => __( 'right top', 'emerson' ),
			'right center' => __( 'right center', 'emerson' ),
			'right bottom' => __( 'right bottom', 'emerson' ),
			'center top' => __( 'center top', 'emerson' ),
			'center center' => __( 'center center', 'emerson' ),
			'center bottom' => __( 'center bottom', 'emerson' ),
		),
	) );

	$cmb->add_field( array(
		'name' => __( 'Background Repeat', 'emerson' ),
		'id' => $prefix . 'pagetitle_bg_repeat',
		'type' => 'select',
		'options' => array(
			'' => __( '', 'emerson' ),
			'inherit' => __( 'Inherit', 'emerson' ),
			'no-repeat' => __( 'No Repeat', 'emerson' ),
			'repeat' => __( 'Repeat All', 'emerson' ),
			'repeat-x' => __( 'Repeat Horizontally', 'emerson' ),
			'repeat-y' => __( 'Repeat Vertically', 'emerson' ),
		),
	) );

	$cmb->add_field( array(
		'name' => __( 'Background Attachment', 'emerson' ),
		'id' => $prefix . 'pagetitle_bg_attachment',
		'type' => 'select',
		'options' => array(
			'' => __( '', 'emerson' ),
			'inherit' => __( 'inherit', 'emerson' ),
			'fixed' => __( 'fixed', 'emerson' ),
			'scroll' => __( 'scroll', 'emerson' ),
		),
	) );

	$cmb->add_field( array(
		'name' => __( 'Fullscreen Page Title', 'emerson' ),
		'id' => $prefix . 'pagetitle_fullscreen',
		'type' => 'radio_inline',
		'options' => array(
			'on' => __( 'On', 'emerson' ),
			'off' => __( 'Off', 'emerson' )
		),
		'desc' => __( 'Choose size of your Page Title Area.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Breadcrumbs', 'emerson' ),
		'id' => $prefix . 'pagetitle_breadcrumbs',
		'type' => 'radio_inline',
		'options' => array(
			'default' => __( 'Default', 'emerson' ),
			'yes' => __( 'Enable', 'emerson' ),
			'no' => __( 'Disable', 'emerson' )
		),
		'desc' => __( 'Enable or disable the breadcrumbs navigation.', 'cmb2' ),
	) );

}





/*case studies metabox*/

add_action( 'cmb2_init', 'ins_add_case_studies_metabox' );
function ins_add_case_studies_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'case_studies',
		'title'        => __( 'Case Studies Settings', 'emerson' ),
		'object_types' => array( 'case_studies' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );

	$cmb->add_field( array(
		'name' => __( 'Accent Color', 'emerson' ),
		'id' => $prefix . 'case_studies_color',
		'type' => 'colorpicker',
		'default' => '#71cbcc',
	) );
	
	$cmb->add_field( array(
		'name' => __( 'Client Logo', 'emerson' ),
		'id' => $prefix . 'case_studies_logo',
		'type'    => 'file',
	    'options' => array(
		    'url' => false, // Hide the text input for the url
	    ),
	    'text'    => array(
		    'add_upload_file_text' => 'Add Image' // Change upload button text. Default: "Add or Upload File"
	    ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Social Sharing Buttons', 'emerson' ),
		'id' => 'case_studies_sharing',
		'type' => 'radio_inline',
		'options' => array(
			'default' => __( 'Default', 'emerson' ),
			'yes' => __( 'Yes', 'emerson' ),
			'no' => __( 'No', 'emerson' )
		),
		'desc' => __( 'Display Social sharing buttons.', 'cmb2' ),
	) );

	$cmb->add_field( array(
		'name' => __( 'Post Navigation', 'emerson' ),
		'id' => 'case_studies_navigation',
		'type' => 'radio_inline',
		'options' => array(
			'default' => __( 'Default', 'emerson' ),
			'yes' => __( 'Yes', 'emerson' ),
			'no' => __( 'No', 'emerson' )
		),
		'desc' => __( 'Display post navigation.', 'cmb2' ),
	) );

}

/*Testimonial Metabox*/
add_action( 'cmb2_init', 'ins_add_testimonial_metabox' );
function ins_add_testimonial_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'testimonial',
		'title'        => __( 'Testimonial Options', 'emerson' ),
		'object_types' => array( 'testimonial_post' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );
	
	$cmb->add_field( array(
		'name' => __( 'Heading', 'emerson' ),
		'id' => $prefix . 'heading',
		'type' => 'text',
	) );

	$cmb->add_field( array(
		'name' => __( 'Author', 'emerson' ),
		'id' => $prefix . 'author',
		'type' => 'text',
	) );

	$cmb->add_field( array(
		'name' => __( 'Position', 'emerson' ),
		'id' => $prefix . 'position',
		'type' => 'text',
	) );

}


add_action( 'cmb2_init', 'insignia_add_post_video_metabox' );
function insignia_add_post_video_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'post_video',
		'title'        => __( 'Post Video', 'emerson' ),
		'object_types' => array( 'post' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );

	$cmb->add_field( array(
		'name' => __( 'YouTube video ID', 'emerson' ),
		'id' => $prefix . 'youtube_video',
		'type' => 'text',
	) );

	$cmb->add_field( array(
		'name' => __( 'Vimeo video ID', 'emerson' ),
		'id' => $prefix . 'vimeo_video',
		'type' => 'text',
	) );

	$cmb->add_field( array(
		'name' => __( 'Self hosted video file in mp4 format', 'emerson' ),
		'id' => $prefix . 'hosted_video_mp4',
		'type' => 'file',
	) );

	$cmb->add_field( array(
		'name' => __( 'Self hosted video file in webM format', 'emerson' ),
		'id' => $prefix . 'hosted_video_webm',
		'type' => 'file',
	) );

}


add_action( 'cmb2_init', 'insignia_add_post_audio_metabox' );
function insignia_add_post_audio_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'post_audio',
		'title'        => __( 'Post Audio', 'emerson' ),
		'object_types' => array( 'post' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );


	$cmb->add_field( array(
		'name' => __( 'Self hosted audio file in mp3 format', 'emerson' ),
		'id' => $prefix . 'hosted_audio',
		'type' => 'file',
	) );

}
add_action( 'cmb2_init', 'insignia_add_post_quote_metabox' );
function insignia_add_post_quote_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'post_quote',
		'title'        => __( 'Post Quote', 'emerson' ),
		'object_types' => array( 'post' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );

	$cmb->add_field( array(
		'name' => __( 'Quote Text', 'emerson' ),
		'id' => $prefix . 'quote_text',
		'type' => 'textarea',
	) );

	$cmb->add_field( array(
		'name' => __( 'Quote author name', 'emerson' ),
		'id' => $prefix . 'quote_author',
		'type' => 'text',
	) );

	$cmb->add_field( array(
		'name' => __( 'Background color', 'emerson' ),
		'id' => $prefix . 'quote_background_color',
		'default' => '#302f35',
		'type' => 'colorpicker',
	) );

	$cmb->add_field( array(
		'name' => __( 'Quote text color', 'emerson' ),
		'id' => $prefix . 'quote_text_color',
		'default' => '#c1c1c1',
		'type' => 'colorpicker',
	) );

}

add_action( 'cmb2_init', 'insignia_add_post_gallery_metabox' );
function insignia_add_post_gallery_metabox() {

	$prefix = '_ins_';

	$cmb = new_cmb2_box( array(
		'id'           => $prefix . 'post_gallery',
		'title'        => __( 'Post Gallery', 'emerson' ),
		'object_types' => array( 'post' ),
		'context'      => 'normal',
		'priority'     => 'default',
	) );

	$cmb->add_field( array(
		'name' => __( 'Upload Image Gallery', 'emerson' ),
		'id' => $prefix . 'gallery_for_post',
		'type' => 'file_list',
	) );


}



