<?php
/**
 *
 * Pricing Table VC element by INSIGNIA
 *
 */

add_action( 'vc_before_init', 'VC_ins_pricing_box' );

function VC_ins_pricing_box() {
	
	vc_map( array(
	"name" => esc_html__( "Pricing Box", "emerson" ),
	"base" => "pricing_box",
	"class" => "font-awesome",
	"icon" => "fa fa-usd",
        "category" => __( "Insignia", "emerson"),
	"description" => esc_html__( "Product box with prices", "emerson" ),
	"params" => array(
		 array(
			"type" => "textfield",
			"heading" => esc_html__( "Box Title", "emerson" ),
			"param_name" => "title",
			"description" => esc_html__( "Your Pricing Box title", "emerson" ),
			"value" => "Standard",
			"admin_label" => true 
		),
		 array(
			"type" => "textfield",
			"heading" => esc_html__( "Box Subtitle", "emerson" ),
			"param_name" => "subtitle",
			"description" => esc_html__( "Your Pricing Box subtitle", "emerson" ),
			"value" => "Most Popular",
			"admin_label" => true,
		),
		
		array(
            "type" => "textfield",
            "class" => "",
            "heading" => __( "Price Value", "emerson" ),
            "param_name" => "price_value",
            "value" => __( "$", "emerson" ),
             "description" => __( "Currency or other value prices. e.g. $", "emerson" )
         
         ),


		array(
			"type" => "textfield",
			"heading" => esc_html__( "Price", "emerson" ),
			"param_name" => "price",
			"description" => esc_html__( "Pricing Box price", "emerson" ),
			"value" => "99",
			"admin_label" => true 
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Period", "emerson" ),
			"param_name" => "period",
			"description" => esc_html__( "Pricing Box period", "emerson" ),
			"value" => "Month" 
		),
		 array(
            "type" => "textarea_html",
            "class" => "",
            "heading" => __( "Features", "emerson" ),
            "param_name" => "content",
             "value" => ""
        ),
		array(
			"type" => "checkbox",
			"heading" => esc_html__( "Add Icon?", "emerson" ),
			"param_name" => "add_icon",
			"class" => "hidden-label",
			"value" => array(
				esc_html__( "Yes", "emerson" ) => "true",
			),
			"description" => esc_html__( "Display an icon before each feature.", "emerson" ) 
		),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon before list item', "emerson" ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-info-circle',
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'iconsPerPage' => 200 // default 100, how many icons per/page to display
				),
				'dependency' => array(
					"element" => 'add_icon',
					'value' => 'true',
				),
				'description' => esc_html__( 'Select icon from library.', "emerson" ) 
			),
		array(
			"type" => "dropdown",
			"class" => "hidden-label",
			"value" => array(
				esc_html__( "Not Featured", "emerson" ) => 'no',
				esc_html__( "Featured", "emerson" ) => 'yes' 
			),
			"heading" => esc_html__( "Featured?", "emerson" ),
			"description" => esc_html__( 'Make the box stand out from the crew.', "emerson" ),
			"param_name" => "featured" 
		),
		
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Button Label", "emerson" ),
			"param_name" => "button_label",
			"description" => esc_html__( "Text visible on the box button", "emerson" ),
			"value" => "Buy Now" 
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Button URL", "emerson" ),
			"param_name" => "button_url",
			"description" => esc_html__( "Button URL, start with http://", "emerson" ),
			"value" => "#",
			'dependency' => Array(
				"element" => "button_label",
				'not_empty' => true 
			) 
		),
                 array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __( "Button Border Radius", "skylon" ),
            "param_name" => "btn_border_radius",

              "description" => __( "Button border radius. Rounded corners.", "skylon" ),
             "value"       => array(
       
       'Select' => '',
        'Default'   => 'btn-radius-default',
        'Circle'   => 'btn-circle',
        'Square (no-radius)'   => 'btn-square'
        
         ),
         'dependency' => Array(
				"element" => "button_label",
				'not_empty' => true 
			),
      "std"         => '',
            
         ),
		
		 array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        ),

            array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "param_name" => "ib_animation_delay",
                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                        ),
	 

	array(
            "type" => "textfield",
            "class" => "",
             
            "heading" => __( "Extra Class Name", "emerson" ),
            "param_name" => "extra_class",
            "value" => __( "", "emerson" ),
             "description" => __( "Style particular content element differently - add a class name and refer to it in custom CSS.", "emerson" ),
            
         ),



			array(
				"type" => "dropdown",
				"heading" => esc_html__( "Background Color", "emerson" ),
				"param_name" => "bg",
				"value" => array(
					esc_html__( "Default", "emerson" ) => "",
					esc_html__( "White", "emerson" ) => "white",
					esc_html__( "Transparent Light", "emerson" ) => "transparent_light",
					esc_html__( "Transparent Dark", "emerson" ) => "transparent_dark",
					esc_html__( "None", "emerson" ) => "none",
				),
				"group" => esc_html__( "Design", "emerson" ),
				"description" => esc_html__( "Choose the pricing box background color.", "emerson" )
			),
						array(
				"type" => "dropdown",
				"heading" => esc_html__( "Text Color Scheme", "emerson" ),
				"param_name" => "text_color",
				"value" => array(
					esc_html__( "Default", "emerson" ) => "",
					esc_html__( "Light Scheme", "emerson" ) => "text-white",
					esc_html__( "Dark Scheme", "emerson" ) => "text-theme-default",
				),
				"group" => esc_html__( "Design", "emerson" ),
				"description" => esc_html__( "Light Scheme - all text styled to white color, recommended for dark backgrounds.", "emerson" )
			),
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Content Alignment", "emerson" ),
			"param_name" => "content_alignment",
			"value" => array(
				esc_html__( "Left", "emerson" ) => "text-left",
				esc_html__( "Center", "emerson" ) => "text-center",
				esc_html__( "Right", "emerson" ) => "text-right",
			),
			"group" => esc_html__( "Design", "emerson" ),
			"description" => esc_html__( "Choose content alignment position", "emerson" )
		),		
		
	) )
);
	
}


function insignia_pricing_box( $atts, $content )
{

	$icon_type = 'fontawesome';
	$defaultIconClass = 'fa fa-info-circle';
	
	extract( shortcode_atts( array(
		"featured" => 'no',
		"title" => esc_html__( 'Standard', 'citta'),
		"subtitle" => esc_html__( 'Most Popular', 'citta'),
		"content" => $content,
		"button_label" => esc_html__( 'Buy Now', 'citta'),
		"period" => esc_html__( 'Month', 'citta'),
		"price" => '99',
		"button_url" => '#',
		"animation_delay" => '100',
		"bg" => 'gray',
		"text_color" => 'text-theme-default',
		"add_icon" => 'false',
		"content_alignment" => 'text_center',
		"icon_fontawesome" => $defaultIconClass,
		"price_value" => '$',
		'extra_class' => '',
		'css_animation'  => '',
        'ib_animation_delay'=> '',
        'btn_border_radius'=>''

         
		
	), $atts ) );
	
	$animated_data = '';
	
	//CSS Animation
            if ($css_animation == "no_animation") {
                $css_animation = "";
            }

 $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay;
            }
	
	$css_classes = array();
	
	if ( $featured == 'yes' ) {
		$css_classes[] = "pricing-box-featured";
		$css_classes[] = ' border-color-accent';
	}
	
		$css_classes[] = 'pricing-box-' . $bg;
		$css_classes[] = $content_alignment;
		$css_classes[] = $text_color;

	
	// Add icon
	
	$icon = '';
	
	if ( $add_icon != "false" ) {
	
		$icon = str_replace( 'fa-', '', $icon );
		vc_icon_element_fonts_enqueue( $icon_type );		
		$iconClass = isset( ${"icon_" . $icon_type} ) ? ${"icon_" . $icon_type} : $defaultIconClass;
		
		$css_classes[] = 'pricing-box-with-icons';
		$icon = '<span class="pricing-box-icon"><i class="' . $iconClass . '"></i></span> ';
		
	}
	$uniqid = uniqid('ins-pricing-');

	$output = '<div id="'.$uniqid.'" class="pricing-style-1 insignia-pricing-box-wrapper  ' . implode( ' ', $css_classes ) . ' '.$extra_class.' '.$css_animation.'" '.$animation_delay.'>';
	
	$output .= '<div class="insignia-pricing-box-inner">';
	
	$output .= '<div class="insignia-pricing-box-header">';
	$output .= '<div class="pricing-price-box">';
	if ($title != '') {
	$output .= '<span class="pricing-title title-font text-extra-dark-gray text-extra-large font-weight-700 letter-spacing-05">' . esc_html( $title ) . '</span>';
	}
	
	$output .= '<div class="pricing margin-25px-top"><p class="price"><strong>' . esc_html( $price_value ) . '</strong>' . esc_html( $price ) . '</p><p class="period">' . esc_html( $period ) . '</p></div>';


	$output .= '</div>';
	$output .= '</div>';

	$output .= '<div class="pricing-features">';
	
	if ($subtitle != '') {
	$output .= '<p class="pricing-sub-title letter-spacing-05">' . esc_html( $subtitle ) . '</p>';
	}
	if(!empty($content)) {
	$output .= '<div class="price-list-features-main">';
	$output .= '<p>';
    $output.=$content;
	$output .= '</div>';
	
	}
	// button
	
	if ( $button_label ) {
	
		$btn_color = 'btn-grey';
		if( $featured == 'yes' ) {
			$btn_color = 'btn-accent';
		}
		
		$output .= '<div class="pricing-button margin-35px-top"><a href="' . esc_url( $button_url ) . '" class="btn pricing-box-button btn-hover-dark ' . $btn_color . ' '.$btn_border_radius.'">' . esc_html( $button_label ) . '</a></div>';
		
	}
	$output .= '</div>';
	$output .= '</div>';
	$output .= '</div>';
	return $output;

}

remove_shortcode( 'pricing_box' );
add_shortcode( 'pricing_box', 'insignia_pricing_box' );
