<?php
/**
 *
 * Blockquotes VC element by INSIGNIA
 *
 */

add_action( 'vc_before_init', 'VC_ins_blockquotes' );

function VC_ins_blockquotes() {
	
	vc_map( array(
	"name" => esc_html__( "Blockquotes", "emerson" ),
	"base" => "blockquotes",
	"class" => "font-awesome",
	"icon" => "fa fa-quote-right",
	"category" => __( "Insignia", "emerson"),
	"params" => array(
		array(
			"type" => "dropdown",
			"class" => "hidden-label",
			"value" => array(
				esc_html__( "Style 1", "emerson" ) => 'style-1',
				esc_html__( "Style 2", "emerson" ) => 'style-2', 
				esc_html__( "Style 3", "emerson" ) => 'style-3' 
			),
			"heading" => esc_html__( "Select Style", "emerson" ),
			"param_name" => "style" 
		),	
		 array(
			"type" => "textfield",
			"heading" => esc_html__( "Cite", "emerson" ),
			"param_name" => "cite",
			"value" => "John Doe",
			"admin_label" => true 
		),
		array(
			"type" => "textfield",
			"heading" => esc_html__( "Role", "emerson" ),
			"param_name" => "role",
			"value" => "Businessman",
			"admin_label" => true 
		),
		 array(
			"type" => "textarea",
			"heading" => esc_html__( "Quote", "emerson" ),
			"param_name" => "quote",
			"value" => "Great things in business are never done by one person. They are done by a team of people.",
			"admin_label" => true
		),
		
		 array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        ),

            array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "param_name" => "ib_animation_delay",
                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                        ),
	 
		
		array(
			"type" => "dropdown",
			"heading" => esc_html__( "Content Alignment", "emerson" ),
			"param_name" => "alignment",
			"value" => array(
				esc_html__( "Left", "emerson" ) => "text-left",
				esc_html__( "Center", "emerson" ) => "text-center",
				esc_html__( "Right", "emerson" ) => "text-right",
			),
			"group" => esc_html__( "Design", "emerson" )
		),	

		array(
			"type" => "colorpicker",
			"edit_field_class" => "vc_col-xs-12 vc_edit_form_elements vc_column-with-padding vc_column",
			"heading" => esc_html__( "Text Color", "emerson" ),
			"param_name" => "text_color",
			"group" => esc_html__( "Design", "emerson" ),
			"value" => esc_html__( "#6f6f6f", "emerson" ),
			"description" => esc_html__( " Choose Text Color.If you leave it empty, It will set default color", "emerson" )
		 ),

		array(
			"type" => "colorpicker",
			"edit_field_class" => "vc_col-xs-12 vc_edit_form_elements vc_column-with-padding vc_column",
			"heading" => esc_html__( "Cite Color", "emerson" ),
			"param_name" => "cite_color",
			"group" => esc_html__( "Design", "emerson" ),
			"value" => esc_html__( "#6f6f6f", "emerson" ),
			"description" => esc_html__( " Choose Text Color.If you leave it empty, It will set default color", "emerson" )
		 ),
		 
		array(
			"type" => "colorpicker",
			"edit_field_class" => "vc_col-xs-12 vc_edit_form_elements vc_column-with-padding vc_column",
			"heading" => esc_html__( "Background Color", "emerson" ),
			"param_name" => "bg",
			"group" => esc_html__( "Design", "emerson" ),
			"value" => esc_html__( "#f7f7f7", "emerson" ),
			"description" => esc_html__( " Choose Background Color.If you leave it empty, It will set default color", "emerson" )
		 ),
				
		
	) )
);
	
}


function insignia_blockquotes( $atts, $content )
{
	extract( shortcode_atts( array(
		"style" => 'style-1',
		"cite" => esc_html__( 'John Doe','emerson'),
		"role" => esc_html__( 'Businessman', 'emerson'),
		"quote" => esc_html__( 'Great things in business are never done by one person. They are done by a team of people.', 'emerson'),
		"alignment" => 'text-left',
		"text_color" => '#6f6f6f',
		"cite_color" => '#6f6f6f',
		'css_animation'  => '',
        'ib_animation_delay'=> '',
		"bg" => '#f7f7f7',
	), $atts ) );
	
	//CSS Animation
            if ($css_animation == "no_animation") {
                $css_animation = "";
            }
 $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay;
            }
	
	
	$css_classes = array();
	
		$css_classes[] = 'ins-blockquotes-' . $style;
		$css_classes[] = $alignment;
		
		if($style == 'style-1'){
			$css_classes[] = 'text-medium';
		}
		if($style == 'style-2'){
			$css_classes[] = 'text-extra-large';
			$css_classes[] = 'padding-70px-left';
			$css_classes[] = 'border-none';
			$css_classes[] = 'line-height-35';
		}		
		if($style == 'style-3'){
			$css_classes[] = 'text-large';
			$css_classes[] = 'padding-50px-all';
			$css_classes[] = 'pc-border';
			$css_classes[] = 'line-height-30';
		}
	
	// Add icon
	
	$uniqid = uniqid('ins-blockquotes-');

		$css_rules = '';
		if($text_color != '')
		$css_rules .= '#' . $uniqid .'.ins-blockquotes.ins-blockquotes-style-2:before {color: '.$text_color.';}';

		if($bg != '')
		$css_rules .= '#' . $uniqid .'.ins-blockquotes.ins-blockquotes-style-3 {background-color: '.$bg.';}';

	// Output
	
	$output = '<blockquote id="'.$uniqid.'" class="ins-blockquotes ' . implode( ' ', $css_classes ) . ' '.$css_animation.'" '.$animation_delay.'>';
	$output .= '<q style="color: '. $text_color .'">';
	$output .= $quote;
	$output .= '</q>';
	if(!empty($cite) || !empty($role)) {
	$output .= '<cite style="color: '. $cite_color .'" class="text-large display-block padding-20px-top">';
	$output .= $cite;
	$output .= '<span class="text-small display-block">';
	$output .= $role;
	$output .= '</span>';	
	$output .= '</cite>';
	}
	$output .= '</blockquote>';

$output .=	'<script type="text/javascript">
		(function(jQuery) {';

		if($css_rules != '') {
					$output .= 'jQuery("head").append("<style>'.$css_rules.'</style>")';
						}

					$output.=	'
					})(jQuery);
						</script>';
	return $output;
}

remove_shortcode( 'blockquotes' );
add_shortcode( 'blockquotes', 'insignia_blockquotes' );
