<?php
/**
 *
 * Process Step VC element by INSIGNIA
 *
 */

add_action( 'vc_before_init', 'VC_process_step' );

function VC_process_step() {

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_insignia_process_step extends WPBakeryShortCodesContainer {
    
               protected function contentInline($atts, $content = null)
        {
        }
    }
}
if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_insignia_process_step_single extends WPBakeryShortCode {
    
    protected function contentInline($atts, $content = null)
        {
        }
 
    }
}


vc_map (

 array(
		"name" => __( "Process Step", "emerson" ),
		"base" => "insignia_process_step",
       		'as_parent' => array(
        		'only' => 'insignia_process_step_single'
       		),
      		'content_element' => true,
		'controls' => 'full',
		"class" => "",
		"category" => __( "Insignia", "emerson"),
		'show_settings_on_create' => true,
		"class" => "font-awesome",
		"js_view" => 'VcColumnView',

		
		"params" => array(

                        array(
                            "type"			=>	"dropdown",
                            "class"			=>	"",
                            "heading"		=>	esc_html__("Number of elements","keydesign"),
                            "param_name"	=>	"ps_elements",
                            "value"			=>	array(
                                "Three elements" => "process_three_elem",
                                "Four elements" => "process_four_elem",
                                "Five elements" => "process_five_elem"
                            ),
                            "save_always" => true,
                            "description" => esc_html__("Select number of elements in this process.", "keydesign")
                        ),
                        

                        array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__("Border color", "keydesign"),
                            "param_name" => "pss_border_color",
                            "value" => "",
                            "description" => esc_html__("Choose box border color.", "keydesign"),
                        ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Extra class name", "keydesign"),
                            "param_name" => "ps_extra_class",
                            "value" => "",
                            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "keydesign")
                        ),
                     array(
            		'type' => 'css_editor',
            		'heading' => __( 'Css', 'citta' ),
            		'param_name' => 'css',
            		'group' => __( 'Design options', 'citta' ),
        		),
                    )
                ));
                // Shortcode configuration
                vc_map(array(
                
                    "name" => esc_html__("Single process step", "emerson"),
                    "base" => "insignia_process_step_single",
                    "content_element" => true,
                    "as_child" => array('only' => 'insignia_process_step'),

                    "params" => array(
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Title", "keydesign"),
                            "param_name" => "pss_title",
                            "admin_label" => true,
                            "value" => "",
                            "description" => esc_html__("Enter step title.", "keydesign")
                        ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Title Font-size", "keydesign"),
                            "param_name" => "pss_title_size",
                            "value" => "",
                            "description" => esc_html__("Enter title font-size. Example:20", "keydesign"),
                        ),
                         array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__("Title color", "keydesign"),
                            "param_name" => "pss_title_color",
                            "value" => "",
                            "description" => esc_html__("Choose title color. If none selected, the default theme color will be used.", "keydesign"),
                        ),
                        array(
                            "type" => "textarea",
                            "class" => "",
                            "heading" => esc_html__("Description", "keydesign"),
                            "param_name" => "pss_description",
                            "value" => "",
                            "description" => esc_html__("Enter step description.", "keydesign")
                        ),
                        array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__("Description color", "keydesign"),
                            "param_name" => "pss_description_color",
                            "value" => "",
                            "description" => esc_html__("Choose description color. If none selected, the default theme color will be used.", "keydesign"),
                        ),

                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Step number", "keydesign"),
                            "param_name" => "pss_number",
                            "value" => "",
                            "description" => esc_html__("Enter the step number.", "keydesign")
                        ),
                        array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__("Step number color", "keydesign"),
                            "param_name" => "pss_number_color",
                            "value" => "",
                            "description" => esc_html__("Select step number color.", "keydesign"),
                        ),
                        array(
                            "type"			=>	"dropdown",
                            "class"			=>	"",
                            "heading"		=>	esc_html__("Display icon","keydesign"),
                            "param_name"	=>	"pss_icon_type",
                            "value"			=>	array(
                                "No icon" => "no_icon",
                                "Icon browser" => "icon_browser",
                                "Custom image" => "custom_image",
                            ),
                            "save_always" => true,
                            "description" => esc_html__("Select icon source.", "keydesign")
                        ),
                             array(
              							"type" => "iconpicker",
              							"heading" => esc_html__( "Icon", "citta" ),
              							"param_name" => "icon_iconsmind",
                            "settings" => array(
                        				"type" => "iconsmind",
                        				"iconsPerPage" => 50,
                        		),
                        		"dependency" => array(
              								"element" => "pss_icon_type",
              								"value" => "icon_browser",
              							),
              						
              							"description" => esc_html__( "Select icon from library.", "citta" ),
            						),
                        array(
                            "type" => "colorpicker",
                            "class" => "",
                            "heading" => esc_html__("Icon color", "keydesign"),
                            "param_name" => "pss_icon_color",
                            "value" => "",
                            "dependency" =>	array(
                                "element" => "pss_icon_type",
                                "value" => array("icon_browser")
                            ),
                            "description" => esc_html__("Choose icon color. If none selected, the default theme color will be used.", "keydesign"),
                        ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Icon size", "keydesign"),
                            "param_name" => "pss_icon_size",
                            "value" => "",
                            "dependency" =>	array(
                                "element" => "pss_icon_type",
                                "value" => array("icon_browser")
                            ),
                            "description" => esc_html__("Enter icon size. (eg. 10px, 1em, 1rem)", "keydesign"),
                        ),
                        array(
                            "type" => "attach_image",
                            "class" => "",
                            "heading" => esc_html__("Upload image", "keydesign"),
                            "param_name" => "pss_image",
                            "value" => "",
                            "description" => esc_html__("Upload your own custom image.", "keydesign"),
                            "dependency" => array(
                                "element" => "pss_icon_type",
                                "value" => array("custom_image"),
                            ),
                        ),

                        array(
                             "type"	=>	"dropdown",
                             "class" =>	"",
                             "heading" => esc_html__("Link type", "keydesign"),
                             "param_name" => "pss_custom_link",
                             "value" =>	array(
                                  esc_html__( 'No link', 'keydesign' ) => '#',
                                  esc_html__( 'Button link', 'keydesign' )	=> '1',
                              ),
                             "save_always" => true,
                             "description" => esc_html__("You can add/remove custom link", "keydesign"),
                        ),
                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Button text", "keydesign"),
                            "param_name" => "pss_link_text",
                            "value" => "",
                            "description" => esc_html__("Enter button text here.", "keydesign"),
                            "dependency" => array(
                               "element" => "pss_custom_link",
                               "value"	=> array( "1" ),
                           ),
                        ),
                        array(
                             "type"	=>	"vc_link",
                             "class" =>	"",
                             "heading" => esc_html__("Link settings", "keydesign"),
                             "param_name" => "pss_link",
                             "value" =>	"",
                             "description" => esc_html__("You can add or remove the existing link from here.", "keydesign"),
                             "dependency" => array(
                                "element" => "pss_custom_link",
                                "value"	=> array( "1" ),
                            ),
                        ),
                           array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        ),

                        array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "param_name" => "ib_animation_delay",
                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                        ),


                        array(
                            "type" => "textfield",
                            "class" => "",
                            "heading" => esc_html__("Extra class name", "keydesign"),
                            "param_name" => "pss_extra_class",
                            "value" => "",
                            "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "keydesign")
                        ),


                           array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __( "Button Border Radius", "skylon" ),
            "param_name" => "btn_border_radius",
            "group" => "Button Style",
              "description" => __( "Button border radius. Rounded corners.", "skylon" ),
             "value"       => array(
       
       'Select' => '',
        'Default'   => 'btn-radius-default',
        'Circle'   => 'btn-circle',
        'Square (no-radius)'   => 'btn-square'
        
         ),
        'dependency' => array(
		'element' => 'btn_check',
	         'value' => array('1')
						
          ),
      "std"         => '',
            
         ),
  
        array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Button Custom Color", "emerson" ),
            "param_name" => "btn_color",
            "group" => "Button Style",
            "value" => __( "#fff", "emerson" ),
            "description" => __( " Choose a custom button color.", "emerson" ),
             "dependency" => array(
                               "element" => "pss_custom_link",
                               "value"	=> array( "1" ),
             ),

               						
                ), 
                
             array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Button Custom Hover Color", "emerson" ),
            "param_name" => "btn_hover_color",
            "group" => "Button Style",
            "value" => __( "#fff", "emerson" ),
            "description" => __( " Choose a custom button hover color.", "emerson" ),
            "dependency" => array(
                               "element" => "pss_custom_link",
                               "value"	=> array( "1" ),
             ),
                

               						
                ), 
                
             array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Button Background Color", "emerson" ),
            "param_name" => "btn_bg_color",
            "group" => "Button Style",
            "value" => __( "", "emerson" ),
              "description" => __( " Choose a custom button background color.", "emerson" ),
                            "dependency" => array(
                               "element" => "pss_custom_link",
                               "value"	=> array( "1" ),
               ),

               						
                ), 
            array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Button Background Hover Color", "emerson" ),
            "param_name" => "btn_bg_hover_color",
            "group" => "Button Style",
            "value" => __( "", "emerson" ),
            "description" => __( " Choose a custom button background hover color.", "emerson" ),
            "dependency" => array(
                               "element" => "pss_custom_link",
                               "value"	=> array( "1" ),
             ),

               						
                ), 


              ) ));
}

add_shortcode( 'insignia_process_step', 'insignia_process_step_shortcode' );
function insignia_process_step_shortcode( $atts,$content) {


 extract( shortcode_atts( array(

              'ps_elements' => '',
              'ps_extra_class' => '',
              'pss_border_color' => '',
              'css' => ''

   ), $atts ) );
   
   $css=apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts );

$processid = uniqid('ins-process-main');

$process_main_css = '';


if($pss_border_color != '')
$process_main_css .= '#' . $processid .'.ins-process-steps{border-color: '.$pss_border_color.';}';

if($pss_border_color != '')
$process_main_css .= '#' . $processid . ' .ins-process-item:before {border-color: '.$pss_border_color.';}';


 $output = '
            <div id="'.$processid.'" class="ins-process-steps process-checkbox-template clearfix '.$ps_elements.' '.$ps_extra_class.' '.$css.'">
                <ul class="ins-process-steps-main">'.do_shortcode($content).'</ul>
            </div>';
$output .=	'<script type="text/javascript">
		(function(jQuery) {';

		if($process_main_css != '') {
					$output .= 'jQuery("head").append("<style>'.$process_main_css.'</style>")';
						}

					$output .=	'
					})(jQuery);
						</script>';

    return $output;




}


add_shortcode( 'insignia_process_step_single', 'insignia_process_step_single_shortcode' );
function insignia_process_step_single_shortcode( $atts,$content) {

 extract( shortcode_atts( array(

		'pss_title' => '',
                'pss_title_color' => '',
                'pss_description' => '',
                'pss_description_color' => '',
                'pss_number' => '',
                'pss_number_color' => '',
                'pss_icon_type' => '',
                'icon_iconsmind' => '',
                'pss_icon_color' => '',
                'pss_icon_size' => '',
                'pss_image' => '',
                'pss_custom_link' => '',
                'pss_link_text' => '',
                'pss_link' => '',
        	    'css_animation'  => '',
        	    'ib_animation_delay'=> '',
                'pss_extra_class' => '',
                'btn_color' => '#fff',
                'btn_hover_color' => '#fff',
                'btn_border_radius' => '',
                'btn_bg_color' => '',
                'btn_bg_hover_color' => '',
                'pss_title_size' => ''
   ), $atts ) );


$process_css = '';

$uniqid = uniqid('ins-process-');

if($pss_title_size !=''){
$title_line_height = $pss_title_size + 10;
}


if($btn_color != '')
$process_css .= '#' . $uniqid . ' .ins-image-box-btn {color: '.$btn_color.';}';

if($btn_hover_color != '')
$process_css .= '#' . $uniqid . ' .ins-image-box-btn:hover {color: '.$btn_hover_color.';}';

if($btn_bg_color != '')
$process_css .= '#' . $uniqid . ' .ins-image-box-btn {background: '.$btn_bg_color.';}';

if($btn_bg_hover_color != '')
$process_css .= '#' . $uniqid . ' .ins-image-box-btn:hover {background: '.$btn_bg_hover_color.';}';

if($pss_title_size != '')
$process_css .= '#' . $uniqid . ' .ins-process-title {font-size: '.$pss_title_size.'px; line-height: '. $title_line_height .'px;}';


            if ($pss_icon_color !== '') {
              $icon_color_style = 'color: '.$pss_icon_color.';';
            }

            if ($pss_icon_size !== '') {
              $icon_size_style = 'font-size: '.$pss_icon_size.';';
            }

            $href = vc_build_link($pss_link);
            if ($href['target'] == "") { $href['target'] = "_self"; }

      		
      				$link_target = (isset($href['target'])) ? ' target="'.$href['target'].'"' : 'target="_self"';
      				$link_title = (isset($href['title'])) ? ' title="'.$href['title'].'"' : '';
      	

            if( $pss_icon_type == 'icon_browser' && !empty($icon_iconsmind) ) {
      				$content_icon = '<div class="process-icon"><i class="'.$icon_iconsmind.' pc" style="'.$icon_size_style.' '.$icon_color_style.'"></i></div>';
      			}
      			elseif($pss_icon_type == 'custom_image' && !empty($pss_image)){
      				$ps_img_array = wpb_getImageBySize ( $params = array( 'post_id' => NULL, 'attach_id' => $pss_image, 'thumb_size' => 'full', 'class' => "" ) );
      				$content_icon = '<div class="process-customimg">'.$ps_img_array['thumbnail'].'</div>';
      			}

            // Box custom styles

            
            
              //CSS Animation
            if ($css_animation == "no_animation") {
                $css_animation = "";
            }

 $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay;
            }
            

           
                $output = '<li id="'.$uniqid.'"  class="ins-process-item">';
                   $output .= '<div class="ins-process-container '.$css_animation.' '.$pss_extra_class.'" '.$animation_delay.'>';
                    if($pss_icon_type != 'no_icon') {
                        $output .= '<div class="ins-process-img-area">'.$content_icon.'</div>';
                    }
                      $output .= '<div class="ins-process-step-number"><span class="pc" '.(!empty($pss_number_color) ? 'style="color: '.$pss_number_color.';"' : '').'>'.$pss_number.'</span></div>';

                        $output .= '<div class="ins-process-text-area">
                            <h4 class="ins-process-title margin-15px-bottom" '.(!empty($pss_title_color) ? 'style="color: '.$pss_title_color.';"' : '').'>'.$pss_title.'</h4>
                            <p '.(!empty($pss_description_color) ? 'style="color: '.$pss_description_color.';"' : '').'>'.$pss_description.'</p>';
                            if($pss_custom_link == "1") {
                              $output .= '<a class="ins-image-box-btn title-font pc-bg sc-bg-hover '.$btn_border_radius.'" href="'.$href['url'].'"'.$link_target.''.$link_title.'>'.$pss_link_text.'</a>';
                            }
                        $output .= '</div>
                    </div>
                </li>';
     	$output .=	'<script type="text/javascript">
		(function(jQuery) {';

		if($process_css != '') {
					$output .= 'jQuery("head").append("<style>'.$process_css.'</style>")';
						}

					$output .=	'
					})(jQuery);
						</script>';

    return $output;

}