<?php
/**
 *
 * Service Box VC element by INSIGNIA
 *
 */



/*Service Box Element*/


add_action( 'vc_before_init', 'VC_service_box' );

function VC_service_box() {
  vc_map (

 array(
      "name" => __( "Service Box", "emerson" ),
      "base" => "insignia_service_box",
      "class" => "",
      "category" => __( "Insignia", "emerson"),
	"class" => "font-awesome",
	"icon" => "fa fa-file-image-o",        
       
      "params" => array(

         array(
            "type" => "dropdown",
            "class" => "",
            "heading" => __( "Select Layout", "emerson" ),
            "param_name" => "layout_style",
            "group" => "General",
            "description" => __( "Select Service Box layout you would like to use", "emerson" ),
            "value"       => array(
       
				'Select' => '',
				'Layout 1'   => 'service-box-layout-1',
				'Layout 2'   => 'service-box-layout-2'

		),
		
      "std"         => '',
            
         ),
         
        array(
			"type" => "attach_image",
			"class" => "",
			"heading" => __( "Add Image", "emerson" ),
			"param_name" => "custom_image",
			"group" => "General",
			"value" => '',
			"description" => __( "Select image of your service box.", "emerson" ),
			'dependency' => array(
				'element' =>'layout_style',
				'value' => array('service-box-layout-2')
			 ),  
          ),
      
        array(
            "type" => "textfield",
            "class" => "",
             
            "heading" => __( "Title", "emerson" ),
            "param_name" => "service_title",
            "group" => "General",
            "value" => 'Service Box Title ' ,
           
            "description" => __( "The title of your service box.", "emerson" ),

            ),
            
        array(
            "type" => "vc_link",
            "class" => "",
            "heading" => __( "Service Box Link (url)", "emerson" ),
            "param_name" => "service_link",
            "group" => "General",
            "description" => __( "Service Box link", "emerson" ),
            "value" => __( "", "emerson" ),
            ),
            
            array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("CSS Animation", "keydesign"),
            "group" => "General",
            "param_name" => "css_animation",
            "value" => array(
                    "No"              => "no_animation",
                    "Fade In"         => "ins-animated fadeIn",
                    "Fade In Down"    => "ins-animated fadeInDown",
					"Fade In Left"    => "ins-animated fadeInLeft",
                    "Fade In Right"   => "ins-animated fadeInRight",
                    "Fade In Up"      => "ins-animated fadeInUp",
                    "Zoom In"         => "ins-animated zoomIn",
                         ),
            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        ),

        array(
            "type" => "dropdown",
            "class" => "",
            "heading" => esc_html__("Animation Delay", "keydesign"),
            "group" => "General",
            "param_name" => "ib_animation_delay",
            "value" => array(
                "0 ms"   	 => "",
                "200 ms"     => "200",
                "400 ms"     => "400",
                "600 ms"     => "600",
                "800 ms"     => "800",
                "1 s"        => "1000",
                           ),
            "dependency" =>	array(
                   "element" => "css_animation",
                   "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                      ), 

        array(
            "type" => "textfield",
            "class" => "",
            "heading" => __( "Extra Class Name", "emerson" ),
            "param_name" => "extra_class",
            "group" => "General",
            "value" => __( "", "emerson" ),
             "description" => __( "Style particular content element differently - add a class name and refer to it in custom CSS.", "emerson" )
            
         ),
         

        array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Title Color", "emerson" ),
            "param_name" => "title_color",
            "group" => "Style",
            "value" => __( "", "emerson" ),
            "description" => __( " Choose Title Color.If you leave it empty, It will set default color", "emerson" ),
            'dependency' => array(
				'element' =>'layout_style',
				'value' => array('service-box-layout-1')
			    ),   
             ),

        array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Title Background Color", "emerson" ),
            "param_name" => "title_bg_color",
            "group" => "Style",
            "value" => __( "", "emerson" ),
            "description" => __( " Choose Title Background Color.If you leave it empty, It will set default color", "emerson" ),
            'dependency' => array(
				'element' =>'layout_style',
				'value' => array('service-box-layout-1')
			    ), 
             ),
             
        array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Icon Color", "emerson" ),
            "param_name" => "icon_color",
            "group" => "Style",
            "value" => __( "", "emerson" ),
            "description" => __( " Choose Icon Color.If you leave it empty, It will set default color", "emerson" ),
                       'dependency' => array(
				'element' =>'layout_style',
				'value' => array('service-box-layout-1')
			    ), 
             ),
             
             
        array(
            "type" => "colorpicker",
            "class" => "",
            "edit_field_class" => "vc_col-xs-6 vc_edit_form_elements vc_column-with-padding vc_column",
            "heading" => __( "Icon Background Color", "emerson" ),
            "param_name" => "icon_bg_color",
            "group" => "Style",
            "value" => __( "", "emerson" ),
            "description" => __( " Choose Icon Background Color.If you leave it empty, It will set default color", "emerson" ),
            'dependency' => array(
				'element' =>'layout_style',
				'value' => array('service-box-layout-1')
			    ), 
            ),     

        array(
            'type' => 'css_editor',
            'heading' => __( 'Css', 'citta' ),
            'param_name' => 'css',
            'group' => __( 'Design options', 'citta' ),
         ),
        
     
   ) ));
}

add_shortcode( 'insignia_service_box', 'insignia_service_box_shortcode' );
function insignia_service_box_shortcode( $atts,$content) {

 extract( shortcode_atts( array(
     'service_title' => '',
     'service_link' => '',
     'title_color' => '',
     'title_bg_color' => '',
     'icon_color' => '',
     'icon_bg_color' => '',
     'css_animation'  => '',
     'ib_animation_delay'=> '',
     'extra_class'=>'',
     'css' => '',
     'layout_style' => '',
     'custom_image' => ''

   ), $atts ) );


$service_title1=${'service_title'};
$service_link1=${'service_link'};
$title_color1=${'title_color'};
$title_bg_color1=${'title_bg_color'};
$icon_color1=${'icon_color'};
$icon_bg_color1=${'icon_bg_color'};
$extra_class1=${'extra_class'};
$layout_style1=${'layout_style'};
$custom_image1=${'custom_image'};
$css_animation1=${'css_animation'};
$ib_animation_delay1=${'ib_animation_delay'};
$css1=apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts );

//CSS Animation
            if ($css_animation1 == "no_animation") {
                $css_animation1 = "";
            }

            $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay1) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay1;
            }

$service_link1= vc_build_link($service_link1);

if(!empty($service_link1['target'])) {
    $target= $service_link1['target'];
}else{
   $target= '_self'; 
}

$uniqid = uniqid('ins-service-box');

$css_rules = '';
if($title_color1 != '')
$css_rules .= '#' . $uniqid . ' .service-box-title {color: '.$title_color1.';}';

if($title_bg_color1!= '')
$css_rules .= '#' . $uniqid . ' .service-box-main {background: '.$title_bg_color1.';}';

if($icon_color1!= '')
$css_rules .= '#' . $uniqid . ' .service-box-icon {color: '.$icon_color1.';}';

if($icon_bg_color1!= '')
$css_rules .= '#' . $uniqid . ' .service-box-icon {background: '.$icon_bg_color1.';}';

if($layout_style1== "service-box-layout-2") {

$return="<div id='".$uniqid."' class='service-box-layout-2 ".$extra_class1." ".$css1." ".$css_animation1."' ".$animation_delay.">";

$return.="<a class='service-box-2-link service-box-2-main' href='".$service_link1['url']."' target='".$target."'>";
$return.="<img src='".wp_get_attachment_url($custom_image1,'full')."' alt='service-box'>";
$return.="<div class='service-box-2-inner'>";
$return.="<h6 class='service-box-2-title'>";
$return.=$service_title1;
$return.="<i class='fa fa-angle-right' aria-hidden='true'></i>";
$return.="</h6>";
$return.="</div>";
$return.="</a>";
$return.="</div>";

$return.=	'<script type="text/javascript">
		(function(jQuery) {';

		if($css_rules != '') {
					$return.= 'jQuery("head").append("<style>'.$css_rules.'</style>")';
						}

					$return.=	'
					})(jQuery);
						</script>';
	return $return;					
						

}else{
    
$return="<div id='".$uniqid."' class='ins-service-box-wrapper ".$extra_class1." ".$css1." ".$css_animation1."' ".$animation_delay.">";
$return.="<div class='ins-service-box-inner'>";

$return.="<a class='service-box-link service-box-main' href='".$service_link1['url']."' target='".$target."'>";
if(!empty($service_title1)){
$return.="<span class='service-box-title'>".$service_title1."</span>";
}
$return.="<span class='service-box-icon'><i class='fa fa-arrow-circle-o-right service-box-icon1' aria-hidden='true'></i><i class='fa fa-arrow-circle-o-right service-box-icon2' aria-hidden='true'></i></span>";
$return.="</a>";
$return.="</div>";
$return.="</div>";

$return.=	'<script type="text/javascript">
		(function(jQuery) {';

		if($css_rules != '') {
					$return.= 'jQuery("head").append("<style>'.$css_rules.'</style>")';
						}

					$return.=	'
					})(jQuery);
						</script>';
	return $return;					
						
}


}