<?php
/**
 *
 * Team VC element by INSIGNIA
 *
 */



/*Team Element*/



add_action( 'vc_before_init', 'VC_team' );

function VC_team() {
 
 
 // Social Icons
	
	$team_params_arr = array();
	
	$team_params_arr[] = array(
		"type" => "textfield",
		"class" => "hidden-label",
		"heading" => esc_html__( "Person Name", "emerson" ),
		"param_name" => "name",
		"value" => '',
		"description" => esc_html__( "Full name of the person.", "emerson" ) 
	);
	
	$team_params_arr[] = array(
		"type" => "textfield",
		"class" => "hidden-label",
		"heading" => esc_html__( "Position", "emerson" ),
		"param_name" => "position",
		"value" => '',
		"description" => esc_html__( "Enter person position i.e. Designer.", "emerson" ) 
	);
		
	$team_params_arr[] = array(
		'type' => 'attach_image',
		'heading' => esc_html__( 'Person Image', "emerson" ),
		'param_name' => 'img',
		'value' => '',
		'description' => esc_html__( 'Select a person image.', "emerson" ),
	);
	

        $team_params_arr[] = array(
            "type" => "textfield",
            "class" => "",
             "heading" => __( "Extra Class Name", "emerson" ),
            "param_name" => "extra_class",
            "value" => __( "", "emerson" ),
             "description" => __( "Style particular content element differently - add a class name and refer to it in custom CSS.", "emerson" ),
            
         );

	
	  $team_params_arr[] =array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("CSS Animation", "keydesign"),
                            "param_name" => "css_animation",
                            "value" => array(
                                "No"              => "no_animation",
                                "Fade In"         => "ins-animated fadeIn",
                                "Fade In Down"    => "ins-animated fadeInDown",
                                "Fade In Left"    => "ins-animated fadeInLeft",
                                "Fade In Right"   => "ins-animated fadeInRight",
                                "Fade In Up"      => "ins-animated fadeInUp",
                                "Zoom In"         => "ins-animated zoomIn",
                            ),
                            "description" => esc_html__("Select type of animation for element to be animated when it enters the browsers viewport (Note: works only in modern browsers).", "keydesign"),
                        );

            $team_params_arr[] = array(
                            "type" => "dropdown",
                            "class" => "",
                            "heading" => esc_html__("Animation Delay", "keydesign"),
                            "param_name" => "ib_animation_delay",
                            "value" => array(
                                "0 ms"              => "",
                                "200 ms"            => "200",
                                "400 ms"            => "400",
                                "600 ms"            => "600",
                                "800 ms"            => "800",
                                "1 s"            => "1000",
                            ),
                            "dependency" =>	array(
                                "element" => "css_animation",
                                "value" => array("ins-animated fadeIn", "ins-animated fadeInDown", "ins-animated fadeInLeft", "ins-animated fadeInRight", "ins-animated fadeInUp", "ins-animated zoomIn")
                            ),
                            "description" => esc_html__("Enter animation delay in ms", "keydesign")
                        );

		
	//$social_icons_param = array();
	
	
	$social_icons = ensign_team_social_sites_array();
	
	$icon_key = '';
	
	foreach ( $social_icons as $social_icon_key => $social_icon_name ) {
		
		$icon_key = $social_icon_key;
		
		if ( is_numeric( $social_icon_key ) ) {
			$icon_key = $social_icon_name;
		}
		
		$team_params_arr[] = array(
			"type" => "textfield",
			"heading" => ucfirst( $social_icon_name ),
			"param_name" => $icon_key,
			'group' => __( 'Social Profile', "emerson" ), 

			"description" => ucfirst( $social_icon_name ) . ' social site URL.' 
		);
	}
	
	$team_params_arr[] = array(
		'type' => 'css_editor',
		'heading' => __( 'CSS box', "emerson" ),
		'param_name' => 'css',
		'group' => __( 'Design Options', "emerson" ) 
	);
	
	vc_map ( array(
      "name" => __( "Team Members", "emerson" ),
      "base" => "insignia_team",
      "class" => "",
      "category" => __( "Insignia", "emerson"),
	"class" => "font-awesome",
	"icon" => "fa fa-user",     

       	"params" => $team_params_arr


)

);
	
}

function ensign_team_social_sites_array() {
	$social_sites = array(
		'twitter' => 'Twitter',
		'facebook' => 'Facebook',
		'linkedin' => 'LinkedIn',
		'behance' => 'Behance',
		'codepen' => 'Codepen',
		'bitbucket' => 'Bitbucket',
		'deviantart' => 'Deviant Art',
		'digg' => 'Digg',
		'dribbble' => 'Dribbble',
		'dropbox' => 'Dropbox',
		'flickr' => 'Flickr',
		'git' => 'Git',
		'github' => 'Github',
		'google' => 'Google',
		'google-plus' => 'Google Plus',
		'instagram' => 'Instagram',
		'pinterest' => 'Pinterest',
		'quora' => 'Quora',
		'reddit' => 'Reddit',
		'skype' => 'Skype',
		'snapchat' => 'Snapchat',
		'soundcloud' => 'Soundcloud',
		'stack-exchange' => 'Stack Exchange',
		'stack-overflow' => 'Stack Overflow',
		'spotify' => 'Spotify',
		'steam' => 'Steam',
		'tripadvisor' => 'Trip Advisor',
		'tumblr' => 'Tumblr',
		'twitch' => 'Twitch',
		'vimeo' => 'Vimeo',
		'whatsapp' => 'Whatsapp',
		'yelp' => 'Yelp',
		'youtube' => 'YouTube'
	);
	
	return $social_sites;
}

 
 add_shortcode( 'insignia_team', 'insignia_team_shortcode' );
function insignia_team_shortcode( $atts,$content) {
 extract( shortcode_atts( array(
      
        "name" => '',
		"position" => '',
		"img" => '',
        "css" => '',
        "extra_class" => '',
		"css_animation" => '',
		"ib_animation_delay" =>''
			   
   ), $atts ) );


  
  //CSS Animation
            if ($css_animation == "no_animation") {
                $css_animation = "";
            }

 $animation_delay = "";

            // Animation delay
            if ($ib_animation_delay) {
                $animation_delay = 'data-animation-delay='.$ib_animation_delay;
            }

$uniqid = uniqid('ins-team-main');

// Social Profiles
	
	
// Icons Loop
	
	$icons = '';
	$icon_arr = array( 'facebook', 'twitter', 'google', 'tumblr', 'linkedin', 'vimeo', 'pinterest', 'instagram','dribbble', 'skype','flickr', 'dropbox', 'youtube','mail', 'dribbble', 'soundcloud', 'rss' );


if ( function_exists( 'ensign_social_sites_array' ) ) {
		$icon_arr = ensign_social_sites_array();
	}



foreach( $icon_arr as $icon_name => $icon_title ) {	
		if( array_key_exists( $icon_name, $atts ) ) {			
			$icons .= '<a href="' . $atts[$icon_name] . '" class="social icon-' . $icon_name .  '" target="_blank">';
			$icons .= '<i class="fa fa-' . $icon_name . ' icon-primary"></i>';
			$icons .= '</a>';
		}
	}	

$custom_css = '';
	
	if( function_exists( 'vc_shortcode_custom_css_class' ) ) {
		$custom_css = vc_shortcode_custom_css_class( $css );
	}
	

return '<div id="'.$uniqid.'" class="insignia-team-member-wrapper insignia-team-overlay width-100 '.$custom_css.' '.$extra_class.' '.$css_animation.'" '.$animation_delay.'>
<div class="insignia-team-member-inner position-relative">
<div class="insignia-team-image-wrap position-relative overflow-hidden">
'.wp_get_attachment_image($img,'full').'
<div class="insignia-team-overlay position-absolute width-100 height-100 top-0 left-0">
<div class="insignia-team-content-wrapper width-100 height-100 text-center">
<div class="insignia-team-content-inner padding-30px-all">
<div class="insignia-team-title-wrapper margin-15px-top">

<div class="insignia-team-title margin-0px-bottom title-font font-weight-700 text-white">' . esc_html( $name ) . '</div>
<p class="insignia-team-subtitle text-uppercase text-small text-white">' . esc_html( $position ) . '</p>

</div>

<div class="margin-15px-top ins-social-icons social-icons-small social-icons-colorful icon-colored social-icons-colored social-icons-square social-icons-effect-none icons-align-left ">' . $icons . '</div>

</div></div>
</div>
</div>
</div>
</div>';


}