<?php
function insignia_import_files() {
	return array(
		array(
			'import_file_name'             => 'Import Demo Data',
			'local_import_file'            => trailingslashit( get_template_directory() ) . 'demos/innvoke.xml',
			'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'demos/innvoke.wie',
			'local_import_redux'           => array(
				array(
					'file_path'   => trailingslashit( get_template_directory() ) . 'demos/innvoke.json',
					'option_name' => 'ins_opt',
					),
			),
			'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . '/assets/img/innvoke.jpg',
			'import_notice'              => __( 'After you import this demo, you will have to setup the slider separately.', 'innvoke' ),
		),
		);
}
add_filter( 'pt-ocdi/import_files', 'insignia_import_files' );

if ( ! function_exists( 'insignia_after_import' ) ) :
    function insignia_after_import( $selected_import ) {
          
		if ( 'Import Demo Data' === $selected_import['import_file_name'] ) {
			
			//Import Revolution Slider
			if ( class_exists( 'RevSlider' ) ) {
				$slider_array = array(
					get_template_directory()."/demos/home-1.zip",
					get_template_directory()."/demos/home-3.zip",
					get_template_directory()."/demos/home-4.zip",
				);

				$slider = new RevSlider();
				foreach($slider_array as $filepath){
					$slider->importSliderFromPost(true,true,$filepath);  
				}
			}
		  
		}
		update_option( 'active demo', $selected_import['import_file_name'] );
    }
     
add_action( 'pt-ocdi/after_import', 'insignia_after_import' );
endif;

if ( ! function_exists( 'insignia_after_import_setup' ) ) :
function insignia_after_import_setup() {

	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title( 'Home 1' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'insignia_after_import_setup' );
endif;
?>