<?php
/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */

if (!class_exists('Redux')) {
    return;
}


// This is your option name where all the Redux data is stored.
$opt_name = "ins_opt";

// This line is only for altering the demo. Can be easily removed.
$opt_name = apply_filters('ins_opt/opt_name', $opt_name);

/*
 *
 * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
 *
 */

$sampleHTML = '';
if (file_exists(get_template_directory() . '/InsigniaThemeOptions/InsigniaCustomOptions/info-html.html')) {
    Redux_Functions::initWpFilesystem();
    
    global $wp_filesystem;
    
    $sampleHTML = $wp_filesystem->get_contents(get_template_directory() . '/InsigniaThemeOptions/InsigniaCustomOptions/info-html.html');
}

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version' => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type' => 'menu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true,
    // Show the sections below the admin menu item or not
    'menu_title' => __('Theme Options', 'innvoke'),
    'page_title' => __('Theme Options', 'innvoke'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar' => false,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-portfolio',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    // Show the time the page took to load, etc
    'update_notice' => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    
    // OPTIONAL -> Give you extra features
    'page_priority' => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => '',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.
    
    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    
    'database' => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
    
    // HINTS
    'hints' => array(
        'icon' => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color' => 'lightgray',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'red',
            'shadow' => true,
            'rounded' => false,
            'style' => ''
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right'
        ),
        'tip_effect' => array(
            'show' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'mouseover'
            ),
            'hide' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'click mouseleave'
            )
        )
    )
);

// ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
$args['admin_bar_links'][] = array(
    'id' => 'redux-docs',
    'href' => 'http://docs.reduxframework.com/',
    'title' => __('Documentation', 'innvoke')
);

$args['admin_bar_links'][] = array(
    //'id'    => 'redux-support',
    'href' => 'https://github.com/ReduxFramework/redux-framework/issues',
    'title' => __('Support', 'innvoke')
);

$args['admin_bar_links'][] = array(
    'id' => 'redux-extensions',
    'href' => 'reduxframework.com/extensions',
    'title' => __('Extensions', 'innvoke')
);



// Panel Intro text -> before the form
if (!isset($args['global_variable']) || $args['global_variable'] !== false) {
    if (!empty($args['global_variable'])) {
        $v = $args['global_variable'];
    } else {
        $v = str_replace('-', '_', $args['opt_name']);
    }
    $args['intro_text'] = sprintf(__('<p></p>', 'innvoke'), $v);
} else {
    $args['intro_text'] = __('<p></p>', 'innvoke');
}

// Add content after the form.
$args['footer_text'] = __('<p></p>', 'innvoke');

Redux::setArgs($opt_name, $args);

/*
 * ---> END ARGUMENTS
 */


/*
 * ---> START HELP TABS
 */
$img_uri = get_template_directory_uri() . '/insigniathemeoptions/insigniacustomoptions/';
$tabs    = array(
    array(
        'id' => 'redux-help-tab-1',
        'title' => __('Theme Information 1', 'innvoke'),
        'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'innvoke')
    ),
    array(
        'id' => 'redux-help-tab-2',
        'title' => __('Theme Information 2', 'innvoke'),
        'content' => __('<p>This is the tab content, HTML is allowed.</p>', 'innvoke')
    )
);
Redux::setHelpTab($opt_name, $tabs);

// Set the help sidebar
$content = __('<p>This is the sidebar content, HTML is allowed.</p>', 'innvoke');
Redux::setHelpSidebar($opt_name, $content);


/*
 * <--- END HELP TABS
 */


/*
 *
 * ---> START SECTIONS
 *
 */

/*

As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


*/



// -> START Color Selection
Redux::setSection($opt_name, array(
    'title' => __('General', 'innvoke'),
    'id' => 'color-Color',
    'subsection' => false,
    'fields' => array(
        array(
            'id' => 'default-page-layout',
            'type' => 'select',
            'title' => __('Default Page Layout', 'innvoke'),
            
            'options' => array(
                'full_width' => 'Full Width',
                'left_sidebar' => 'Sidebar-left',
                'right_sidebar' => 'Sidebar-right'
            ),
            'default' => 'full_width'
        ),
        
        array(
            'id' => 'page_content_padding-top',
            'type' => 'spacing',
            'mode' => 'padding',
            'units' => 'px',
            'units_extended' => 'false',
            'left' => false,
            'right' => false,
            'bottom' => false,
            'output' => array(
                '#main-content-wrapper'
            ),
            'title' => esc_html__('Page Top Padding', 'innvoke'),
            'subtitle' => esc_html__('Set a top (between Title Area and Content) padding. In pixels.', 'innvoke'),
            'default' => array(
                'padding-top' => '0',
                'units' => 'px'
            )
        ),
        
        array(
            'id' => 'page_content_padding-bottom',
            'type' => 'spacing',
            'mode' => 'padding',
            'units' => 'px',
            //'display_units' 	=> false,
            'units_extended' => 'false',
            'left' => false,
            'right' => false,
            'top' => false,
            'output' => array(
                '#main-content-wrapper'
            ),
            'title' => esc_html__('Page Bottom Padding', 'innvoke'),
            'subtitle' => esc_html__('Set a bottom (between Content and Footer) padding. In pixels.', 'innvoke'),
            'default' => array(
                'padding-bottom' => '80',
                'units' => 'px'
            )
        ),
        
        array(
            'id' => 'ins-opt-back-to-top',
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'title' => __('Back to top button', 'innvoke'),
            'default' => 'true'
        ),
        
        array(
            'id' => 'page_loader',
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'title' => esc_html__('Page Loader', 'innvoke'),
            'subtitle' => esc_html__('Enable a page loading effect. You may adjust page laoder styling in Styling menu.', 'innvoke'),
            'default' => true
        ),
        
        array(
            'id' => 'page_type',
            'type' => 'button_set',
            'title' => esc_html__('Website Type', 'innvoke'),
            'options' => array(
                "regular" => esc_html__("Regular", 'innvoke'),
                "one_pager" => esc_html__("One Pager", 'innvoke')
            ),
            'default' => 'regular'
        )
    )
));

/*********
 ***LOGO***
 **********/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Logo', 'innvoke'),
    'id' => 'logo',
    'desc' => esc_html__('Website Logo Settings.', 'innvoke'),
    'icon' => 'el el-eye-open',
    'fields' => array(
        
        array(
            'id' => 'ins-logo-style',
            'type' => 'select',
            'title' => esc_html__('Logo style', 'innvoke'),
            'options' => array(
                '1' => 'Image logo',
                '2' => 'Text logo'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'site_logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Logo Image - Normal', 'innvoke'),
            'subtitle' => esc_html__("Choose a default logo image to display", 'innvoke'),
            'default' => array(
                'url' => get_template_directory_uri() . '/assets/img/logo-dark.png'
            ),
            'required' => array(
                'ins-logo-style',
                'equals',
                '1'
            )
        ),
        array(
            'id' => 'site_logo_white',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Logo Image - Light', 'innvoke'),
            'subtitle' => esc_html__('Choose a logo image to display for "Dark" header skin.', 'innvoke'),
            'default' => array(
                'url' => get_template_directory_uri() . '/assets/img/logo-light.png'
            ),
            'required' => array(
                'ins-logo-style',
                'equals',
                '1'
            )
        ),
        array(
            'id' => 'logo_mobile',
            'type' => 'media',
            'url' => false,
            'title' => esc_html__('Logo Image for Mobile', 'innvoke'),
            'subtitle' => esc_html__("Optional: logo to be displayed on mobile devices.", 'innvoke'),
            'default' => '',
            'required' => array(
                'ins-logo-style',
                'equals',
                '1'
            )
        ),
        
        array(
            'id' => 'ins-text-logo',
            'type' => 'text',
            'title' => esc_html__('Text logo', 'innvoke'),
            'required' => array(
                'ins-logo-style',
                'equals',
                '2'
            ),
            'default' => 'Innvoke'
        ),
        array(
            'id' => 'ins-text-logo-typo',
            'type' => 'typography',
            'title' => esc_html__('Text logo font settings', 'innvoke'),
            'required' => array(
                'ins-logo-style',
                'equals',
                '2'
            ),
            'output' => ('#logo .ins-text-logo'),
            'google' => true,
            'font-family' => true,
            'font-style' => true,
            'font-size' => true,
            'letter-spacing' => true,
            'text-transform' => true,
            'line-height' => false,
            'color' => false,
            'text-align' => false,
            'all_styles' => false,
            'units' => 'px',
            'default' => array(
                'font-family' => 'Cabin',
                'font-weight' => '800',
                'letter-spacing' => '3px',
                'text-transform' => 'uppercase'
                
                
            )
        ),
        array(
            'id' => 'ins-normal-logo-color',
            'type' => 'color',
            'transparent' => false,
            'output' => array(
                'color' => '#logo .ins-text-logo'
            ),
            'title' => esc_html__('Choose a default logo text color', 'innvoke'),
            'required' => array(
                'ins-logo-style',
                'equals',
                '2'
            ),
            'default' => '#223645',
            'validate' => 'color'
        ),
        array(
            'id' => 'ins-light-logo-color',
            'type' => 'color',
            'transparent' => false,
            'output' => array(
                'color' => '.header-dark #logo .ins-text-logo'
            ),
            'title' => esc_html__('logo text color - Light', 'innvoke'),
            'subtitle' => esc_html__('Choose a logo text color for "Dark" header skin.', 'innvoke'),
            'required' => array(
                'ins-logo-style',
                'equals',
                '2'
            ),
            'default' => '#e8e8e8',
            'validate' => 'color'
        ),
        
        array(
            'id' => 'insignia-favicon',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Favicon', 'innvoke'),
            'subtitle' => esc_html__("Choose a favicon image to be displayed", 'innvoke'),
            'default' => array(
                'url' => get_template_directory_uri() . '/assets/img/favicon.png'
            )
        ),
        
        array(
            'id' => 'logo_height',
            'type' => 'text',
            'title' => esc_html__('Logo Height', 'innvoke'),
            'subtitle' => esc_html__('Height of the logo image in pixel (example: 30).', 'innvoke'),
            'default' => '',
            'class' => 'textfield-tiny pixel-field',
            'required' => array(
                'ins-logo-style',
                'equals',
                '1'
            ),
            'default' => '35'
        )
    )
));



/************
 ***Styling***
 *************/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Styling', 'innvoke'),
    'id' => 'styling',
    'icon' => 'el-icon-brush',
    'fields' => array(
        
        array(
            'id' => 'styling-main',
            'type' => 'info',
            'desc' => __('General', 'innvoke')
        ),
        
        array(
            'id' => 'ins-opt-pc',
            'type' => 'color',
            'output' => array(
                'background-color' => '.pc-bg, .inv-post-grid-one-btn-inner, .main-menu ul li:not(.mega-menu) ul.sub-menu li:hover>a:before, input[type="radio"]:after, input[type="checkbox"]:after, .slick-dots li.slick-active button:before, .inv-post-grid-one-btn-inner, .ins-icon-box-btn-wrap:hover:after, .blog-carousel-element .slick-arrow:hover, .inv-portfolio-carousel-slider .slick-arrow:hover, .main-menu ul.sub-menu li:hover>a:before, .inv-post-cat-main>a, .ins-image-box-btn-main .ins-image-box-btn:hover, .service-box-link.service-box-main, .post-categories.post-classic-category a:hover, .business-info-wrapper, .default-post-grid-category a:hover, span.wpcf7-not-valid-tip, .scroll-to-top,.ins-custom-menu-wrapper ul li.current-menu-item a:before, .ins-custom-menu-wrapper ul li a:before, .pricing-box-button, .ins_solid_button.btn_primary_color, .pricing-style-1.pricing-box-featured .insignia-pricing-box-header, .ins-modal-wrapper .close, .ins-team-popup-wrapper .close, .ins-feature-box-inner:hover .ins-feature-box-button, .nav-tools .woo-cart-count, .tagcloud a:hover, .vc_tta-style-insignia_tab_layout1 ul li.vc_tta-tab.vc_active a:before, nav#pagination ul li .current, .ins-table-wrapper.ins-table-style-3 tr th, .woocommerce a.button.alt:hover, .woocommerce #review_form #respond .form-submit input:hover, .inv-product-hover:hover span.onsale, .sub-menu.minicart .button:hover, .sub-menu.minicart .button, .vc_tta-style-insignia_accordion_layout3 .vc_tta-panel.vc_active h4.vc_tta-panel-title,.woocommerce button.button.alt, .woocommerce button.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover, .woocommerce ul.products li.product .added_to_cart:hover, .woocommerce ul.products li.product .added_to_cart, .woocommerce a.button:hover,.woocommerce a.button, .ins-add-to-cart-button, #pagination .current a, .woocommerce a.button.alt, .woocommerce-MyAccount-content .address a, .pricing-border-button.pricing-bg-button, .pricing-pics-box.pricing-pics-bg-box,input[type="submit"], p.return-to-shop a.button.wc-backward, .woocommerce-Message.woocommerce-Message--info.woocommerce-info a, input.woocommerce-Button.button, li.woocommerce-MyAccount-navigation-link.is-active, p.form-row input.button.login-btn, a.button.checkout.wc-forward:hover, p.form-row.form-row-last .button, .woocomerce-form .form-row input.button, button.checkout.wc-forward:hover, a.button.view_cart_btn.wc-forward, .woocommerce span.onsale, .about-call-to-action, .about-progress-bar .vc_bar, .apt-clients-details-box h2:after, .about-two-working-box h1:after, .apt-features-text-box h5:after, .service-btn>a:hover, .service-3-btn>a:hover, input.contactus-1-btn, input.contactus-2-btn, ul.c-2-social>li>a:hover, .ins-services-right .ins-services-text:after, .ins-choose-us-section .ins-choose-us-heading:after, .woocommerce button.button, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce #review_form #respond .form-submit input,.woocommerce div.product form.cart .button , .insignia-button, input.button.size-lg,a.checkout-button.button.icon_right.size-lg.alt.wc-forward, input#place_order, .form-row input.woocommerce-Button.button,.hc-button, .inv-portfolio-filter-button-inner.inv-portfolio-filter-button_solid_bg.active-filter-button, #wrapper .color-scheme-white .inv-portfolio-filter-button-inner.inv-portfolio-filter-button_solid_bg.active-filter-button,  .insignia-testimonial-carousel .slick-arrow:hover',
                'color' => 'p a, ul.blog-meta.ins-single-post-meta li a:hover, .pricing-style-1 .insignia-pricing-box-header .price, .pricing-style-1 .insignia-pricing-box-header .period, .ins-process-step-number span, .woocommerce-message::before, .post-categories.post-classic-category a, .ins-counter-icon, .ins-float-icon-inner i, .ins-float-right-icon-inner i, .ins-icon-box-icon i, .ins-list-style .ins-icon-list-icon, .default-post-grid-category a, .ins-custom-menu-wrapper ul li a:hover,.ins-custom-menu-wrapper ul li.current-menu-item a, .ins_outline_button.btn_primary_color, .vc_tta-style-insignia_tab_layout1 li.vc_tta-tab.vc_active a span, .woocommerce div.product .out-of-stock, .pc,.woocommerce a.remove, span.price del+ins, .pc-hover:hover, .inv-portfolio-filter-button-inner.inv-portfolio-filter-button_bordered.active-filter-button, #wrapper .color-scheme-white .inv-portfolio-filter-button-inner.inv-portfolio-filter-button_bordered.active-filter-button, button.inv-portfolio-filter-button-inner.inv-portfolio-filter-button_simple.active-filter-button, #wrapper .color-scheme-white button.inv-portfolio-filter-button-inner.inv-portfolio-filter-button_simple.active-filter-button, .blog-full-thumb-cat-holder .white-color a:hover, form.woocommerce-EditAccountForm.edit-account legend,#customer_login a.lost_password.woo-lost_password2,.lost_password a,.woocommerce-info a.showlogin,.woocommerce-info a.showcoupon,a.button.view_cart_btn.wc-forward:hover,.woocommerce a.remove, .ins_cart_content p.total, .ins_cart_content p.buttons a, span.sp-social-icon-bottom:hover, .ins-faq-num, .nav-tabs>li.active>a , .nav-tabs>li.active>a:focus, .nav-tabs>li.active>a:hover, .woocommerce .widget_shopping_cart .total strong,.woocommerce.widget_shopping_cart .total strong,  ul.product-categories li a:hover, .woocommerce .star-rating span:before,.blog-top-box ul li a:hover,.reply.comment-reply-link.ins_comment_rpl a,.comment-form-message a,.comment-reply-title a, .post-nav-grid-wrapper .post-nav-grid-icon, .tags-single-post-icon-wrapper .tags-single-post-icon, .blog-widget-area aside ul li a:hover, .sidebar-shop-page aside ul li .product-title:hover, .sidebar-shop-page aside ul li a:hover, .after-blog-post .logged-in-as a',
                'border-color' => '.pc-border, input[type="checkbox"]:checked:before, input[type="radio"]:checked:before, .ins-image-box-btn-main .ins-image-box-btn:hover, .ins-process-item:before, .ins-process-steps, .woocommerce-message, .post-categories.post-classic-category a:hover, .post-categories.post-classic-category a, .default-post-grid-category a:hover, .default-post-grid-category a, .sub-menu.minicart .button:hover, .ins_solid_button.btn_primary_color, .ins_outline_button.btn_primary_color, .ins-feature-box-inner:hover .ins-feature-box-button, .insignia-testimonial-carousel .slick-arrow:hover, span.wpcf7-not-valid-tip'
            ),
            'title' => __('Primary color', 'innvoke'),
            'subtitle' => __('Pick a Primary color for the theme.', 'innvoke'),
            'default' => '#36ab9c'
        ),
        array(
            'id' => 'ins-opt-sc',
            'type' => 'color',
            'output' => array(
                'background-color' => '.sc-bg, .sc-bg-hover:hover, .ins_solid_button.btn_secondary_color, .entry-content .tparrows.gyges:hover, .woocomerce-form .form-row input.button:hover, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, input#place_order:hover,.form-row input.woocommerce-Button.button:hover, .hc-button:hover, nav.header-six.header-six-sticky-menu.fixed-menu,.header-six-sticky-menu.fixed-menu .header-six-right, .inv-portfolio-filter-button-inner.inv-portfolio-filter-button_solid_bg',
                'color' => '.sc,nav.woocommerce-MyAccount-navigation ul li a, .ins_outline_button.btn_secondary_color, #calendar_wrap th, #wp-calendar #prev a:hover::after, #wp-calendar #next a:hover::after, .navigation li a, .navigation li a:hover, .navigation li.active a, .navigation li.disabled, ul.product_list_widget .product-title, ul.product-categories li a, inv-portfolio-filter-button-inner.inv-portfolio-filter-button_simple, .button-read-more-holder .button-read-more:hover, .inv-blog-grid-6-button a:hover, .fl-contact-social-box ul li .fl-social-icon:hover, .lawyer-right-icon-box:hover .lawyer-right-icon, .blog-widget-area ul li a, .events-list-main-nav li.tribe-events-nav-next a:before, .events-list-main-nav li.tribe-events-nav-next a:after, .roofing-servings-wrapper span.roofing-servings',
                'border-color' => '.sc-border, .navigation li a:hover,  .ins_solid_button.btn_secondary_color, .ins_outline_button.btn_secondary_color, .navigation li.active a,.comments-title,.comment-reply-title.header-six-sticky-menu.fixed-menu .header-six-right:before, .da-counter-inner:hover, .event-button-holder .event-button-bg, .event-button-holder .event-button-bg-small',
                'border-bottom-color' => '.button-read-more-holder .button-read-more:hover'
            ),
            'title' => __('Secondary color', 'innvoke'),
            'subtitle' => __('Pick a Secondary color for the theme.', 'innvoke'),
            'default' => '#223645'
        ),
        
        array(
            'id' => 'ins-opt-body-background',
            'type' => 'background',
            'output' => array(
                'body, #wrapper'
            ),
            'title' => __('Body Background', 'innvoke'),
            'subtitle' => __('Pick Body background color.', 'innvoke'),
            'default' => array(
                'background-color' => '#fff'
            )
            
        ),
        
        array(
            'id' => 'styling-links',
            'type' => 'info',
            'desc' => __('Links', 'innvoke')
        ),
        
        array(
            'id' => 'color_link',
            'type' => 'link_color',
            'title' => __('Link Color', 'innvoke'),
            'output' => ('a'),
            'visited' => false,
            'active' => false,
            'default' => array(
                'regular' => '#223645',
                'hover' => '#36ab9c'
            )
        ),
        
        array(
            'id' => 'styling-widget',
            'type' => 'info',
            'desc' => __('Sidebar Widget Styling', 'innvoke')
        ),
        
        array(
            'id' => 'widget-title-typography',
            'type' => 'typography',
            'title' => __('Widget title typography', 'innvoke'),
            'subtitle' => __('Specify the Widget title properties.', 'innvoke'),
            'google' => true,
            "text-align" => false,
            "line-height" => true,
            "font-style" => true,
            "color" => true,
            "font-family" => true,
            "letter-spacing" => true,
            "text-transform" => true,
            'output' => array(
                '.sidebar-wrapper > .widget .widget-title, .wpb_content_element > .widget .widgettitle'
            ),
            'units' => 'px',
            'default' => array(
                'color' => '#223645',
                'font-size' => '18px',
                'font-weight' => '600',
                'line-height' => '26px',
                'letter-spacing' => '1px'
            )
        ),
        
        array(
            'id' => 'widget_color_link',
            'type' => 'link_color',
            'title' => __('Sidebar Widget Link Color', 'innvoke'),
            'output' => ('.sidebar-wrapper a'),
            'visited' => false,
            'active' => false,
            'default' => array(
                'regular' => '#223645',
                'hover' => '#36ab9c'
            )
        )
        
    )
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Page Loader', 'innvoke'),
    'desc' => esc_html__('Styling of the Page Loader.', 'innvoke'),
    'id' => 'styling_ploader',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'loader_color1',
            'type' => 'color',
            'title' => esc_html__('Page Loader Spinner Color 1', 'innvoke'),
            'subtitle' => esc_html__('Color of the spinner moving element.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => array(
                'border-top-color' => '.page-loader-wrapper .page-loader'
            )
        ),
        array(
            'id' => 'loader_color2',
            'type' => 'color',
            'title' => esc_html__('Page Loader Spinner Color 2', 'innvoke'),
            'subtitle' => esc_html__('Color of the spinner ring.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => array(
                'border-left-color' => '.page-loader-wrapper .page-loader',
                'border-right-color' => '.page-loader-wrapper .page-loader',
                'border-bottom-color' => '.page-loader-wrapper .page-loader'
            )
        ),
        array(
            'id' => 'loader_bg',
            'type' => 'color',
            'title' => esc_html__('Page Loader Background', 'innvoke'),
            'subtitle' => esc_html__('Background color of the page loader.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => array(
                'background-color' => '.page-loader-wrapper'
            )
        ),
        array(
            'id' => 'loader_size',
            'type' => 'dimensions',
            'title' => esc_html__('Page Loader Size', 'innvoke'),
            'subtitle' => esc_html__('Enter diameter of the page loader spinner. Make sure to enter same values height and width. Default: 50px.', 'innvoke'),
            'default' => '',
            'units' => 'px',
            'output' => array(
                '.page-loader-wrapper .page-loader'
            )
        )
        
    )
    
));

/**
 *
 *Typography
 *
 **/


// -> START Typography
Redux::setSection($opt_name, array(
    'title' => __('Typography', 'innvoke'),
    'id' => 'typography',
    'icon' => 'el el-font',
    'fields' => array(
        array(
            'id' => 'ins-opt-typography-body',
            'type' => 'typography',
            'title' => __('text', 'innvoke'),
            'subtitle' => __('Specify the body font properties.', 'innvoke'),
            'google' => true,
            'font-backup' => true,
            'output' => array(
                'p',
                'font-family' => 'body'
            ),
            'units' => 'px',
            'letter-spacing' => true,
            'default' => array(
                'color' => '#6f6f6f',
                'font-size' => '14px',
                'font-family' => 'Cabin',
                'font-weight' => '400',
                'letter-spacing' => '',
                'google' => true,
                'line-height' => '25px'
            )
        ),
        array(
            'id' => 'ins-opt-typography-title',
            'type' => 'typography',
            'title' => __('Title Font-Family', 'innvoke'),
            'subtitle' => __('Specify the title font family', 'innvoke'),
            'font-backup' => true,
            'all_styles' => true,
            'output' => array(
                '.title-font, .tag-cloud-link'
            ),
            'units' => 'px',
            'text-transform' => false,
            'letter-spacing' => false,
            'font-style' => false,
            'font-size' => false,
            'line-height' => false,
            'text-transform' => false,
            'text-align' => false,
            'color' => false,
            'color' => false,
            'subsets' => false,
            'font-weight' => false,
            'font-backup' => false,
            'default' => array(
                'font-family' => 'Cabin'
            )
        ),
        array(
            'id' => 'ins-opt-typography-h1',
            'type' => 'typography',
            'title' => __('h1', 'innvoke'),
            'subtitle' => __('Specify the h1 tag title font properties.', 'innvoke'),
            'font-backup' => true,
            'all_styles' => true,
            'output' => array(
                'h1',
                '.inv-title-h1'
            ),
            'units' => 'px',
            'text-transform' => true,
            'letter-spacing' => true,
            'default' => array(
                'color' => '#223645',
                'font-weight' => '800',
                'font-family' => 'Cabin',
                'google' => true,
                'font-size' => '40px',
                'letter-spacing' => '1px',
                'line-height' => '54px'
            )
        ),
        array(
            'id' => 'ins-opt-typography-h2',
            'type' => 'typography',
            'title' => __('h2', 'innvoke'),
            'subtitle' => __('Specify the h2 tag title font properties.', 'innvoke'),
            'font-backup' => true,
            'all_styles' => true,
            'text-transform' => true,
            'output' => array(
                'h2',
                '.inv-title-h2'
            ),
            'units' => 'px',
            'letter-spacing' => true,
            'default' => array(
                'color' => '#223645',
                'font-weight' => '700',
                'font-family' => 'Cabin',
                'google' => true,
                'font-size' => '35px',
                'letter-spacing' => '1px',
                'line-height' => '48px'
            )
        ),
        array(
            'id' => 'ins-opt-typography-h3',
            'type' => 'typography',
            'title' => __('h3', 'innvoke'),
            'subtitle' => __('Specify the h3 tag title font properties.', 'innvoke'),
            'font-backup' => true,
            'all_styles' => true,
            'text-transform' => true,
            'output' => array(
                'h3',
                '.inv-title-h3'
            ),
            'units' => 'px',
            'letter-spacing' => true,
            'default' => array(
                'color' => '#223645',
                'font-weight' => '700',
                'font-family' => 'Cabin',
                'google' => true,
                'font-size' => '30px',
                'letter-spacing' => '0.5px',
                'line-height' => '40px'
            )
        ),
        array(
            'id' => 'ins-opt-typography-h4',
            'type' => 'typography',
            'title' => __('h4', 'innvoke'),
            'subtitle' => __('Specify the h4 tag font properties.', 'innvoke'),
            'font-backup' => true,
            'all_styles' => true,
            'text-transform' => true,
            'output' => array(
                'h4',
                '.inv-title-h4'
            ),
            'units' => 'px',
            'letter-spacing' => true,
            
            'default' => array(
                'color' => '#223645',
                'font-weight' => '600',
                'font-family' => 'Cabin',
                'google' => true,
                'font-size' => '25px',
                'letter-spacing' => '1px',
                'line-height' => '37px'
            )
        ),
        array(
            'id' => 'ins-opt-typography-h5',
            'type' => 'typography',
            'title' => __('h5', 'innvoke'),
            'subtitle' => __('Specify the h5 tag font properties.', 'innvoke'),
            'font-backup' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array(
                'h5',
                '.inv-title-h5'
            ),
            'units' => 'px',
            'letter-spacing' => true,
            'default' => array(
                'color' => '#223645',
                'font-weight' => '600',
                'font-family' => 'Cabin',
                'google' => true,
                'font-size' => '20px',
                'letter-spacing' => '1px',
                'line-height' => '30px'
            )
        ),
        array(
            'id' => 'ins-opt-typography-h6',
            'type' => 'typography',
            'title' => __('h6', 'innvoke'),
            'subtitle' => __('Specify the h6 Tag font properties.', 'innvoke'),
            'font-backup' => true,
            'text-transform' => true,
            'all_styles' => true,
            'output' => array(
                'h6',
                '.inv-title-h6'
            ),
            'units' => 'px',
            'letter-spacing' => true,
            'default' => array(
                'color' => '#223645',
                'font-weight' => '600',
                'font-family' => 'Cabin',
                'google' => true,
                'font-size' => '18px',
                'letter-spacing' => '0.5px',
                'line-height' => '30px'
            )
        )
    )
));


/**
 *
 *Navigation
 *
 **/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Header', 'innvoke'),
    'id' => 'header',
    'icon' => 'el el-lines'
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Header General', 'innvoke'),
    'id' => 'header_general',
    'subsection' => true,
    'desc' => esc_html__('Header Settings.', 'innvoke'),
    'fields' => array(
        
        array(
            'id' => 'header_skin',
            'type' => 'button_set',
            'title' => esc_html__('Header Skin', 'innvoke'),
            'subtitle' => esc_html__('Choose a skin for your Header.', 'innvoke'),
            'options' => array(
                "light" => esc_html__("Light", 'innvoke'),
                "dark" => esc_html__("Dark - white font color", 'innvoke')
            ),
            'default' => 'light',
        ),
        
        array(
            'id' => 'header_scroll_skin',
            'type' => 'button_set',
            'title' => esc_html__('Header Scroll Skin', 'innvoke'),
            'subtitle' => esc_html__('Choose a skin for your Header after scroll.', 'innvoke'),
            'options' => array(
                "same" => "Same as initial skin",
                "light" => "Light",
                "dark" => "Dark"
            ),
            'default' => 'same',
        ),
        
        array(
            'id' => 'header_color',
            'type' => 'color_rgba',
            'output' => array(
                'background-color' => '#main-navigation'
            ),
            'title' => __('Header background color', 'innvoke'),
            'subtitle' => __('Background color of your site header.', 'innvoke'),
            'default' => array(
                'color' => '#fff',
                'alpha' => 1
            )
        ),
        
        array(
            'id' => 'nav_light_color',
            'type' => 'link_color',
            'title' => esc_html__('Nav Items Color', 'innvoke'),
            'subtitle' => esc_html__('Color of the navigation items.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'visited' => false,
            'active' => false,
            'output' => '.header-light #main-menu > ul > li > a,.header-light .main-menu > ul > li > a'
        ),
        
        array(
            'id' => 'header_search',
            'type' => 'switch',
            'title' => esc_html__('Header Search', 'innvoke'),
            'subtitle' => esc_html__('Enable/Disable the Search field in Header.', 'innvoke'),
            'default' => true
        ),
        
        
        
        array(
            'id' => 'header-styling-start',
            'type' => 'section',
            'title' => esc_html__('Advanced Header Styling', 'innvoke'),
            'indent' => true
        ),
        
        array(
            'id' => 'header_container',
            'type' => 'button_set',
            'title' => esc_html__('Header Container', 'innvoke'),
            'subtitle' => esc_html__('Choose your header\'s container width. Fullwidth = stretched to browser window size.', 'innvoke'),
            'options' => array(
                'boxed' => esc_html__('Boxed', 'innvoke'),
                'fullwidth' => esc_html__('Fullwidth', 'innvoke')
            ),
            'default' => 'boxed'
        ),
        
        
        array(
            'id' => 'header_height',
            'type' => 'slider',
            'title' => __('Header Initial Height', 'innvoke'),
            'subtitle' => __('Height of the header in initial state, in pixels.', 'innvoke'),
            "default" => 80,
            "min" => 0,
            "step" => 1,
            "max" => 200,
            'display_value' => 'text'
        ),
        
        array(
            'id' => 'header_scroll_height',
            'type' => 'slider',
            'title' => __('Header Scroll Height', 'innvoke'),
            'subtitle' => __('Height of the header after scroll, in pixels.', 'innvoke'),
            'required' => array(
                array(
                    'header_sticky',
                    'equals',
                    array(
                        "sticky"
                    )
                )
            ),
            "default" => 80,
            "min" => 0,
            "step" => 1,
            "max" => 200,
            'display_value' => 'text'
        ),
        
        array(
            'id' => 'nav_typo',
            'type' => 'typography',
            'title' => __('Menu titles Typography', 'innvoke'),
            'subtitle' => __('Specify the Menu titles font properties.', 'innvoke'),
            'output' => array(
                "#main-menu > ul > li > a,.main-menu > ul > li > a"
            ),
            'units' => 'px',
            'color' => false,
            'text-align' => false,
            'letter-spacing' => true,
            'text-transform' => true,
            'default' => array(
                'font-size' => '15px',
                'font-family' => 'Cabin',
                'font-weight' => '500',
                'line-height' => '25px',
                'letter-spacing' => '1px',
                'text-transform' => 'none'
            )
        ),
        
        
        array(
            'id' => 'nav_light_color',
            'type' => 'link_color',
            'title' => esc_html__('Light Skin Nav Items Color', 'innvoke'),
            'subtitle' => esc_html__('Color of the navigation items in the light header skin.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'visited' => false,
            'active' => false,
            'output' => '.header-light #main-menu > ul > li > a,.header-light .main-menu > ul > li > a, .header-light .nav-tools .tools-btn-icon',
            'default' => array(
                'regular' => '#000000',
                'hover' => '#7a7a7a'
            )
        ),
        array(
            'id' => 'nav_light_active',
            'type' => 'color',
            'title' => esc_html__('Light Skin Active Item', 'innvoke'),
            'subtitle' => esc_html__('Color of active navigation item in the light header skin.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => '.header-light #main-menu > ul > li.current-page-ancestor > a, .header-light #main-menu > ul > li.current-page-parent > a, .header-light #main-menu > ul > li.current-menu-ancestor > a, .header-light #main-menu > ul > li.current_page_ancestor > a, .header-light #main-menu > ul > li.current_page_item > a, .header-light #main-navigation #main-menu>ul>li.current>a, .header-light #main-navigation .main-menu>ul>li.current>a, .header-light #main-navigation .main-menu>ul>li>.mPS2id-highlight'
        ),
        array(
            'id' => 'nav_light_active_bg',
            'type' => 'color',
            'title' => esc_html__('Light Skin Active Item BG', 'innvoke'),
            'subtitle' => esc_html__('Background color of active navigation item in the light header skin.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => array(
                'background-color' => '.header-light .main-menu > ul > li.current-page-ancestor > a, .header-light .main-menu > ul > li.current-page-parent > a, .header-light .main-menu > ul > li.current-menu-ancestor > a, .header-light .main-menu > ul > li.current_page_ancestor > a, .header-light .main-menu > ul > li.current_page_item > a'
            )
        ),
        array(
            'id' => 'nav_dark_color',
            'type' => 'link_color',
            'title' => esc_html__('Dark Skin Nav Items Color', 'innvoke'),
            'subtitle' => esc_html__('Color of the navigation items in the dark header skin.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'visited' => false,
            'active' => false,
            'output' => '.header-dark #main-menu > ul > li > a,.header-dark .main-menu > ul > li > a, .header-dark .nav-tools .tools-btn-icon'
        ),
        array(
            'id' => 'nav_dark_active',
            'type' => 'color',
            'title' => esc_html__('Dark Skin Active Item', 'innvoke'),
            'subtitle' => esc_html__('Color of active navigation item in the dark header skin.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => '.header-dark #main-menu > ul > li.current-page-ancestor > a, .header-dark #main-menu > ul > li.current-page-parent > a, .header-dark #main-menu > ul > li.current-menu-ancestor > a, .header-dark #main-menu > ul > li.current_page_ancestor > a, .header-dark #main-menu > ul > li.current_page_item > a,#wrapper.header-transparent .header-dark #main-navigation #main-menu>ul>li.current>a,#wrapper.header-transparent .header-dark #sticky-nav #main-menu>ul>li.current>a,.header-dark #main-navigation #main-menu>ul>li.current>a, .header-dark #main-navigation .main-menu>ul>li.current>a, .header-dark #main-navigation .main-menu>ul>li>.mPS2id-highlight'
        ),
        array(
            'id' => 'nav_dark_active_bg',
            'type' => 'color_rgba',
            'title' => esc_html__('Dark Skin Active Item BG', 'innvoke'),
            'subtitle' => esc_html__('Background color of active navigation item in the dark header skin.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => array(
                'background-color' => '.header-dark #main-menu > ul > li.current-page-ancestor > a, .header-dark #main-menu > ul > li.current-page-parent > a, .header-dark #main-menu > ul > li.current-menu-ancestor > a, .header-dark #main-menu > ul > li.current_page_ancestor > a, .header-dark #main-menu > ul > li.current_page_item > a'
            )
        ),
        
        array(
            'id' => 'nav_spacing',
            'type' => 'spacing',
            'title' => esc_html__('Navigation Elements Spacing', 'innvoke'),
            'subtitle' => esc_html__('Specify the left and right padding for navigation elements.', 'innvoke'),
            'default' => '',
            'top' => false,
            'bottom' => false,
            'display-units' => false,
            'units' => array(
                'px'
            ),
            'output' => array(
                '#main-menu > ul > li > a,.main-menu > ul > li > a'
            )
        ),
        
        
        array(
            'id' => 'header_logo_menu_separator_border',
            'type' => 'border',
            'title' => esc_html__('Logo and Menu separator Border', 'innvoke'),
            'subtitle' => esc_html__('Logo and Menu separator Border styling', 'innvoke'),
            'default' => '',
            'left' => false,
            'right' => false,
            'bottom' => false,
            'top' => true,
            'all' => false,
            'output' => array(
                '.bottom-nav-wrapper'
            ),
            'class' => 'third-level',
        ),
        
        
        array(
            'id' => 'header_separator',
            'type' => 'button_set',
            'title' => __('Header Separator', 'innvoke'),
            'subtitle' => __('Choose a default header Separator i.e. Shadow below header', 'innvoke'),
            'options' => array(
                'shadow' => esc_html__('Shadow', 'innvoke'),
                'border' => esc_html__('Border', 'innvoke'),
                'none' => esc_html__('None', 'innvoke')
            ),
            'default' => 'shadow'
        ),
        
        array(
            'id' => 'header_separator_border',
            'type' => 'border',
            'title' => esc_html__('Header Separator Border', 'innvoke'),
            'subtitle' => esc_html__('Specify the bottom border of Header Separator.', 'innvoke'),
            'default' => '',
            'left' => false,
            'right' => false,
            'top' => false,
            'all' => false,
            'output' => array(
                '#header.header-separator-border, .header-separator-border .main-nav.sticky-nav, #wrapper.header-sticky-now #header.header-separator-border.header-scroll-light'
            ),
            'required' => array(
                array(
                    'header_separator',
                    'equals',
                    array(
                        "",
                        "border"
                    )
                )
            )
        ),
        
        array(
            'id' => 'header_separator_border',
            'type' => 'border',
            'title' => esc_html__('Header Border', 'innvoke'),
            'subtitle' => esc_html__('Header Border Styling.', 'innvoke'),
            'default' => '',
            'left' => false,
            'right' => false,
            'bottom' => true,
            'top' => false,
            'all' => false,
            'output' => array(
                '#header.header-separator-border',
                '.header-separator-border .main-nav.sticky-nav',
                '#wrapper.header-sticky-now #header.header-separator-border.header-scroll-light'
            ),
            'class' => 'third-level',
            'required' => array(
                array(
                    'header_separator',
                    'equals',
                    array(
                        "border"
                    )
                )
            )
        ),
        
        
        array(
            'id' => 'header_sidearea',
            'type' => 'switch',
            'title' => __('Enable Side Area', 'innvoke'),
            'default' => 'false',
            'subtitle' => esc_html__('This option enables a side area to be opened from main menu navigation', 'innvoke')
        ),
        
        array(
            'id' => 'header_sticky',
            'type' => 'button_set',
            'title' => esc_html__('Sticky Header', 'innvoke'),
            'subtitle' => esc_html__('Choose the header behaviour on scroll.', 'innvoke'),
            'options' => array(
                'sticky' => esc_html__('Sticky', 'innvoke'),
                'not-sticky' => esc_html__('Not Sticky', 'innvoke')
            ),
            'default' => 'sticky',
        ),
        
        array(
            'id' => 'sticky-header-bg',
            'type' => 'color_rgba',
            'output' => array(
                'background-color' => '.header-scroll-full #main-navigation, .header-scroll-full #header .main-nav, #sticky-nav'
            ),
            'title' => esc_html__('Sticky menu background color', 'innvoke'),
            'subtitle' => esc_html__('Pick a Sticky Menu background color.', 'innvoke'),
            'required' => array(
                'header_sticky',
                '!=',
                'not-sticky'
            ),
            'default' => array(
                'color' => '#fff',
                'alpha' => 1
            )
        ),
        
        array(
            'id' => 'sticky-header-color',
            'type' => 'color',
            'output' => array(
                'color' => '.header-scroll-full #main-menu > ul > li > a, .header-scroll-full .main-menu > ul > li > a, .header-scroll-full .nav-tools .tools-btn-icon'
            ),
            'title' => esc_html__('Sticky Menu titles color', 'innvoke'),
            'subtitle' => esc_html__('Pick a Sticky Menu titles color.', 'innvoke'),
            'required' => array(
                'header_sticky',
                '!=',
                'not-sticky'
            ),
            'transparent' => false,
            'default' => ''
        ),
        
        array(
            'id' => 'header-styling-end',
            'type' => 'section',
            'indent' => false
        )
    )
));


/*top bar*/
// Top Bar

Redux::setSection($opt_name, array(
    'title' => esc_html__('Top Bar', 'innvoke'),
    'id' => 'topbar',
    'subsection' => true,
    'desc' => esc_html__('Top Bar Settings.', 'innvoke'),
    'fields' => array(
        array(
            'id' => 'topbar',
            'type' => 'switch',
            'title' => esc_html__('Top Bar', 'innvoke'),
            'subtitle' => esc_html__('Enable/Disable the Top Bar section. Please note that Top Bar is available only for specific Header Styles.', 'innvoke'),
            'default' => false
        ),
        array(
            'id' => 'topbar_left',
            'type' => 'select',
            'select2' => array(
                'minimumResultsForSearch' => 20,
                'allowClear' => false
            ),
            'title' => esc_html__('Left side content type', 'innvoke'),
            'subtitle' => esc_html__('Choose a content type for the left side of the Top Bar section.', 'innvoke'),
            'options' => array(
                "social" => esc_html__("Social Icons", 'innvoke'),
                "menu" => esc_html__("Menu", 'innvoke'),
                "text" => esc_html__("Text", 'innvoke'),
                "textsocial" => esc_html__("Text + Social Icons", 'innvoke')
            ),
            'default' => 'text'
        ),
        array(
            'id' => 'topbar_text_left',
            'type' => 'textarea',
            'title' => esc_html__('Left Top Bar Text', 'innvoke'),
            'subtitle' => esc_html__('The text content that is being selectable as one of the "content types" for the Top Bar. Supports HTML.', 'innvoke'),
            'default' => 'E-Mail: admin@innvoke.com Phone: +91 632 521 7124',
            'required' => array(
                array(
                    'topbar_left',
                    'equals',
                    array(
                        "text",
                        "textsocial"
                    )
                )
            )
        ),
        array(
            'id' => 'topbar_right',
            'type' => 'select',
            'select2' => array(
                'minimumResultsForSearch' => 20,
                'allowClear' => false
            ),
            'title' => esc_html__('Right side content type', 'innvoke'),
            'subtitle' => esc_html__('Choose a content type for the right side of the Top Bar section.', 'innvoke'),
            'options' => array(
                "social" => esc_html__("Social Icons", 'innvoke'),
                "menu" => esc_html__("Menu", 'innvoke'),
                "text" => esc_html__("Text", 'innvoke'),
                "textsocial" => esc_html__("Text + Social Icons", 'innvoke')
            ),
            'default' => 'social'
        ),
        array(
            'id' => 'topbar_text_right',
            'type' => 'textarea',
            'title' => esc_html__('Right Top Bar Text', 'innvoke'),
            'subtitle' => esc_html__('The text content that is being selectable as one of the "content types" for the Top Bar. Supports HTML.', 'innvoke'),
            'default' => 'E-Mail: hello@waxom.com Phone: 591 341 344',
            'required' => array(
                array(
                    'topbar_right',
                    'equals',
                    array(
                        "text",
                        "textsocial"
                    )
                )
            )
        ),
        
        array(
            'id' => 'topbar-styling-start',
            'type' => 'section',
            'title' => esc_html__('Top Bar Styling', 'innvoke'),
            'indent' => true,
        ),
        array(
            'id' => 'topbar_skin',
            'type' => 'button_set',
            'title' => esc_html__('Top Bar Skin', 'innvoke'),
            'subtitle' => esc_html__('Choose the Top Bar skin. You can later overwrite default styling.', 'innvoke'),
            'options' => array(
                "default" => esc_html__("Default", 'innvoke'),
                "light" => esc_html__("Light", 'innvoke'),
                "dark" => esc_html__("Dark", 'innvoke')
            ),
            'default' => 'default'
        ),
        array(
            'id' => 'topbar_bg',
            'type' => 'color',
            'title' => esc_html__('Top Bar Background Color', 'innvoke'),
            'subtitle' => esc_html__('Specify the background color of the Top Bar.', 'innvoke'),
            'default' => '',
            'transparent' => true,
            'output' => array(
                'background-color' => '#topbar'
            )
        ),
        array(
            'id' => 'topbar_border',
            'type' => 'color',
            'title' => esc_html__('Top Bar Bottom Border', 'innvoke'),
            'subtitle' => esc_html__('Specify the color of the Top Bar bottom border.', 'innvoke'),
            'default' => '',
            'output' => array(
                'border-color' => '#topbar'
            )
        ),
        array(
            'id' => 'topbar_typo',
            'type' => 'typography',
            'select2' => array(
                'minimumResultsForSearch' => 20,
                'allowClear' => false
            ),
            'title' => esc_html__('Top Bar Text', 'innvoke'),
            'subtitle' => esc_html__('Specify font options of the Top Bar texts.', 'innvoke'),
            'google' => false,
            "text-align" => false,
            "line-height" => false,
            "font-style" => true,
            "color" => true,
            "font-family" => false,
            "letter-spacing" => true,
            "text-transform" => true,
            "output" => array(
                "#topbar,#topbar p, #topbar .topbar-menu > div > ul > li"
            )
        ),
        array(
            'id' => 'topbar_links',
            'type' => 'link_color',
            'title' => esc_html__('Top Bar Links', 'innvoke'),
            'subtitle' => esc_html__('Specify colors of the Top Bar links.', 'innvoke'),
            'active' => false,
            'visited' => false,
            "output" => array(
                '.topbar a'
            )
        ),
        array(
            'id' => 'topbar_separator',
            'type' => 'color',
            'title' => esc_html__('Top Bar Elements Separator', 'innvoke'),
            'subtitle' => esc_html__('Specify the color of the separator between Top Bar elements.', 'innvoke'),
            'default' => '',
            'output' => array(
                'border-color' => '#topbar .topbar-social a,#topbar .topbar-menu > div > ul > li,#topbar .topbar-menu > div > ul > li:last-child,#topbar .topbar-social a:last-child'
            )
        ),
        
        array(
            'id' => 'topbar-styling-end',
            'type' => 'section',
            'indent' => false
        )
        
    )
));

/*Drop Down Menu*/
Redux::setSection($opt_name, array(
    'title' => esc_html__('Dropdown Menu', 'innvoke'),
    'id' => 'dropdown-menus',
    'subsection' => true,
    'desc' => esc_html__('Dropdown menu styling and settings.', 'innvoke'),
    'fields' => array(
        array(
            'id' => 'dropdown_skin',
            'type' => 'button_set',
            'title' => esc_html__('Dropdown Menu Skin', 'innvoke'),
            'subtitle' => esc_html__('Choose a skin for the dropdown menu. You may overwrite particular or all design aspects below.', 'innvoke'),
            'options' => array(
                "dark" => esc_html__("Dark", 'innvoke'),
                "white" => esc_html__("White", 'innvoke')
            ),
            'default' => 'white'
        ),
        
        array(
            'id' => 'ins-opt-submenu-bg',
            'type' => 'color_rgba',
            'output' => array(
                'background-color' => '#header .main-nav .sub-menu'
            ),
            'title' => esc_html__('Dropdown Menu background color', 'innvoke'),
            'subtitle' => esc_html__('Pick a Menu dropdown background color.', 'innvoke'),
            'default' => array(
                'color' => '#fff',
                'alpha' => 1
            )
        ),
        
        array(
            'id' => 'ins-opt-typography-submenu',
            'type' => 'typography',
            'title' => esc_html__('Dropdown Menu Typography', 'innvoke'),
            'subtitle' => esc_html__('Specify the dropdown menu elements typography.', 'innvoke'),
            'google' => true,
            'output' => array(
                '.main-menu ul.sub-menu li a, #main-menu ul.sub-menu li a, .sub-menu-full-width ul.menu-depth-2.sub-sub-menu li a'
            ),
            'units' => 'px',
            'letter-spacing' => true,
            'text-transform' => true,
            'color' => false,
            'text-align' => false,
            'default' => array(
                'font-size' => '13px',
                'font-family' => 'Cabin',
                'font-weight' => '500',
                'text-align' => 'left',
                'google' => true,
                
                'line-height' => '20px',
                'letter-spacing' => '1px',
                'text-transform' => 'none'
            )
        ),
        array(
            'id' => 'dropdown_links',
            'type' => 'link_color',
            'title' => esc_html__('Dropdown Menu Links color', 'innvoke'),
            'subtitle' => esc_html__('Specify colors of dropdown menu links.', 'innvoke'),
            'active' => false,
            'visited' => false,
            "output" => array(
                '#header #main-menu .sub-menu a'
            ),
            'default' => array(
                'regular' => '#282828',
                'hover' => '#828282'
            )
        ),
        
        array(
            'id' => 'dropdown_links_bg',
            'type' => 'color',
            'title' => esc_html__('Dropdown Menu Link Hover BG', 'innvoke'),
            'subtitle' => esc_html__('Background color of the dropdown menu item on hover.', 'innvoke'),
            'default' => '',
            'transparent' => false,
            'output' => array(
                'background-color' => '#header #main-menu ul li:not(.mega-menu) ul.sub-menu li:hover'
            )
        )
        
    )
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Header Button', 'innvoke'),
    'id' => 'header-button',
    'subsection' => true,
    'fields' => array(
        array(
            'id' => 'ins-header-button',
            'type' => 'switch',
            'title' => esc_html__('Show button in header', 'innvoke'),
            'default' => false
        ),
        array(
            'id' => 'ins-header-button-text',
            'type' => 'text',
            'title' => esc_html__('Button text', 'innvoke'),
            'required' => array(
                'ins-header-button',
                'equals',
                true
            ),
            'default' => 'Get a quote'
        ),
        array(
            'id' => 'ins-header-button-typo',
            'type' => 'typography',
            'title' => esc_html__('Button font settings', 'innvoke'),
            'output' => ('.header-menu-button .menu-item.ins_header_button'),
            'google' => true,
            'font-family' => true,
            'font-style' => true,
            'font-size' => true,
            'letter-spacing' => true,
            'line-height' => false,
            'color' => false,
            'text-transform' => true,
            'text-align' => false,
            'all_styles' => false,
            'units' => 'px',
            'required' => array(
                'ins-header-button',
                'equals',
                true
            )
        ),
        array(
            'id' => 'ins-header-button-style',
            'type' => 'select',
            'title' => esc_html__('Button style', 'innvoke'),
            'required' => array(
                'ins-header-button',
                'equals',
                true
            ),
            'options' => array(
                'solid-button' => 'Solid',
                'outline-button' => 'Outline'
            ),
            'default' => 'outline-button'
        ),
        array(
            'id' => 'ins-header-button-color',
            'type' => 'select',
            'title' => esc_html__('Button color scheme', 'innvoke'),
            'required' => array(
                'ins-header-button',
                'equals',
                true
            ),
            'options' => array(
                'primary-color' => 'Primary color',
                'secondary-color' => 'Secondary color'
            ),
            'default' => 'primary-color'
        ),
        array(
            'id' => 'ins-header-button-hover-style',
            'type' => 'select',
            'title' => esc_html__('Button hover state', 'innvoke'),
            'required' => array(
                'ins-header-button',
                'equals',
                true
            ),
            'options' => array(
                'hover_solid_primary' => 'Solid - Primary color',
                'hover_solid_secondary' => 'Solid - Secondary color',
                'hover_outline_primary' => 'Outline - Primary color',
                'hover_outline_secondary' => 'Outline - Secondary color'
            ),
            'default' => 'hover_solid_primary'
        ),
        array(
            'id' => 'ins-header-button-action',
            'type' => 'select',
            'title' => esc_html__('Button action', 'innvoke'),
            'required' => array(
                'ins-header-button',
                'equals',
                true
            ),
            'options' => array(
                '1' => 'Open modal window with contact form',
                '2' => 'Scroll to section',
                '3' => 'Open a new page'
            ),
            'default' => '3'
        ),
        array(
            'id' => 'ins-modal-title',
            'type' => 'text',
            'title' => esc_html__('Modal title', 'innvoke'),
            'required' => array(
                'ins-header-button-action',
                'equals',
                '1'
            ),
            'default' => 'Lets get in touch'
        ),
        array(
            'id' => 'ins-modal-subtitle',
            'type' => 'editor',
            'title' => esc_html__('Modal subtitle', 'innvoke'),
            'required' => array(
                'ins-header-button-action',
                'equals',
                '1'
            ),
            'default' => '',
            'args' => array(
                'teeny' => true,
                'textarea_rows' => 10,
                'media_buttons' => false
            )
        ),
        array(
            'id' => 'ins-model-contact-info',
            'type' => 'switch',
            'on' => 'Enable',
            'off' => 'Disable',
            'title' => esc_html__('Contact info', 'innvoke'),
            'subtitle' => esc_html__('Display conatct info on the left side of Model', 'innvoke'),
            'default' => true,
            'required' => array(
                'ins-header-button-action',
                'equals',
                '1'
            )
        ),
        array(
            'id' => 'ins-modal-bg-image',
            'type' => 'media',
            'readonly' => false,
            'url' => true,
            'title' => esc_html__('Modal background image', 'innvoke'),
            'subtitle' => esc_html__('Upload modal background image.', 'innvoke'),
            'required' => array(
                'ins-header-button-action',
                'equals',
                '1'
            ),
            'default' => ''
        ),
        array(
            'id' => 'ins-modal-form-select',
            'type' => 'select',
            'title' => esc_html__('Contact form plugin', 'innvoke'),
            'required' => array(
                'ins-header-button-action',
                'equals',
                '1'
            ),
            'options' => array(
                '1' => 'Contact Form 7',
                '2' => 'Ninja Forms',
                '3' => 'Gravity Forms',
                '4' => 'WP Forms'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'ins-modal-contactf7-formid',
            'type' => 'select',
            'data' => 'posts',
            'args' => array(
                'post_type' => 'wpcf7_contact_form',
                'posts_per_page' => -1
            ),
            'title' => esc_html__('Contact Form 7 Title', 'innvoke'),
            'required' => array(
                'ins-modal-form-select',
                'equals',
                '1'
            ),
            'default' => ''
        ),
        array(
            'id' => 'ins-modal-ninja-formid',
            'type' => 'text',
            'title' => esc_html__('Ninja Form ID', 'innvoke'),
            'required' => array(
                'ins-modal-form-select',
                'equals',
                '2'
            ),
            'default' => ''
        ),
        array(
            'id' => 'ins-modal-gravity-formid',
            'type' => 'text',
            'title' => esc_html__('Gravity Form ID', 'innvoke'),
            'required' => array(
                'ins-modal-form-select',
                'equals',
                '3'
            ),
            'default' => ''
        ),
        array(
            'id' => 'ins-modal-wp-formid',
            'type' => 'text',
            'title' => esc_html__('WP Form ID', 'innvoke'),
            'required' => array(
                'ins-modal-form-select',
                'equals',
                '4'
            ),
            'default' => ''
        ),
        array(
            'id' => 'ins-scroll-id',
            'type' => 'text',
            'title' => esc_html__('Scroll to section ID', 'innvoke'),
            'required' => array(
                'ins-header-button-action',
                'equals',
                '2'
            ),
            'default' => '#about-us'
        ),
        array(
            'id' => 'ins-button-new-page',
            'type' => 'text',
            'title' => esc_html__('Button link', 'innvoke'),
            'required' => array(
                'ins-header-button-action',
                'equals',
                '3'
            ),
            'default' => '#'
        ),
        array(
            'id' => 'ins-button-target',
            'type' => 'select',
            'title' => esc_html__('Link target', 'innvoke'),
            'required' => array(
                'ins-header-button-action',
                'equals',
                '3'
            ),
            'options' => array(
                'new-page' => 'Open in a new page',
                'same-page' => 'Open in same page'
            ),
            'default' => 'new-page'
        )
    )
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Mobile Header', 'innvoke'),
    'id' => 'mobile-menu',
    'subsection' => true,
    'desc' => esc_html__('Mobile header settings.', 'innvoke'),
    'fields' => array(
        array(
            'id' => 'mobileh_sticky',
            'type' => 'button_set',
            'title' => esc_html__('Mobile Header Sticky', 'innvoke'),
            'subtitle' => esc_html__('Choose Mobile header behaviour on scroll.', 'innvoke'),
            'options' => array(
                "yes" => esc_html__("Yes", 'innvoke'),
                "no" => esc_html__("No", 'innvoke')
            ),
            'default' => 'no'
        ),
        
        array(
            'id' => 'mobile_dropdown',
            'type' => 'select',
            'title' => esc_html__('Dropdown menu action', 'innvoke'),
            'subtitle' => esc_html__('Choose if mobile dropdown menu should be accessible only with the arrow or by clicking the parent item (default).', 'innvoke'),
            'options' => array(
                "parent" => esc_html__("Open with parent menu", 'innvoke'),
                "arrow" => esc_html__("Open with arrow", 'innvoke')
            ),
            'default' => 'arrow'
        )
        
    )
));



/* Social Media /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title' => __('Social Media', 'innvoke'),
    'icon' => 'el-icon-twitter',
    'fields' => array(
        
        array(
            'id' => 'social-media',
            'type' => 'info',
            'desc' => esc_html__('Social Media Icons (Remember to include the "http://" in all URLs)', 'innvoke')
        ),
        
        array(
            'id' => 'social_dribbble',
            'type' => 'text',
            'title' => esc_html__('Dribbble', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Dribbble Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_facebook',
            'type' => 'text',
            'title' => esc_html__('Facebook', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Facebook Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_foursquare',
            'type' => 'text',
            'title' => esc_html__('Foursquare', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Foursquare Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_flickr',
            'type' => 'text',
            'title' => esc_html__('Flickr', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Flickr Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_github',
            'type' => 'text',
            'title' => esc_html__('Github', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Github Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_googleplus',
            'type' => 'text',
            'title' => esc_html__('Google+', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Google+ Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_instagram',
            'type' => 'text',
            'title' => esc_html__('Instagram', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Instagram Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_linkedin',
            'type' => 'text',
            'title' => esc_html__('LinkedIn', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your LinkedIn Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_pinterest',
            'type' => 'text',
            'title' => esc_html__('Pinterest', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Pinterest Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_renren',
            'type' => 'text',
            'title' => esc_html__('Renren', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Renren Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_rss',
            'type' => 'text',
            'title' => esc_html__('RSS', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your RSS Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_skype',
            'type' => 'text',
            'title' => esc_html__('Skype', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Skype Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_soundcloud',
            'type' => 'text',
            'title' => esc_html__('Soundcloud', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Soundcloud Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_stackoverflow',
            'type' => 'text',
            'title' => esc_html__('Stack Overflow', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Stack Overflow Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_twitter',
            'type' => 'text',
            'title' => esc_html__('Twitter', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Twitter Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_tumblr',
            'type' => 'text',
            'title' => esc_html__('Tumblr', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Tumblr Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_vimeo',
            'type' => 'text',
            'title' => esc_html__('Vimeo', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Vimeo Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_vk',
            'type' => 'text',
            'title' => esc_html__('VK', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your VK Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_weibo',
            'type' => 'text',
            'title' => esc_html__('Weibo', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Weibo Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_xing',
            'type' => 'text',
            'title' => esc_html__('Xing', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your Xing Account', 'innvoke'),
            'default' => ''
        ),
        
        array(
            'id' => 'social_youtube',
            'type' => 'text',
            'title' => esc_html__('YouTube', 'innvoke'),
            'subtitle' => esc_html__('Enter URL to your YouTube Account', 'innvoke'),
            'default' => ''
        )
        
    )
));


/**
 *
 * Banner options 
 *
 **/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Page Title Options', 'innvoke'),
    'id' => 'homepage-header',
    'icon' => 'el el-picture',
    'fields' => array(
        array(
            'id' => 'header_title',
            'type' => 'switch',
            'title' => esc_html__('Page Title', 'innvoke'),
            'subtitle' => esc_html__('Enable/Disable the Page Title area globally.', 'innvoke'),
            'default' => true
        ),
        array(
            'id' => 'ins_page_title_align',
            'type' => 'button_set',
            'title' => esc_html__('Text Alignment', 'innvoke'),
            'options' => array(
                'left' => 'Left',
                'center' => 'Center',
                'right' => 'Right'
            ),
            'default' => 'center',
            'subtitle' => esc_html__('Default page title text alignment.', 'innvoke')
        ),
        
        array(
            'id' => 'ins_blog_title_align',
            'type' => 'button_set',
            'title' => esc_html__('Text Alignment for Blog Posts', 'innvoke'),
            'options' => array(
                'left' => 'Left',
                'center' => 'Center',
                'right' => 'Right'
            ),
            'default' => 'center',
            'subtitle' => esc_html__('Default page title alignment for single blog posts.', 'innvoke')
        ),
        
        array(
            'id' => 'pagetitle_bg_image',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Background image', 'innvoke'),
            'subtitle' => esc_html__('Select image pattern for page header background', 'innvoke'),
            'compiler' => 'true'
        ),
        
        array(
            'id' => 'pagetitle_bg_options',
            'type' => 'background',
            'url' => false,
            'title' => esc_html__('Background Image Settings', 'innvoke'),
            'subtitle' => esc_html__('Specify parameters of the background image.', 'innvoke'),
            'compiler' => 'true',
            'transparent' => false,
            'background-image' => false,
            'background-color' => false,
            'preview' => false,
            'output' => '.ins-page-title-wrapper .ins-page-title-bg'
        ),
        
        array(
            'id' => 'pagetitle_bg_color',
            'type' => 'color',
            'output' => array(
                'background-color' => '#ins-page-title'
            ),
            'title' => esc_html__('Background color', 'innvoke'),
            'subtitle' => esc_html__('Select color for header background', 'innvoke'),
            'default' => '#f8f8f8'
        ),
        array(
            'id' => 'pagetitle_bg_image_overlay',
            'type' => 'select',
            'select2' => array(
                'minimumResultsForSearch' => 20,
                'allowClear' => false
            ),
            'title' => esc_html__('Background Image Overlay', 'innvoke'),
            'subtitle' => esc_html__('Use it to make your background image darker or lighter without modifying the image itself.', 'innvoke'),
            'options' => array(
                "none" => "None",
                "dark30" => "Dark 30%",
                "dark50" => "Dark 50%",
                "dark70" => "Dark 70%",
                "dark80" => "Dark 80%",
                "dark90" => "Dark 90%",
                "light30" => "Light 30%",
                "light50" => "Light 50%",
                "light70" => "Light 70%",
                "light80" => "Light 80%",
                "light90" => "Light 90%"
            ),
            'default' => 'none',
            'required' => array(
                'pagetitle_bg_image',
                'not',
                ''
            )
        ),
        array(
            'id' => 'breadcrumbs',
            'type' => 'select',
            'title' => esc_html__('Enable breadcrumbs', 'innvoke'),
            'options' => array(
                'yes' => 'Enable',
                'no' => 'Disable'
            ),
            'default' => 'yes'
        ),
        array(
            'id' => 'pagetitle_height',
            'type' => 'text',
            'title' => esc_html__('Page Title Height', 'innvoke'),
            'subtitle' => esc_html__('Enter height of page header. Enter Number without unit for example "300".', 'innvoke'),
            'default' => '300'
        ),
        array(
            'id' => 'ins-opt-header-typography',
            'type' => 'typography',
            'title' => esc_html__('Page title typography', 'innvoke'),
            'subtitle' => esc_html__('Typography settings of the main heading in Page Titles with a background.', 'innvoke'),
            'google' => true,
            'font-backup' => true,
            'output' => array(
                '.ins-page-title-txt>h1'
            ),
            'letter-spacing' => true,
            'text-transform' => true,
            'text-align' => false,
            'color' => false,
            'units' => 'px',
            'default' => array(
                'color' => '#223645',
                'font-size' => '35px',
                'font-family' => 'Cabin',
                'font-weight' => '600',
                'google' => true,
                'line-height' => '45px',
                'letter-spacing' => '1px'
            )
        ),
        array(
            'id' => 'pagetitle_color',
            'type' => 'color',
            'title' => esc_html__('Font color of the main heading in Page Titles with a background.', 'innvoke'),
            'subtitle' => esc_html__('Select color for header background', 'innvoke'),
            'output' => array(
                'color' => '.ins-page-title-txt>h1, .ins-breadcrumbs a, .ins-breadcrumbs, .ins-breadcrumbs i, .ins-breadcrumbs .current'
            ),
            'default' => '#223645'
        ),
        array(
            'id' => 'page-subtitle-typography',
            'type' => 'typography',
            'title' => esc_html__('Page Subtitle Typography', 'innvoke'),
            'subtitle' => esc_html__('Typography settings of the sub heading in Page Titles with a background.', 'innvoke'),
            'google' => true,
            'font-backup' => true,
            'output' => array(
                '.ins-page-subtitle'
            ),
            'letter-spacing' => true,
            'text-transform' => true,
            'text-align' => false,
            'units' => 'px',
            'default' => array(
                'color' => '#223645',
                'font-size' => '16px',
                'font-family' => 'Cabin',
                'font-weight' => '400',
                'google' => true,
                'line-height' => '30px',
                'letter-spacing' => '1px'
            )
        )
    )
));




/**
 *
 *Blog layout options
 *
 **/


Redux::setSection($opt_name, array(
    'title' => __('Blog Options', 'innvoke'),
    'id' => 'blog',
    'icon' => 'el el-list-alt',
    'fields' => array(
        array(
            'id' => 'blog_page_layout',
            'type' => 'image_select',
            'title' => esc_html__('Blog Page Layout', 'innvoke'),
            'subtitle' => esc_html__('Choose a page layout for your blog index page (page set as Posts Page).', 'innvoke'),
            'options' => array(
                'no_sidebar' => array(
                    'alt' => '1 Column',
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'sidebar_left' => array(
                    'alt' => '2 Column Left',
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'sidebar_right' => array(
                    'alt' => '2 Column Right',
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                )
            ),
            'default' => 'sidebar_right'
        )
        
        
    )
));
// Blog -> Single Post

Redux::setSection($opt_name, array(
    'title' => esc_html__('Single Posts', 'innvoke'),
    'id' => 'subsection_blog_single',
    'subsection' => true,
    'desc' => esc_html__('Single blog post options.', 'innvoke'),
    'fields' => array(
        
        array(
            'id' => 'blog_single_media',
            'type' => 'switch',
            'title' => esc_html__('Post Media', 'innvoke'),
            'subtitle' => esc_html__('Display post media on single post page according to post format i.e. video player for "video" format etc.', 'innvoke'),
            'default' => true
        ),
        
        array(
            'id' => 'blog_trackback',
            'type' => 'switch',
            'title' => esc_html__('Post Trackbacks', 'innvoke'),
            'subtitle' => esc_html__('Display the post trackback URL address with CSS.', 'innvoke'),
            'default' => false
        ),
        
        array(
            'id' => 'blog_post_author',
            'type' => 'switch',
            'title' => esc_html__('Post Author', 'innvoke'),
            'subtitle' => esc_html__('Display Author Info on Blog Posts. You can add an Author text in your User Settings.', 'innvoke'),
            'default' => true
        ),
        
        array(
            'id' => 'blog_post_nav',
            'type' => 'switch',
            'title' => esc_html__('Blog Post Navigation', 'innvoke'),
            'subtitle' => esc_html__('Display the navigation to next/prev posts on a single blog post.', 'innvoke'),
            'default' => true
        ),
        
        array(
            'id' => 'blog_post_layout',
            'type' => 'image_select',
            'title' => esc_html__('Single Blog Post layout', 'innvoke'),
            'subtitle' => esc_html__('Choose a default page layout for your single blog posts.', 'innvoke'),
            'options' => array(
                'full_width' => array(
                    'alt' => '1 Column',
                    'img' => ReduxFramework::$_url . 'assets/img/1col.png'
                ),
                'left_sidebar' => array(
                    'alt' => '2 Column Left',
                    'img' => ReduxFramework::$_url . 'assets/img/2cl.png'
                ),
                'right_sidebar' => array(
                    'alt' => '2 Column Right',
                    'img' => ReduxFramework::$_url . 'assets/img/2cr.png'
                )
            ),
            'default' => 'left_sidebar'
        )
        
    )
    
));
/**
 *
 *end Blog Layout
 *
 **/



/**
 *
 *Woo-commerce options 
 *
 **/

Redux::setSection($opt_name, array(
    'title' => __('WooCommerce', 'innvoke'),
    'id' => 'woo-options',
    'icon' => 'el el-shopping-cart',
    'fields' => array(
        array(
            'id' => 'header_woocommerce',
            'type' => 'switch',
            'title' => esc_html__('Shopping Cart Icon', 'innvoke'),
            'subtitle' => esc_html__('Enable/Disable the WooCommerce icon in the Header section.', 'innvoke'),
            'default' => true
        ),
        
        array(
            'id' => 'shop_cols',
            'type' => 'button_set',
            'title' => esc_html__('Shop Page Columns', 'innvoke'),
            'subtitle' => esc_html__('Select number of columns for your shop products page.', 'innvoke'),
            'options' => array(
                "4" => "4",
                "3" => "3",
                "2" => "2"
            ),
            'default' => '4'
        )
        
    )
));


/**
 *
 *Portfolio options 
 *
 **/


Redux::setSection($opt_name, array(
    'title' => esc_html__('Case Studies', 'innvoke'),
    'id' => 'case_studies',
    'icon' => 'el el-briefcase'
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Case Studies General', 'innvoke'),
    'id' => 'case_studies_general',
    'desc' => esc_html__('Case Studies archive page Settings.', 'innvoke'),
    'subsection' => true,
    'fields' => array(
        
        // Posts Order
        
        
        array(
            'id' => 'case_studies_orderby',
            'type' => 'select',
            'title' => esc_html__('Order posts by', 'innvoke'),
            'subtitle' => esc_html__('Sort/order your posts by a certain value.', 'innvoke'),
            'options' => array(
                "date" => esc_html__("Date", 'innvoke'),
                "none" => esc_html__("None - no order", 'innvoke'),
                "ID" => esc_html__("Post ID", 'innvoke'),
                "author" => esc_html__("Author", 'innvoke'),
                "title" => esc_html__("Title", 'innvoke'),
                "name" => esc_html__("Name (slug)", 'innvoke'),
                "menu_order" => esc_html__("Menu Order", 'innvoke')
            ),
            'default' => 'date'
        ),
        
        array(
            'id' => 'case_studies_order',
            'type' => 'button_set',
            'title' => esc_html__('Order posts by', 'innvoke'),
            'subtitle' => esc_html__('Posts order.', 'innvoke'),
            'options' => array(
                "desc" => esc_html__("Descending (DESC)", 'innvoke'),
                "asc" => esc_html__("Ascending (ASC)", 'innvoke')
            ),
            'default' => 'desc'
        ),
        
        
        array(
            'id' => 'case_studies_pagination',
            'type' => 'button_set',
            'title' => esc_html__('Pagination', 'innvoke'),
            'subtitle' => esc_html__('Choose pagination for your grid.', 'innvoke'),
            'options' => array(
                "enable" => esc_html__("Enable", 'innvoke'),
                "disable" => esc_html__("Disable", 'innvoke')
            ),
            'default' => 'enable',
            'required' => array(
                'case_studies_filter',
                'equals',
                array(
                    "no"
                )
            )
        )
        
    )
));

Redux::setSection($opt_name, array(
    'title' => esc_html__('Single Case Study', 'innvoke'),
    'id' => 'case_studies_single',
    'desc' => esc_html__('Single Case Study post page settings.', 'innvoke'),
    'subsection' => true,
    'fields' => array(
        
        array(
            'id' => 'g_case_studies_sharing',
            'type' => 'switch',
            'title' => esc_html__('Social Sharing Buttons', 'innvoke'),
            'subtitle' => esc_html__('Display Social sharing buttons.', 'innvoke'),
            'default' => true
        ),
        
        array(
            'id' => 'g_case_studies_navigation',
            'type' => 'switch',
            'title' => esc_html__('Post Navigation', 'innvoke'),
            'subtitle' => esc_html__('Display post navigation.', 'innvoke'),
            'default' => true
        )
        
    )
));


/**
 *
 *footer-copyright
 *
 **/


// -> START Editors

Redux::setSection($opt_name, array(
    'title' => __('Footer', 'innvoke'),
    'id' => 'footer-editor',
    //'subsection' => true,
    'icon' => 'el el-circle-arrow-down',
    'fields' => array(
        
        array(
            'id' => 'ins-footer-fixed',
            'type' => 'switch',
            'title' => esc_html__('Set footer fixed to bottom', 'innvoke'),
            'subtitle' => esc_html__('Enable to activate this feature.', 'innvoke')
        ),
        
        array(
            'id' => 'footer-variant',
            'type' => 'select',
            'title' => esc_html__('Footer variants', 'innvoke'),
            'options' => array(
                '1' => 'Standard footer with widgets inside',
                '2' => 'Standard footer with Visual Composer modules inside',
                '3' => 'Disable Footer'
            ),
            'default' => '1'
        ),
        
        array(
            'id' => 'ins-opt-footer-page',
            'type' => 'select',
            'multi' => false,
            'required' => array(
                'footer-variant',
                'equals',
                '2'
            ),
            'data' => 'posts',
            'args' => array(
                'post_type' => array(
                    'page'
                ),
                'numberposts' => -1
            ),
            'title' => esc_html__('Footer Section Page', 'innvoke'),
            'subtitle' => esc_html__('Selected page will be displayed as footer', 'innvoke')
        ),
        
        array(
            'id' => 'ins-opt-widget-title-typography',
            'type' => 'typography',
            'title' => esc_html__('Footer Widget title typography', 'innvoke'),
            'subtitle' => esc_html__('Specify the Widget title properties.', 'innvoke'),
            'required' => array(
                'footer-variant',
                'equals',
                '1'
            ),
            "text-align" => false,
            "line-height" => true,
            "font-style" => true,
            "color" => true,
            "font-family" => true,
            "letter-spacing" => true,
            "text-transform" => true,
            'output' => array(
                '#footer .widget-title'
            ),
            'units' => 'px',
            'default' => array(
                'color' => '#fff',
                'font-size' => '20px',
                'font-style' => 'bold',
                'line-height' => '30px',
                'letter-spacing' => '1px'
            )
        ),
        
        array(
            'id' => 'footer-widget-text-color',
            'type' => 'color',
            'required' => array(
                'footer-variant',
                'equals',
                '1'
            ),
            'title' => esc_html__('Footer Widget text Color', 'innvoke'),
            'output' => array(
                '#footer .textwidget, #footer .widget, #footer  .textwidget p, #footer .social-widget-inner a, #footer .widget_list_tweet_text, #footer .widget_list_tweet_date, #footer .widget li, #footer .widget ul, #footer .widget p, #footer strong, #footer .calendar_wrap tbody tr td, #footer .calendar_wrap thead tr th'
            ),
            'default' => '#fff'
        ),
        
        array(
            'id' => 'footer-widget-link-color',
            'type' => 'link_color',
            'required' => array(
                'footer-variant',
                'equals',
                '1'
            ),
            'title' => esc_html__('Footer Widget Link Color', 'innvoke'),
            'output' => array(
                '#footer .widget a'
            ),
            'transparent' => false,
            'visited' => false,
            'active' => false,
            'default' => array(
                'regular' => '#c4c4c4',
                'hover' => '#fff'
            )
        ),
        
        array(
            'id' => 'footer-bg-color',
            'type' => 'background',
            'required' => array(
                'footer-variant',
                '!=',
                '3'
            ),
            'output' => array(
                '#footer'
            ),
            'title' => esc_html__('Footer Background', 'innvoke'),
            'default' => array(
                'background-color' => '#212121'
            )
        ),
        
        
        array(
            'id' => 'footer_border',
            'type' => 'border',
            'title' => esc_html__('Section Top Border', 'innvoke'),
            'subtitle' => esc_html__('Specify the top border of the section.', 'innvoke'),
            'default' => '',
            'left' => false,
            'right' => false,
            'bottom' => false,
            'all' => false,
            'output' => array(
                '#footer'
            )
        ),
        
        
        array(
            'id' => 'info_normal',
            'type' => 'info',
            'desc' => esc_html__('Copyright', 'innvoke')
        ),
        
        array(
            'id' => 'switch_copyright',
            'type' => 'switch',
            'title' => esc_html__('Copyright Area', 'innvoke'),
            'subtitle' => esc_html__('Enable / Disable Copyright Area.', 'innvoke'),
            'default' => true
        ),
        
        array(
            'id' => 'textarea_copyright',
            'type' => 'textarea',
            'title' => esc_html__('Copyright Text', 'innvoke'),
            'subtitle' => esc_html__('Enter your Copyright Text (HTML allowed).', 'innvoke'),
            'default' => '2019 Innvoke - WordPress Theme built by <a href="http://insigniatechnolabs.com/">Insignia</a> using <a href="http://wordpress.org/" target="_blank">WordPress</a>.',
            'required' => array(
                'switch_copyright',
                "=",
                '1'
            )
        ),
        
        array(
            'id' => 'select_copyright',
            'type' => 'select',
            'title' => esc_html__('Copyright Right Content', 'innvoke'),
            'options' => array(
                'social_media' => esc_html__('Social Media', 'innvoke'),
                'navigation' => esc_html__('Navigation', 'innvoke'),
                'leave_empty' => esc_html__('Leave Empty', 'innvoke')
            ),
            'default' => 'Leave Empty',
            'required' => array(
                'switch_copyright',
                "=",
                '1'
            )
        ),
        
        array(
            'id' => 'copyright_bg',
            'type' => 'color',
            'transparent' => false,
            'title' => __('Sub Footer Background Color', 'innvoke'),
            'default' => '#1b1b1b',
            'output' => array(
                'background-color' => '#copyright'
            ),
            'required' => array(
                'switch_copyright',
                "=",
                '1'
            )
        ),
        
        array(
            'id' => 'copyright_color',
            'type' => 'color',
            'transparent' => false,
            'default' => '#777777',
            'title' => __('Copyright Text Color', 'innvoke'),
            'output' => array(
                'color' => '#copyright, #copyright p, #copyright h1, #copyright h2, #copyright h3, #copyright h4, #copyright h5, #copyright h6, #copyright strong, #copyright li'
            ),
            'required' => array(
                'switch_copyright',
                "=",
                '1'
            )
        ),
        
        array(
            'id' => 'copyright_link',
            'type' => 'link_color',
            'title' => __('Copyright Link Color', 'innvoke'),
            'transparent' => false,
            'visited' => false,
            'active' => false,
            'default' => array(
                'regular' => '#999999',
                'hover' => '#cccccc'
            ),
            'output' => array(
                '#copyright a'
            ),
            'required' => array(
                'switch_copyright',
                "=",
                '1'
            )
        ),
        
        array(
            'id' => 'copyright_border',
            'type' => 'border',
            'title' => esc_html__('Section Top Border', 'innvoke'),
            'subtitle' => esc_html__('Specify the top border of the section.', 'innvoke'),
            'default' => '',
            'left' => false,
            'right' => false,
            'bottom' => false,
            'all' => false,
            'output' => array(
                '#copyright'
            )
        )
        
    )
));
/**
 *
 *end footer
 *
 **/


/**
 *
 *Contact options
 *
 **/


// -> START Editors

Redux::setSection($opt_name, array(
    'title' => __('Contact options', 'innvoke'),
    'id' => 'contact-option',
    //'subsection' => true,
    'icon' => 'el el-headphones',
    'fields' => array(
        array(
            'id' => 'ins-business-phone',
            'type' => 'text',
            'title' => esc_html__('Business Phone', 'innvoke'),
            'default' => '(145)-456-865'
        ),
        array(
            'id' => 'ins-business-email',
            'type' => 'text',
            'title' => esc_html__('Business Email', 'innvoke'),
            'default' => 'contact@innvoke-theme.com'
        ),
        array(
            'id' => 'ins-business-address',
            'type' => 'text',
            'title' => esc_html__('Business Address', 'innvoke'),
            'default' => '49, Suitland Street, Sydney, Australia'
        ),
        
        array(
            'id' => 'ins-opt-google-api',
            'type' => 'text',
            'title' => __('Google Maps API Key', 'innvoke'),
            'subtitle' => __('Paste your Google Maps Api Key. This is necessary for the Google Map to work on your website.', 'innvoke'),
            'compiler' => 'true'
        )
    )
));

/**
 *
 * End Google Map
 *
 **/

// Advanced 

Redux::setSection($opt_name, array(
    'title' => esc_html__('Advanced', 'innvoke'),
    'id' => 'advanced',
    'icon' => 'el el-wrench',
    'fields' => array(
        array(
            'id' => 'custom_html',
            'type' => 'ace_editor',
            'title' => esc_html__('Custom HTML Code', 'innvoke'),
            'subtitle' => esc_html__('Paste a custom HTML code here and it will be placed just before your site\'s <body> tag. Great for placing <script> scripts of Facebook Pixel or Google Analytics.', 'innvoke'),
            'mode' => 'html',
            'theme' => 'chrome',
            'default' => ""
        ),
        array(
            'id' => 'custom_css',
            'type' => 'ace_editor',
            'title' => esc_html__('Custom CSS Code', 'innvoke'),
            'subtitle' => esc_html__('Paste your CSS code here.', 'innvoke'),
            'mode' => 'css',
            'theme' => 'chrome',
            'default' => ""
        )
        
    )
));

/*
End sections
*/

/*
 *
 * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
 *
 */

/*
 *
 * --> Action hook examples
 *
 */


/**
 * This is a test function that will let you see when the compiler hook occurs.
 * It only runs if a field    set with compiler=>true is changed.
 * */
if (!function_exists('compiler_action')) {
    function compiler_action($options, $css, $changed_values)
    {
        echo '<h1>The compiler hook has run!</h1>';
        echo "<pre>";
        print_r($changed_values); // Values that have changed since the last save
        echo "</pre>";
        //print_r($options); //Option values
        //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
    }
}

/**
 * Custom function for the callback validation referenced above
 * */
if (!function_exists('redux_validate_callback_function')) {
    function redux_validate_callback_function($field, $value, $existing_value)
    {
        $error   = false;
        $warning = false;
        
        //do your validation
        if ($value == 1) {
            $error = true;
            $value = $existing_value;
        } elseif ($value == 2) {
            $warning = true;
            $value   = $existing_value;
        }
        
        $return['value'] = $value;
        
        if ($error == true) {
            $field['msg']    = 'your custom error message';
            $return['error'] = $field;
        }
        
        if ($warning == true) {
            $field['msg']      = 'your custom warning message';
            $return['warning'] = $field;
        }
        
        return $return;
    }
}

/**
 * Custom function for the callback referenced above
 */
if (!function_exists('redux_my_custom_field')) {
    function redux_my_custom_field($field, $value)
    {
        print_r($field);
        echo '<br/>';
        print_r($value);
    }
}

/**
 * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
 * Simply include this function in the child themes functions.php file.
 * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
 * so you must use get_template_directory_uri() if you want to use any of the built in icons
 * */
if (!function_exists('dynamic_section')) {
    function dynamic_section($sections)
    {
        
        $sections[] = array(
            'title' => __('Section via hook', 'innvoke'),
            'desc' => __('<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'innvoke'),
            'icon' => 'el el-paper-clip',
            // Leave this as a blank section, no options just some intro text set above.
            'fields' => array()
        );
        
        return $sections;
    }
}

/**
 * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
 * */
if (!function_exists('change_arguments')) {
    function change_arguments($args)
    {
        return $args;
    }
}

/**
 * Filter hook for filtering the default value of any given field. Very useful in development mode.
 * */
if (!function_exists('change_defaults')) {
    function change_defaults($defaults)
    {
        $defaults['str_replace'] = 'Testing filter hook!';
        
        return $defaults;
    }
}