'use strict';
const MANIFEST = 'flutter-app-manifest';
const TEMP = 'flutter-temp-cache';
const CACHE_NAME = 'flutter-app-cache';

const RESOURCES = {"flutter_bootstrap.js": "25cffa9bb9cedb8872da5dd55a3a22db",
"version.json": "328df6afab875ad94d310e43b2c69c69",
"index.html": "061a035945a48cfcd26b9a116d030007",
"/": "061a035945a48cfcd26b9a116d030007",
"main.dart.js": "fae09c1a1ab7450c9e00c5aac189b177",
"web/firebase-messaging-sw.js": "f62b614dce10ba088b48cefe8db2f46c",
"flutter.js": "4b2350e14c6650ba82871f60906437ea",
"favicon.png": "5dcef449791fa27946b3d35ad8803796",
"icons/Icon-192.png": "ac9a721a12bbc803b44f645561ecb1e1",
"icons/Icon-maskable-192.png": "c457ef57daa1d16f64b27b786ec2ea3c",
"icons/Icon-maskable-512.png": "301a7604d45b3e739efc881eb04896ea",
"icons/Icon-512.png": "96e752610906ba2a93c65f8abe1645f1",
"manifest.json": "9b7d0c335315d07ce87603cfc3e27a55",
"assets/AssetManifest.json": "57297a823bb56eaba742ca5c0737040a",
"assets/NOTICES": "c6ae422dac0472929e8695aa1ac8b3a7",
"assets/FontManifest.json": "dc3d03800ccca4601324923c0b1d6d57",
"assets/AssetManifest.bin.json": "2782c1cd5516b9ee0e50232cdbc3802f",
"assets/packages/cupertino_icons/assets/CupertinoIcons.ttf": "e986ebe42ef785b27164c36a9abc7818",
"assets/packages/google_places_flutter/images/location.json": "afa33acf2c340246c901718f4efdfccf",
"assets/shaders/ink_sparkle.frag": "ecc85a2e95f5e9f53123dcaf8cb9b6ce",
"assets/AssetManifest.bin": "9a72de0a3e920944339295448ed393bf",
"assets/fonts/MaterialIcons-Regular.otf": "d2db14cfb3213bf44a5c6f2836236d8f",
"assets/assets/coupons.json": "8fcc25b877c27536a780679aa78be654",
"assets/assets/empty_cart%2520copy.json": "c514c310e1af2aa134afc5b8e93f97d5",
"assets/assets/no_product.json": "11f1181d513f71f3987ad211fb714d35",
"assets/assets/images/faqs.png": "8cd38dd960d89893ed6f7ac75cc4bb02",
"assets/assets/images/pinpoint.png": "91d78fcecdccd89db7c713293dce680e",
"assets/assets/images/slide3.png": "6587e9dcd247b5c2ff6de49679f57a6f",
"assets/assets/images/slide2.png": "7157324ee952aa50d6e7a187e4cbc102",
"assets/assets/images/category.png": "76d3ad3a70cfb2e7bfa9b0abb7eb8456",
"assets/assets/images/tick.png": "d3da6354c779b49da80a0aae8282e2a1",
"assets/assets/images/cake.png": "e5eb8bc7e2363e287ce602a57d8ed0b4",
"assets/assets/images/offBanner.png": "318e264d8730fa03a32c2defcc6b926b",
"assets/assets/images/slide1.png": "1ecbc122f9622d02f72f69378b0cf058",
"assets/assets/images/slide5.png": "68242c6ae73df7fd62b490fbe1903050",
"assets/assets/images/cart.png": "00889b7b6cd3ff691052154ef3b6d424",
"assets/assets/images/slide4.png": "a6fc5ed2ff5aebea85823ff58d87e454",
"assets/assets/images/offerTheme.png": "a9fcee140da5de86f81cfa429001ca4e",
"assets/assets/images/percentage.png": "04c6d83374199a6d270e932404b9255d",
"assets/assets/images/food.jpeg": "239c4c11f4432a79180f17cc59fdf167",
"assets/assets/images/product.png": "82102775f91e854a210a1b96b3297241",
"assets/assets/images/enquiry_banner.png": "b33700b0d64f1a04c184e80e3d9cad43",
"assets/assets/images/banner2.png": "1305cf0af44dff61c36a5ab46a67e0af",
"assets/assets/images/review.png": "5a9b386b7e9b07ec8b66e9e5fe9e18f3",
"assets/assets/images/acategory.png": "1024280fb8f0be1179ffb1c8ded6fb42",
"assets/assets/images/banner1.png": "82d4223fb815bc639babb47d599e3855",
"assets/assets/images/theme.png": "fed1a44fdccbe7a41ad9b61ad608f00c",
"assets/assets/images/home.png": "f8bd8c3fa2a7d47c196e21c5a8d0c889",
"assets/assets/images/Live%2520Chat.png": "bd3112683ba808cd73633acad88dbd15",
"assets/assets/images/Call%2520Support.png": "7ca620b41f0170e84b83f23f3a0fe8b2",
"assets/assets/images/search.png": "84ae3ff8970a4d42910a059bf020523c",
"assets/assets/images/activehome.png": "f2d89a0038a45e3fd1faae1556d5b224",
"assets/assets/images/nonveg.png": "c21ae7bf1f4faa430b6f35be6afe709e",
"assets/assets/images/confirmed.png": "bafc87435277c3827f36a1d3a8620e09",
"assets/assets/images/logo.png": "ed2ae303194d72457229971e4752f7b7",
"assets/assets/images/refer.png": "a751c3b1167ca77589950646ad70f164",
"assets/assets/images/Email%2520Support.png": "f5161564600629af8970e1a45127268a",
"assets/assets/images/profile.png": "60fe24ff1c50e3034a9f52a1383b4078",
"assets/assets/images/navyaOwner.png": "ae07e1b3b31d1f6a45950db0456db115",
"assets/assets/images/shoptag.png": "ff2eb4a4b6a8ccc8260a99729bec9b32",
"assets/assets/images/biscut.png": "bde755183e3ab1ff38a94bf851032e99",
"assets/assets/images/edit.png": "f8432948a26ab46e1de9bc8a645ea6cd",
"assets/assets/images/star.png": "4b6fc5d046ecbee834372dd2df4e53d5",
"assets/assets/images/veg.png": "701b717782d8464bc2a249baccadf098",
"assets/assets/images/egg.png": "19396710591fb2b634372f59ec5a9554",
"assets/assets/images/love.png": "10b80b5a23a25cbb26cc46b284c54f49",
"assets/assets/images/aprofile.png": "ecc654280b5164769293bcdffee0adf7",
"assets/assets/images/custom_banner.png": "65eab6b28ad46c56fd3f141a45188624",
"assets/assets/images/feedback.png": "2da5db1d0618ea02fdbea953e5b09db1",
"assets/assets/images/coupon.png": "d56aade0e63d88d7836ca0bf61b731ec",
"assets/assets/images/rating.png": "96db6ec56bfef011a87e7ae0d8f6ca47",
"assets/assets/images/wp.png": "7a5ef48395260cfe1f9012c6a168c1c4",
"assets/assets/images/navigation.png": "145a77edb36a5d6573732b93ccd7b447",
"assets/assets/images/orders.png": "f737c1bd5bd9787ec66af0bfdb1946e1",
"assets/assets/location.json": "21523e2357c7abecdcc0f7de842159fe",
"assets/assets/no_address.json": "63d7e511ab477d433263e010e8ee0e2d",
"assets/assets/no_address%2520copy.json": "63d7e511ab477d433263e010e8ee0e2d",
"assets/assets/no_orders%2520copy.json": "ca7b1fbabcd51bc74836fb2a2f51a6cd",
"assets/assets/coupons%2520copy.json": "8fcc25b877c27536a780679aa78be654",
"assets/assets/no_orders.json": "ca7b1fbabcd51bc74836fb2a2f51a6cd",
"assets/assets/location%2520copy.json": "21523e2357c7abecdcc0f7de842159fe",
"assets/assets/empty_cart.json": "c514c310e1af2aa134afc5b8e93f97d5",
"assets/assets/no-internet.json": "63c7cfda61cf3145db7a58bd34e92dfc",
"assets/assets/no_product%2520copy.json": "11f1181d513f71f3987ad211fb714d35",
"canvaskit/skwasm.js": "ac0f73826b925320a1e9b0d3fd7da61c",
"canvaskit/skwasm.js.symbols": "96263e00e3c9bd9cd878ead867c04f3c",
"canvaskit/canvaskit.js.symbols": "efc2cd87d1ff6c586b7d4c7083063a40",
"canvaskit/skwasm.wasm": "828c26a0b1cc8eb1adacbdd0c5e8bcfa",
"canvaskit/chromium/canvaskit.js.symbols": "e115ddcfad5f5b98a90e389433606502",
"canvaskit/chromium/canvaskit.js": "b7ba6d908089f706772b2007c37e6da4",
"canvaskit/chromium/canvaskit.wasm": "ea5ab288728f7200f398f60089048b48",
"canvaskit/canvaskit.js": "26eef3024dbc64886b7f48e1b6fb05cf",
"canvaskit/canvaskit.wasm": "e7602c687313cfac5f495c5eac2fb324",
"canvaskit/skwasm.worker.js": "89990e8c92bcb123999aa81f7e203b1c"};
// The application shell files that are downloaded before a service worker can
// start.
const CORE = ["main.dart.js",
"index.html",
"flutter_bootstrap.js",
"assets/AssetManifest.bin.json",
"assets/FontManifest.json"];

// During install, the TEMP cache is populated with the application shell files.
self.addEventListener("install", (event) => {
  self.skipWaiting();
  return event.waitUntil(
    caches.open(TEMP).then((cache) => {
      return cache.addAll(
        CORE.map((value) => new Request(value, {'cache': 'reload'})));
    })
  );
});
// During activate, the cache is populated with the temp files downloaded in
// install. If this service worker is upgrading from one with a saved
// MANIFEST, then use this to retain unchanged resource files.
self.addEventListener("activate", function(event) {
  return event.waitUntil(async function() {
    try {
      var contentCache = await caches.open(CACHE_NAME);
      var tempCache = await caches.open(TEMP);
      var manifestCache = await caches.open(MANIFEST);
      var manifest = await manifestCache.match('manifest');
      // When there is no prior manifest, clear the entire cache.
      if (!manifest) {
        await caches.delete(CACHE_NAME);
        contentCache = await caches.open(CACHE_NAME);
        for (var request of await tempCache.keys()) {
          var response = await tempCache.match(request);
          await contentCache.put(request, response);
        }
        await caches.delete(TEMP);
        // Save the manifest to make future upgrades efficient.
        await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
        // Claim client to enable caching on first launch
        self.clients.claim();
        return;
      }
      var oldManifest = await manifest.json();
      var origin = self.location.origin;
      for (var request of await contentCache.keys()) {
        var key = request.url.substring(origin.length + 1);
        if (key == "") {
          key = "/";
        }
        // If a resource from the old manifest is not in the new cache, or if
        // the MD5 sum has changed, delete it. Otherwise the resource is left
        // in the cache and can be reused by the new service worker.
        if (!RESOURCES[key] || RESOURCES[key] != oldManifest[key]) {
          await contentCache.delete(request);
        }
      }
      // Populate the cache with the app shell TEMP files, potentially overwriting
      // cache files preserved above.
      for (var request of await tempCache.keys()) {
        var response = await tempCache.match(request);
        await contentCache.put(request, response);
      }
      await caches.delete(TEMP);
      // Save the manifest to make future upgrades efficient.
      await manifestCache.put('manifest', new Response(JSON.stringify(RESOURCES)));
      // Claim client to enable caching on first launch
      self.clients.claim();
      return;
    } catch (err) {
      // On an unhandled exception the state of the cache cannot be guaranteed.
      console.error('Failed to upgrade service worker: ' + err);
      await caches.delete(CACHE_NAME);
      await caches.delete(TEMP);
      await caches.delete(MANIFEST);
    }
  }());
});
// The fetch handler redirects requests for RESOURCE files to the service
// worker cache.
self.addEventListener("fetch", (event) => {
  if (event.request.method !== 'GET') {
    return;
  }
  var origin = self.location.origin;
  var key = event.request.url.substring(origin.length + 1);
  // Redirect URLs to the index.html
  if (key.indexOf('?v=') != -1) {
    key = key.split('?v=')[0];
  }
  if (event.request.url == origin || event.request.url.startsWith(origin + '/#') || key == '') {
    key = '/';
  }
  // If the URL is not the RESOURCE list then return to signal that the
  // browser should take over.
  if (!RESOURCES[key]) {
    return;
  }
  // If the URL is the index.html, perform an online-first request.
  if (key == '/') {
    return onlineFirst(event);
  }
  event.respondWith(caches.open(CACHE_NAME)
    .then((cache) =>  {
      return cache.match(event.request).then((response) => {
        // Either respond with the cached resource, or perform a fetch and
        // lazily populate the cache only if the resource was successfully fetched.
        return response || fetch(event.request).then((response) => {
          if (response && Boolean(response.ok)) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      })
    })
  );
});
self.addEventListener('message', (event) => {
  // SkipWaiting can be used to immediately activate a waiting service worker.
  // This will also require a page refresh triggered by the main worker.
  if (event.data === 'skipWaiting') {
    self.skipWaiting();
    return;
  }
  if (event.data === 'downloadOffline') {
    downloadOffline();
    return;
  }
});
// Download offline will check the RESOURCES for all files not in the cache
// and populate them.
async function downloadOffline() {
  var resources = [];
  var contentCache = await caches.open(CACHE_NAME);
  var currentContent = {};
  for (var request of await contentCache.keys()) {
    var key = request.url.substring(origin.length + 1);
    if (key == "") {
      key = "/";
    }
    currentContent[key] = true;
  }
  for (var resourceKey of Object.keys(RESOURCES)) {
    if (!currentContent[resourceKey]) {
      resources.push(resourceKey);
    }
  }
  return contentCache.addAll(resources);
}
// Attempt to download the resource online before falling back to
// the offline cache.
function onlineFirst(event) {
  return event.respondWith(
    fetch(event.request).then((response) => {
      return caches.open(CACHE_NAME).then((cache) => {
        cache.put(event.request, response.clone());
        return response;
      });
    }).catch((error) => {
      return caches.open(CACHE_NAME).then((cache) => {
        return cache.match(event.request).then((response) => {
          if (response != null) {
            return response;
          }
          throw error;
        });
      });
    })
  );
}
